/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.util.FacesLogger;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cache<K, V> {
    private static final Logger LOGGER = FacesLogger.UTIL.getLogger();
    private ConcurrentMap<K, Future<V>> cache = new ConcurrentHashMap<K, Future<V>>();
    private Factory<K, V> factory;

    public Cache(Factory<K, V> factory) {
        this.factory = factory;
    }

    /*
     * Loose catch block
     */
    public V get(final K key) {
        while (true) {
            Callable callable;
            FutureTask ft;
            FutureTask f;
            if ((f = (FutureTask)this.cache.get(key)) == null && (f = (Future)this.cache.putIfAbsent(key, ft = new FutureTask(callable = new Callable<V>(){

                @Override
                public V call() throws Exception {
                    return Cache.this.factory.newInstance(key);
                }
            }))) == null) {
                f = ft;
                ft.run();
            }
            try {
                return f.get();
            }
            catch (CancellationException ce) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, ce.toString(), ce);
                }
                this.cache.remove(key);
                continue;
            }
            catch (InterruptedException ie) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, ie.toString(), ie);
                }
                this.cache.remove(key);
                continue;
            }
            break;
        }
        catch (ExecutionException ee) {
            throw new FacesException((Throwable)ee);
        }
    }

    public V remove(K key) {
        Future t = (Future)this.cache.remove(key);
        V result = null;
        if (null != t) {
            try {
                result = t.get();
            }
            catch (CancellationException ce) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, ce.toString(), ce);
                }
            }
            catch (InterruptedException ie) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, ie.toString(), ie);
                }
            }
            catch (ExecutionException ee) {
                throw new FacesException((Throwable)ee);
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Factory<K, V> {
        public V newInstance(K var1) throws InterruptedException;
    }
}

