/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.util.concurrent.Executor;
import org.jboss.remoting3.ClientContextImpl;
import org.jboss.remoting3.ClientListener;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.TerminatingLocalRequestHandler;
import org.jboss.remoting3.spi.LocalRequestHandler;
import org.jboss.xnio.OptionMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RequestHandlerFactory<I, O> {
    private final Executor executor;
    private final ClientListener<? super I, ? extends O> clientListener;
    private final Class<I> requestClass;
    private final Class<O> replyClass;
    private final ClassLoader serviceClassLoader;

    RequestHandlerFactory(Executor executor, ClientListener<? super I, ? extends O> clientListener, Class<I> requestClass, Class<O> replyClass, ClassLoader serviceClassLoader) {
        this.executor = executor;
        this.clientListener = clientListener;
        this.requestClass = requestClass;
        this.replyClass = replyClass;
        this.serviceClassLoader = serviceClassLoader;
    }

    static <I, O> RequestHandlerFactory<I, O> create(Executor executor, ClientListener<? super I, ? extends O> clientListener, Class<I> requestClass, Class<O> replyClass, ClassLoader serviceClassLoader) {
        return new RequestHandlerFactory<I, O>(executor, clientListener, requestClass, replyClass, serviceClassLoader);
    }

    LocalRequestHandler createRequestHandler(Connection connection, OptionMap optionMap) {
        ClientContextImpl context = new ClientContextImpl(this.executor, connection);
        return new TerminatingLocalRequestHandler<I, O>(this.executor, this.clientListener.handleClientOpen(context, optionMap), context, this.requestClass, this.replyClass, this.serviceClassLoader);
    }

    Class<I> getRequestClass() {
        return this.requestClass;
    }

    Class<O> getReplyClass() {
        return this.replyClass;
    }

    ClassLoader getServiceClassLoader() {
        return this.serviceClassLoader;
    }
}

