/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.AttachmentsImpl;
import org.jboss.remoting3.Client;
import org.jboss.remoting3.ClientConnector;
import org.jboss.remoting3.ClientConnectorImpl;
import org.jboss.remoting3.ClientContextImpl;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.EndpointImpl;
import org.jboss.remoting3.RequestListener;
import org.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.jboss.remoting3.spi.ConnectionHandler;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.jboss.remoting3.spi.LocalRequestHandler;
import org.jboss.remoting3.spi.RemoteRequestHandler;
import org.jboss.remoting3.spi.RequestHandlerConnector;
import org.jboss.remoting3.spi.SpiUtils;
import org.jboss.xnio.FutureResult;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Result;
import org.jboss.xnio.TranslatingResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConnectionImpl
extends AbstractHandleableCloseable<Connection>
implements Connection {
    private final Attachments attachments = new AttachmentsImpl();
    private final EndpointImpl endpoint;
    private final ConnectionHandler connectionHandler;
    private final String name;

    ConnectionImpl(EndpointImpl endpoint, ConnectionHandlerFactory connectionHandlerFactory, ConnectionProviderContext connectionProviderContext, String name) {
        super(endpoint.getExecutor());
        this.endpoint = endpoint;
        this.name = name;
        EndpointImpl endpointImpl = endpoint;
        endpointImpl.getClass();
        this.connectionHandler = connectionHandlerFactory.createInstance(endpointImpl.new EndpointImpl.LocalConnectionContext(connectionProviderContext, this));
    }

    @Override
    protected void closeAction() throws IOException {
        this.connectionHandler.close();
    }

    @Override
    public <I, O> IoFuture<? extends Client<I, O>> openClient(String serviceType, String groupName, Class<I> requestClass, Class<O> replyClass) {
        return this.openClient(serviceType, groupName, requestClass, replyClass, OptionMap.EMPTY);
    }

    @Override
    public <I, O> IoFuture<? extends Client<I, O>> openClient(String serviceType, String groupName, Class<I> requestClass, Class<O> replyClass, OptionMap optionMap) {
        SecurityManager sm = System.getSecurityManager();
        ClassLoader classLoader = sm == null ? Thread.currentThread().getContextClassLoader() : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        return this.openClient(serviceType, groupName, requestClass, replyClass, classLoader, optionMap);
    }

    @Override
    public <I, O> IoFuture<? extends Client<I, O>> openClient(String serviceType, String groupName, Class<I> requestClass, Class<O> replyClass, ClassLoader classLoader, OptionMap optionMap) {
        FutureResult futureResult = new FutureResult();
        futureResult.addCancelHandler(this.connectionHandler.open(serviceType, groupName, (Result<RemoteRequestHandler>)new ClientWrapper<I, O>(this.endpoint, futureResult, requestClass, replyClass, classLoader), classLoader, optionMap));
        return futureResult.getIoFuture();
    }

    @Override
    public <I, O> ClientConnector<I, O> createClientConnector(RequestListener<I, O> listener, Class<I> requestClass, Class<O> replyClass) throws IOException {
        return this.createClientConnector(listener, requestClass, replyClass, OptionMap.EMPTY);
    }

    @Override
    public <I, O> ClientConnector<I, O> createClientConnector(RequestListener<I, O> listener, Class<I> requestClass, Class<O> replyClass, OptionMap optionMap) throws IOException {
        ClientContextImpl context = new ClientContextImpl(this.getExecutor(), this);
        LocalRequestHandler localRequestHandler = this.endpoint.createLocalRequestHandler(listener, context, requestClass, replyClass);
        RequestHandlerConnector connector = this.connectionHandler.createConnector(localRequestHandler);
        context.addCloseHandler(SpiUtils.closingCloseHandler(localRequestHandler));
        return new ClientConnectorImpl<I, O>(connector, this.endpoint, requestClass, replyClass, context);
    }

    @Override
    public Attachments getAttachments() {
        return this.attachments;
    }

    public String toString() {
        return "Connection to " + this.name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClientWrapper<I, O>
    extends TranslatingResult<RemoteRequestHandler, Client<I, O>> {
        private final Class<I> requestClass;
        private final Class<O> replyClass;
        private final EndpointImpl endpoint;
        private final ClassLoader classLoader;

        public ClientWrapper(EndpointImpl endpoint, FutureResult<Client<I, O>> futureResult, Class<I> requestClass, Class<O> replyClass, ClassLoader classLoader) {
            super(futureResult);
            this.requestClass = requestClass;
            this.replyClass = replyClass;
            this.endpoint = endpoint;
            this.classLoader = classLoader;
        }

        protected Client<I, O> translate(RemoteRequestHandler input) throws IOException {
            return this.endpoint.createClient(input, this.requestClass, this.replyClass, this.classLoader);
        }
    }
}

