/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.AttachmentsImpl;
import org.jboss.remoting3.Client;
import org.jboss.remoting3.FutureReplyImpl;
import org.jboss.remoting3.IndeterminateOutcomeException;
import org.jboss.remoting3.QueueExecutor;
import org.jboss.remoting3.RemoteRequestException;
import org.jboss.remoting3.TypedRequest;
import org.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.jboss.remoting3.spi.LocalReplyHandler;
import org.jboss.remoting3.spi.RemoteRequestHandler;
import org.jboss.remoting3.spi.SpiUtils;
import org.jboss.xnio.Cancellable;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClientImpl<I, O>
extends AbstractHandleableCloseable<Client<I, O>>
implements Client<I, O> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.remoting.client");
    private final RemoteRequestHandler handler;
    private final Class<I> requestClass;
    private final Class<O> replyClass;
    private final ClassLoader clientClassLoader;
    private final Attachments attachments = new AttachmentsImpl();

    private ClientImpl(RemoteRequestHandler handler, Executor executor, Class<I> requestClass, Class<O> replyClass, ClassLoader clientClassLoader) {
        super(executor);
        this.handler = handler;
        this.requestClass = requestClass;
        this.replyClass = replyClass;
        this.clientClassLoader = clientClassLoader;
    }

    static <I, O> ClientImpl<I, O> create(RemoteRequestHandler handler, Executor executor, Class<I> requestClass, Class<O> replyClass, ClassLoader clientClassLoader) {
        ClientImpl<I, O> ci = new ClientImpl<I, O>(handler, executor, requestClass, replyClass, clientClassLoader);
        handler.addCloseHandler(SpiUtils.closingCloseHandler(ci));
        return ci;
    }

    @Override
    public Attachments getAttachments() {
        return this.attachments;
    }

    @Override
    protected void closeAction() throws IOException {
        this.handler.close();
    }

    @Override
    public O invoke(I request) throws IOException {
        return this.invoke(request, this.replyClass);
    }

    @Override
    public <T extends O> T invoke(I request, Class<T> replyClass) throws IOException, CancellationException {
        if (!this.isOpen()) {
            throw new IOException("Client is not open");
        }
        log.trace("Client.invoke() sending request \"%s\"", request);
        I actualRequest = this.castRequest(request);
        QueueExecutor executor = new QueueExecutor();
        FutureReplyImpl<T> futureReply = new FutureReplyImpl<T>((Executor)((Object)executor), replyClass, this.clientClassLoader);
        LocalReplyHandler replyHandler = futureReply.getReplyHandler();
        Cancellable requestContext = this.handler.receiveRequest(actualRequest, replyHandler);
        futureReply.setRemoteRequestContext(requestContext);
        futureReply.addNotifier(IoUtils.attachmentClosingNotifier(), executor);
        executor.runQueue();
        try {
            Object reply = futureReply.getInterruptibly();
            log.trace("Client.invoke() received reply \"%s\"", reply);
            return (T)reply;
        }
        catch (InterruptedException e) {
            try {
                futureReply.cancel();
                throw new IndeterminateOutcomeException("The current thread was interrupted before the result could be read");
            }
            catch (Throwable throwable) {
                Thread.currentThread().interrupt();
                throw throwable;
            }
        }
    }

    @Override
    public <T extends O> T invokeTyped(TypedRequest<? extends I, T> typedRequest) throws IOException, CancellationException {
        if (!this.isOpen()) {
            throw new IOException("Client is not open");
        }
        log.trace("Client.invoke() sending request \"%s\"", typedRequest);
        I actualRequest = this.castRequest(typedRequest);
        QueueExecutor executor = new QueueExecutor();
        FutureReplyImpl<T> futureReply = new FutureReplyImpl<T>((Executor)((Object)executor), typedRequest, this.clientClassLoader);
        LocalReplyHandler replyHandler = futureReply.getReplyHandler();
        Cancellable requestContext = this.handler.receiveRequest(actualRequest, replyHandler);
        futureReply.setRemoteRequestContext(requestContext);
        futureReply.addNotifier(IoUtils.attachmentClosingNotifier(), executor);
        executor.runQueue();
        try {
            Object reply = futureReply.getInterruptibly();
            log.trace("Client.invoke() received reply \"%s\"", reply);
            return (T)reply;
        }
        catch (InterruptedException e) {
            try {
                futureReply.cancel();
                throw new IndeterminateOutcomeException("The current thread was interrupted before the result could be read");
            }
            catch (Throwable throwable) {
                Thread.currentThread().interrupt();
                throw throwable;
            }
        }
    }

    @Override
    public IoFuture<? extends O> send(I request) throws IOException {
        return this.send(request, this.replyClass);
    }

    @Override
    public <T extends O> IoFuture<? extends T> send(I request, Class<T> replyClass) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("Client is not open");
        }
        log.trace("Client.send() sending request \"%s\"", request);
        I actualRequest = this.castRequest(request);
        FutureReplyImpl<T> futureReply = new FutureReplyImpl<T>(this.getExecutor(), replyClass, this.clientClassLoader);
        LocalReplyHandler replyHandler = futureReply.getReplyHandler();
        Cancellable requestContext = this.handler.receiveRequest(actualRequest, replyHandler);
        futureReply.setRemoteRequestContext(requestContext);
        return futureReply;
    }

    @Override
    public <T extends O> IoFuture<? extends T> sendTyped(TypedRequest<? extends I, T> typedRequest) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("Client is not open");
        }
        log.trace("Client.send() sending request \"%s\"", typedRequest);
        I actualRequest = this.castRequest(typedRequest);
        FutureReplyImpl<T> futureReply = new FutureReplyImpl<T>(this.getExecutor(), typedRequest, this.clientClassLoader);
        LocalReplyHandler replyHandler = futureReply.getReplyHandler();
        Cancellable requestContext = this.handler.receiveRequest(actualRequest, replyHandler);
        futureReply.setRemoteRequestContext(requestContext);
        return futureReply;
    }

    private I castRequest(Object request) throws RemoteRequestException {
        try {
            return this.requestClass.cast(request);
        }
        catch (ClassCastException e) {
            throw new RemoteRequestException("Invalid request type sent (got <" + request.getClass().getName() + ">, expected <? extends " + this.requestClass.getName() + ">");
        }
    }

    public String toString() {
        return "client instance <" + Integer.toHexString(this.hashCode()) + ">";
    }

    RemoteRequestHandler getRequestHandler() {
        return this.handler;
    }

    Class<I> getRequestClass() {
        return this.requestClass;
    }

    Class<O> getReplyClass() {
        return this.replyClass;
    }
}

