/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.ResourceBundle;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.ws.rm.Identifier;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.SequenceAcknowledgement;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.SequenceFaultType;

class SequenceFaultFactory {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(SequenceFaultFactory.class);

    SequenceFaultFactory() {
    }

    SequenceFault createUnknownSequenceFault(Identifier sid) {
        SequenceFaultType sf = RMUtils.getWSRMFactory().createSequenceFaultType();
        sf.setFaultCode(RMConstants.getUnknownSequenceFaultCode());
        Message msg = new Message("UNKNOWN_SEQ_EXC", BUNDLE, new Object[0]);
        SequenceFault fault = new SequenceFault(msg.toString());
        fault.setSequenceFault(sf);
        fault.setDetail(sid);
        fault.setSender(true);
        return fault;
    }

    SequenceFault createSequenceTerminatedFault(Identifier sid, boolean sender) {
        SequenceFaultType sf = RMUtils.getWSRMFactory().createSequenceFaultType();
        sf.setFaultCode(RMConstants.getSequenceTerminatedFaultCode());
        Message msg = new Message("SEQ_TERMINATED_EXC", BUNDLE, new Object[0]);
        SequenceFault fault = new SequenceFault(msg.toString());
        fault.setSequenceFault(sf);
        fault.setDetail(sid);
        fault.setSender(sender);
        return fault;
    }

    SequenceFault createInvalidAcknowledgementFault(SequenceAcknowledgement ack) {
        SequenceFaultType sf = RMUtils.getWSRMFactory().createSequenceFaultType();
        sf.setFaultCode(RMConstants.getInvalidAcknowledgmentFaultCode());
        Message msg = new Message("INVALID_ACK_EXC", BUNDLE, new Object[0]);
        SequenceFault fault = new SequenceFault(msg.toString());
        fault.setSequenceFault(sf);
        fault.setDetail(ack);
        fault.setSender(true);
        return fault;
    }

    SequenceFault createMessageNumberRolloverFault(Identifier sid) {
        SequenceFaultType sf = RMUtils.getWSRMFactory().createSequenceFaultType();
        sf.setFaultCode(RMConstants.getMessageNumberRolloverFaultCode());
        Message msg = new Message("MESSAGE_NR_ROLLOVER_EXC", BUNDLE, new Object[0]);
        SequenceFault fault = new SequenceFault(msg.toString());
        fault.setSequenceFault(sf);
        fault.setDetail(sid);
        fault.setSender(true);
        return fault;
    }

    SequenceFault createLastMessageNumberExceededFault(Identifier sid) {
        SequenceFaultType sf = RMUtils.getWSRMFactory().createSequenceFaultType();
        sf.setFaultCode(RMConstants.getLastMessageNumberExceededFaultCode());
        Message msg = new Message("LAST_MESSAGE_NUMBER_EXCEEDED_EXC", BUNDLE, new Object[0]);
        SequenceFault fault = new SequenceFault(msg.toString());
        fault.setSequenceFault(sf);
        fault.setDetail(sid);
        fault.setSender(true);
        return fault;
    }

    SequenceFault createCreateSequenceRefusedFault() {
        SequenceFaultType sf = RMUtils.getWSRMFactory().createSequenceFaultType();
        sf.setFaultCode(RMConstants.getCreateSequenceRefusedFaultCode());
        Message msg = new Message("CREATE_SEQ_REFUSED", BUNDLE, new Object[0]);
        SequenceFault fault = new SequenceFault(msg.toString());
        fault.setSequenceFault(sf);
        fault.setSender(true);
        return fault;
    }
}

