/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming.client.java;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.ObjectFactory;
import org.jboss.corba.ORBFactory;
import org.jboss.logging.Logger;
import org.jboss.naming.client.java.HandleDelegateFactory;

public class javaURLContextFactory
implements ObjectFactory {
    private static final Logger log = Logger.getLogger(javaURLContextFactory.class);
    public static final String J2EE_CLIENT_NAME_PROP = "j2ee.clientName";

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env) throws Exception {
        String clientName = (String)env.get(J2EE_CLIENT_NAME_PROP);
        if (clientName == null && (clientName = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty(javaURLContextFactory.J2EE_CLIENT_NAME_PROP);
                }
                catch (SecurityException e) {
                    return null;
                }
            }
        })) == null) {
            throw new NamingException("Failed to find j2ee.clientName in jndi env");
        }
        Object result = null;
        if (nameCtx == null) {
            nameCtx = new InitialContext(env);
        }
        if (obj == null) {
            EncContextProxy handler = new EncContextProxy(nameCtx, clientName);
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class[] ifaces = new Class[]{Context.class};
            result = Proxy.newProxyInstance(loader, ifaces, (InvocationHandler)handler);
        }
        return result;
    }

    private static class EncContextProxy
    implements InvocationHandler {
        Context lookupCtx;
        String clientName;

        EncContextProxy(Context lookupCtx, String clientName) {
            this.lookupCtx = lookupCtx;
            this.clientName = clientName;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("toString")) {
                return "Client ENC(" + this.clientName + ")";
            }
            if (!methodName.equals("lookup")) {
                throw new OperationNotSupportedException("Only lookup is supported, op=" + method);
            }
            NameParser parser = this.lookupCtx.getNameParser("");
            Name name = null;
            name = args[0] instanceof String ? parser.parse((String)args[0]) : (Name)args[0];
            if (name.size() < 2 || !"java:comp".equals(name.get(0)) || !"env".equals(name.get(1))) {
                return this.getSpecialObject(name);
            }
            Context clientCtx = (Context)this.lookupCtx.lookup(this.clientName);
            try {
                clientCtx = (Context)clientCtx.lookup("env");
            }
            catch (NamingException e) {
                log.trace((Object)"No env sub context found", (Throwable)e);
            }
            Name bindingName = name.getSuffix(2);
            Object binding = clientCtx.lookup(bindingName);
            return binding;
        }

        public Object getSpecialObject(Name name) throws NamingException {
            if (name.size() > 0 && "java:comp".equals(name.get(0))) {
                if (name.size() == 2 && "ORB".equals(name.get(1))) {
                    return ORBFactory.getORB();
                }
                if (name.size() == 2 && "HandleDelegate".equals(name.get(1))) {
                    return HandleDelegateFactory.getHandleDelegateSingleton();
                }
            }
            throw new NamingException("Name not found " + name);
        }
    }
}

