/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.event.log;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.pluginapi.event.EventContext;
import org.rhq.core.pluginapi.event.log.Log4JLogEntryProcessor;
import org.rhq.core.pluginapi.event.log.LogFileEventPoller;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;

public class LogFileEventResourceComponentHelper {
    public static final String LOG_ENTRY_EVENT_TYPE = "logEntry";
    public static final String LOG_EVENT_SOURCES_CONFIG_PROP = "logEventSources";
    public static final String LOG_EVENT_SOURCE_CONFIG_PROP = "logEventSource";
    private final Log log = LogFactory.getLog(this.getClass());
    private ResourceContext resourceContext;

    public LogFileEventResourceComponentHelper(ResourceContext resourceContext) {
        this.resourceContext = resourceContext;
    }

    public void startLogFileEventPollers() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        PropertyList logEventSources = pluginConfig.getList(LOG_EVENT_SOURCES_CONFIG_PROP);
        for (Property prop : logEventSources.getList()) {
            String minimumSeverityString;
            String includesPatternString;
            PropertyMap logEventSource = (PropertyMap)prop;
            Boolean enabled = Boolean.valueOf(logEventSource.getSimpleValue("enabled", null));
            if (!enabled.booleanValue()) continue;
            String logFilePathname = logEventSource.getSimpleValue("logFilePath", null);
            if (logFilePathname == null) {
                this.log.info((Object)"LOGFILE: No logfile path given, can not watch this event log.");
                return;
            }
            File logFile = new File(logFilePathname);
            if (!logFile.exists() || !logFile.canRead()) {
                this.log.error((Object)("LOGFILE: Logfile at location " + logFilePathname + " does not exist or is not readable. Can not start watching the event log."));
                return;
            }
            Log4JLogEntryProcessor processor = new Log4JLogEntryProcessor(LOG_ENTRY_EVENT_TYPE, logFile);
            String dateFormatString = logEventSource.getSimpleValue("dateFormat", null);
            if (dateFormatString != null) {
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatString);
                    processor.setDateFormat(dateFormat);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidPluginConfigurationException("Date format [" + dateFormatString + "] is not a valid simple date format.");
                }
            }
            if ((includesPatternString = logEventSource.getSimpleValue("includesPattern", null)) != null) {
                try {
                    Pattern includesPattern = Pattern.compile(includesPatternString);
                    processor.setIncludesPattern(includesPattern);
                }
                catch (PatternSyntaxException e) {
                    throw new InvalidPluginConfigurationException("Includes pattern [" + includesPatternString + "] is not a valid regular expression.");
                }
            }
            if ((minimumSeverityString = logEventSource.getSimpleValue("minimumSeverity", null)) != null) {
                EventSeverity minimumSeverity = EventSeverity.valueOf((String)minimumSeverityString.toUpperCase());
                processor.setMinimumSeverity(minimumSeverity);
            }
            EventContext eventContext = this.resourceContext.getEventContext();
            LogFileEventPoller poller = new LogFileEventPoller(eventContext, LOG_ENTRY_EVENT_TYPE, logFile, processor);
            eventContext.registerEventPoller(poller, 60, logFile.getPath());
        }
    }

    public void stopLogFileEventPollers() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        PropertyList logEventSources = pluginConfig.getList(LOG_EVENT_SOURCES_CONFIG_PROP);
        for (Property prop : logEventSources.getList()) {
            PropertyMap logEventSource = (PropertyMap)prop;
            String logFilePath = logEventSource.getSimpleValue("logFilePath", null);
            EventContext eventContext = this.resourceContext.getEventContext();
            eventContext.unregisterEventPoller(LOG_ENTRY_EVENT_TYPE, logFilePath);
        }
    }

    public static abstract class LogEventSourcePropertyNames {
        public static final String LOG_FILE_PATH = "logFilePath";
        public static final String ENABLED = "enabled";
        public static final String DATE_FORMAT = "dateFormat";
        public static final String INCLUDES_PATTERN = "includesPattern";
        public static final String MINIMUM_SEVERITY = "minimumSeverity";
    }
}

