/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.hash;

import org.infinispan.util.ByteArrayKey;

public class MurmurHash2 {
    private static final int M = 1540483477;
    private static final int R = 24;
    private static final int H = -1;

    public static final int hash(byte[] payload) {
        int h = -1;
        int len = payload.length;
        int offset = 0;
        while (len >= 4) {
            int k = payload[offset];
            k |= payload[offset + 1] << 8;
            k |= payload[offset + 2] << 16;
            k |= payload[offset + 3] << 24;
            k *= 1540483477;
            k ^= k >> 24;
            h *= 1540483477;
            h ^= (k *= 1540483477);
            len -= 4;
            offset += 4;
        }
        switch (len) {
            case 3: {
                h ^= payload[offset + 2] << 16;
            }
            case 2: {
                h ^= payload[offset + 1] << 8;
            }
            case 1: {
                h ^= payload[offset];
                h *= 1540483477;
            }
        }
        h ^= h >> 13;
        h *= 1540483477;
        h ^= h >> 15;
        return h;
    }

    public static final int hash(int hashcode) {
        byte[] b = new byte[]{(byte)hashcode, (byte)(hashcode >> 8), (byte)(hashcode >> 16), (byte)(hashcode >> 24)};
        return MurmurHash2.hash(b);
    }

    public static final int hash(Object o) {
        if (o instanceof byte[]) {
            return MurmurHash2.hash((byte[])o);
        }
        if (o instanceof String) {
            return MurmurHash2.hash(((String)o).getBytes());
        }
        if (o instanceof ByteArrayKey) {
            return MurmurHash2.hash(((ByteArrayKey)o).getData());
        }
        return MurmurHash2.hash(o.hashCode());
    }
}

