/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks.containers;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.infinispan.util.concurrent.locks.containers.AbstractPerEntryLockContainer;

public class ReentrantPerEntryLockContainer
extends AbstractPerEntryLockContainer {
    public ReentrantPerEntryLockContainer(int concurrencyLevel) {
        super(concurrencyLevel);
    }

    @Override
    protected Lock newLock() {
        return new ReentrantLock();
    }

    @Override
    public boolean ownsLock(Object key, Object owner) {
        ReentrantLock l = this.getLockFromMap(key);
        return l != null && l.isHeldByCurrentThread();
    }

    @Override
    public boolean isLocked(Object key) {
        ReentrantLock l = this.getLockFromMap(key);
        return l != null && l.isLocked();
    }

    private ReentrantLock getLockFromMap(Object key) {
        return (ReentrantLock)this.locks.get(key);
    }
}

