/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config.parsing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.infinispan.util.FileLookup;
import org.infinispan.util.Util;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ConfigFilesConvertor {
    static final String JBOSS_CACHE3X = "JBossCache3x";
    static final String EHCACHE_CACHE1X = "Ehcache1x";
    static final String COHERENCE_35X = "Coherence35x";
    static final Map<String, String> TRANSFORMATIONS = new HashMap<String, String>(4);

    public void parse(InputStream is, OutputStream os, String xsltFile) throws Exception {
        InputStream xsltInStream = new FileLookup().lookupFile(xsltFile);
        if (xsltInStream == null) {
            throw new IllegalStateException("Cold not find xslt file! : " + xsltFile);
        }
        Document document = this.getInputDocument(is);
        Transformer transformer = this.getTransformer(xsltInStream);
        DOMSource source = new DOMSource(document);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(byteArrayOutputStream);
        transformer.transform(source, result);
        InputStream indentation = new FileLookup().lookupFile("xslt/indent.xslt");
        transformer = this.getTransformer(indentation);
        StreamResult finalResult = new StreamResult(os);
        StreamSource rawResult = new StreamSource(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        transformer.transform(rawResult, finalResult);
        xsltInStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String inputFile, OutputStream os, String xsltFile) throws Exception {
        InputStream stream = new FileLookup().lookupFile(inputFile);
        try {
            this.parse(stream, os, xsltFile);
        }
        finally {
            stream.close();
        }
    }

    private static void help() {
        System.out.println("Usage:");
        System.out.println("importConfig [-source <the file to be transformed>] [-destination <where to store resulting XML>] [-type <the type of the source, possible values being: " + ConfigFilesConvertor.getSupportedFormats() + " >]");
    }

    public static void main(String[] args) throws Exception {
        String sourceName = null;
        String destinationName = null;
        String type = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-source")) {
                sourceName = args[++i];
                continue;
            }
            if (args[i].equals("-destination")) {
                destinationName = args[++i];
                continue;
            }
            if (args[i].equals("-type")) {
                type = args[++i];
                continue;
            }
            ConfigFilesConvertor.help();
        }
        ConfigFilesConvertor.mustExist(sourceName, "source");
        ConfigFilesConvertor.mustExist(destinationName, "destination");
        ConfigFilesConvertor.mustExist(type, "type");
        if (!TRANSFORMATIONS.containsKey(type)) {
            System.err.println("Unsupported transformation type: " + type + ". Supported formats are: " + ConfigFilesConvertor.getSupportedFormats());
        }
        if (type.equals(JBOSS_CACHE3X)) {
            ConfigFilesConvertor.transformFromJbossCache3x(sourceName, destinationName);
        } else {
            ConfigFilesConvertor.transformFromNonJBoss(sourceName, destinationName, TRANSFORMATIONS.get(type));
        }
        System.out.println("---");
        System.out.println("New configuration file [" + destinationName + "] successfully created.");
        System.out.println("---");
    }

    private static String getSupportedFormats() {
        LinkedList<String> supported = new LinkedList<String>(TRANSFORMATIONS.keySet());
        Collections.sort(supported);
        return ((Object)supported).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void transformFromNonJBoss(String sourceName, String destinationName, String xslt) throws Exception {
        File oldConfig = new File(sourceName);
        if (!oldConfig.exists()) {
            System.err.println("File specified as input ('" + sourceName + ") does not exist.");
            System.exit(1);
        }
        ConfigFilesConvertor convertor = new ConfigFilesConvertor();
        FileInputStream is = null;
        FileOutputStream fos = null;
        try {
            is = new FileInputStream(oldConfig);
            File destination = new File(destinationName);
            if (!destination.exists() && !destination.createNewFile()) {
                System.err.println("Warn! Could not create file " + destination);
            }
            fos = new FileOutputStream(destinationName);
            convertor.parse(is, (OutputStream)fos, xslt);
        }
        catch (Throwable throwable) {
            Util.flushAndCloseStream(fos);
            Util.close(is);
            throw throwable;
        }
        Util.flushAndCloseStream(fos);
        Util.close(is);
    }

    private static void mustExist(String sourceName, String what) {
        if (sourceName == null) {
            System.err.println("Missing '" + what + "', cannot proceed");
            ConfigFilesConvertor.help();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void transformFromJbossCache3x(String sourceName, String destinationName) throws Exception {
        File oldConfig = new File(sourceName);
        if (!oldConfig.exists()) {
            System.err.println("File specified as input ('" + sourceName + ") does not exist.");
            System.exit(1);
        }
        ConfigFilesConvertor convertor = new ConfigFilesConvertor();
        FileInputStream is = null;
        FileOutputStream fos = null;
        File jgroupsConfigFile = new File("jgroupsConfig.xml");
        try {
            is = new FileInputStream(oldConfig);
            File destination = new File(destinationName);
            if (!destination.exists() && !destination.createNewFile()) {
                System.err.println("Problems creating destination file: " + destination);
            }
            fos = new FileOutputStream(destinationName);
            convertor.parse(is, (OutputStream)fos, "xslt/jbc3x2infinispan4x.xslt");
            fos.close();
            is.close();
            if (jgroupsConfigFile.exists() && !jgroupsConfigFile.delete()) {
                System.err.println("Problems deleting existing jgroups file: " + jgroupsConfigFile);
            }
            if (!jgroupsConfigFile.createNewFile()) {
                System.err.println("Could not create jgroupsConfigFile: " + jgroupsConfigFile);
            }
            is = new FileInputStream(oldConfig);
            fos = new FileOutputStream(jgroupsConfigFile);
            convertor = new ConfigFilesConvertor();
            convertor.parse(is, (OutputStream)fos, "xslt/jgroupsFileGen.xslt");
        }
        catch (Throwable throwable) {
            Util.close(is);
            Util.flushAndCloseStream(fos);
            throw throwable;
        }
        Util.close(is);
        Util.flushAndCloseStream(fos);
        if (jgroupsConfigFile.length() < 5L) {
            jgroupsConfigFile.delete();
        }
    }

    private Transformer getTransformer(InputStream xsltInStream) throws TransformerConfigurationException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        StreamSource stylesource = new StreamSource(xsltInStream);
        return tFactory.newTransformer(stylesource);
    }

    private Document getInputDocument(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(is);
    }

    static {
        TRANSFORMATIONS.put(JBOSS_CACHE3X, "xslt/jbc3x2infinispan4.xslt");
        TRANSFORMATIONS.put(EHCACHE_CACHE1X, "xslt/ehcache1x2infinispan4x.xslt");
        TRANSFORMATIONS.put(COHERENCE_35X, "xslt/coherence35x2infinispan4x.xslt");
    }
}

