/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl.xmlschema;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSNamespaceItem;
import org.apache.xerces.xs.XSNamespaceItemList;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSComplexTypeDefinition;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSElementDeclaration;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModelGroup;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSParticle;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSTypeDefinition;
import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
import org.jboss.wsf.common.DOMWriter;
import org.jboss.xb.binding.NamespaceRegistry;

public class WSSchemaUtils {
    private static final String xsNS = "http://www.w3.org/2001/XMLSchema";
    private static SchemaUtils utils = SchemaUtils.getInstance();
    private NamespaceRegistry namespaceRegistry;
    private String targetNamespace = null;

    public static WSSchemaUtils getInstance(NamespaceRegistry namespaceRegistry, String targetNamespace) {
        return new WSSchemaUtils(namespaceRegistry, targetNamespace);
    }

    private WSSchemaUtils(NamespaceRegistry namespaceRegistry, String targetNamespace) {
        this.namespaceRegistry = namespaceRegistry;
        this.targetNamespace = targetNamespace;
    }

    public boolean checkCustomNamespace(String targetNS, String checkNS) {
        String[] nsarr = new String[]{xsNS, "http://www.w3.org/2001/XMLSchema-instance"};
        List<String> knownNamespaces = Arrays.asList(nsarr);
        boolean isCustom = false;
        if (xsNS.equals(targetNS)) {
            throw new IllegalArgumentException("targetNamespace cannot be http://www.w3.org/2001/XMLSchema");
        }
        if (checkNS == null) {
            throw new IllegalArgumentException("checkNS is null");
        }
        if (!knownNamespaces.contains(checkNS) && !targetNS.equals(checkNS)) {
            isCustom = true;
        }
        return isCustom;
    }

    public JBossXSElementDeclaration createGlobalXSElementDeclaration(String name, XSTypeDefinition xstype, String targetNS) {
        JBossXSElementDeclaration xsel = new JBossXSElementDeclaration();
        xsel.setName(name);
        xsel.setTypeDefinition(xstype);
        xsel.setTargetNamespace(targetNS);
        xsel.setNamespace(targetNS);
        xsel.setScope((short)1);
        return xsel;
    }

    public JBossXSModel createXSModel() {
        return new JBossXSModel();
    }

    public JBossXSComplexTypeDefinition createXSComplexTypeDefinition(String name, XSTypeDefinition baseType, List<XSParticle> xsparts, String typens) {
        if (xsparts == null) {
            return null;
        }
        JBossXSComplexTypeDefinition ct = new JBossXSComplexTypeDefinition();
        ct.setName(name);
        ct.setNamespace(typens);
        JBossXSModelGroup group = new JBossXSModelGroup();
        group.setCompositor((short)1);
        group.setParticles(xsparts);
        JBossXSParticle xspa = new JBossXSParticle(null, typens);
        xspa.setTerm((XSTerm)group);
        ct.setParticle(xspa);
        if (baseType != null) {
            ct.setDerivationMethod((short)1);
            ct.setBaseType(baseType);
        }
        return ct;
    }

    public JBossXSElementDeclaration createXSElementDeclaration(String name, XSTypeDefinition xstype, boolean isNillable) {
        JBossXSElementDeclaration xsel = new JBossXSElementDeclaration();
        xsel.setName(name);
        xsel.setTypeDefinition(xstype);
        xsel.setNillable(isNillable);
        return xsel;
    }

    public JBossXSParticle createXSParticle(String targetNS, boolean isArray, XSTerm xsterm) {
        JBossXSParticle xsp = new JBossXSParticle(null, targetNS);
        if (isArray) {
            xsp.setMaxOccurs(-1);
        }
        xsp.setTerm(xsterm);
        return xsp;
    }

    public JBossXSTypeDefinition createXSTypeDefinition(QName qname) {
        JBossXSTypeDefinition jbxs = new JBossXSTypeDefinition();
        jbxs.setName(qname.getLocalPart());
        jbxs.setNamespace(qname.getNamespaceURI());
        return jbxs;
    }

    public XSComplexTypeDefinition getExceptionType(String exname, String ns) {
        JBossXSParticle xsp = new JBossXSParticle();
        JBossXSComplexTypeDefinition ct = new JBossXSComplexTypeDefinition(exname, ns);
        ct.setParticle(xsp);
        return ct;
    }

    public JBossXSModel getJBossXSModel(XSModel xsmodel) {
        if (xsmodel instanceof JBossXSModel) {
            return (JBossXSModel)xsmodel;
        }
        JBossXSModel jbxs = new JBossXSModel();
        this.copyXSModel(xsmodel, jbxs);
        return jbxs;
    }

    public boolean isEmptySchema(JBossXSModel xsmodel, String namespace) {
        if (xsmodel == null) {
            return true;
        }
        if (namespace == null) {
            throw new WSException("Target Namespace of xsmodel is null");
        }
        XSNamedMap tmap = xsmodel.getComponentsByNamespace((short)3, namespace);
        XSNamedMap emap = xsmodel.getComponentsByNamespace((short)2, namespace);
        if (tmap != null && tmap.getLength() > 0) {
            return false;
        }
        return emap == null || emap.getLength() <= 0;
    }

    public void serialize(XSModel xsmodel, Writer writer) throws IOException {
        StringBuilder buffer = new StringBuilder();
        if (xsmodel instanceof JBossXSModel) {
            String str = ((JBossXSModel)xsmodel).serialize();
            buffer.append(str);
        } else {
            buffer.append("<schema ");
            XSNamespaceItemList itemlist = xsmodel.getNamespaceItems();
            this.appendSchemaDefinitions(buffer, itemlist);
            this.appendTypes(buffer, xsmodel);
            this.appendGlobalElements(buffer, xsmodel);
            buffer.append("</schema>");
        }
        writer.write(buffer.toString());
    }

    public void serializeEmptySchema(XSModel xsmodel, Writer writer) throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<schema ");
        XSNamespaceItemList itemlist = xsmodel.getNamespaceItems();
        this.appendSchemaDefinitions(buffer, itemlist);
        this.appendTypes(buffer, xsmodel);
        this.appendGlobalElements(buffer, xsmodel);
        buffer.append("</schema>");
        writer.write(buffer.toString());
    }

    public String write(XSElementDeclaration xsel, XSParticle xsp) {
        String namespace;
        XSTypeDefinition xst = xsel.getTypeDefinition();
        if (xst == null) {
            throw new IllegalStateException("Type xst is null");
        }
        boolean isGlobalRef = xsel.getScope() == 1;
        boolean isAnonType = xst.getAnonymous();
        StringBuilder buf = new StringBuilder();
        String elname = xsel.getName();
        String prefix = null;
        if (isGlobalRef) {
            namespace = xsel.getNamespace();
            prefix = this.getPrefix(namespace);
            buf.append("<element ref='" + prefix + ":" + elname + "'");
        } else {
            namespace = xst.getNamespace();
            String typename = xst.getName();
            if (!xsNS.equals(namespace)) {
                prefix = this.getPrefix(namespace);
                typename = prefix + ":" + typename;
            }
            buf.append("<element name='" + elname + "'");
            if (!isAnonType) {
                buf.append(" type='" + typename + "' ");
            }
        }
        if (xsel.getNillable()) {
            buf.append(" nillable='true' ");
        }
        int minoccurs = xsp.getMinOccurs();
        int maxoccurs = xsp.getMaxOccurs();
        if (!(minoccurs == 0 && maxoccurs == 0 || minoccurs == 1 && maxoccurs == 1)) {
            if (xsp.getMaxOccursUnbounded()) {
                buf.append(" maxOccurs='unbounded' ");
            } else {
                buf.append(" maxOccurs='" + xsp.getMaxOccurs() + "'");
            }
            buf.append(" minOccurs='" + xsp.getMinOccurs() + "'");
        }
        if (!isAnonType || isGlobalRef) {
            buf.append("/>");
        } else {
            buf.append(">").append(this.write(xst)).append("</element>");
        }
        return buf.toString();
    }

    public String write(XSAttributeDeclaration decl) {
        XSSimpleTypeDefinition xst = decl.getTypeDefinition();
        if (xst == null) {
            throw new IllegalStateException("Type xst is null");
        }
        boolean isGlobalRef = decl.getScope() == 1;
        boolean isAnonType = xst.getAnonymous();
        StringBuilder buf = new StringBuilder();
        String name = decl.getName();
        String prefix = null;
        if (isGlobalRef) {
            String namespace = decl.getNamespace();
            prefix = this.getPrefix(namespace);
            buf.append("<attribute ref='" + prefix + ":" + name + "'");
        } else {
            String namespace = xst.getNamespace();
            String typename = xst.getName();
            if (!xsNS.equals(namespace)) {
                prefix = this.getPrefix(namespace);
                typename = prefix + ":" + typename;
            }
            buf.append("<attribute name='" + name + "'");
            if (!isAnonType) {
                buf.append(" type='" + typename + "' ");
            }
        }
        if (!isAnonType) {
            buf.append("/>");
        } else {
            buf.append(">").append(this.write((XSTypeDefinition)xst)).append("</attribute>");
        }
        return buf.toString();
    }

    public String write(XSElementDeclaration xsel) {
        boolean isAnonType = false;
        if (1 != xsel.getScope()) {
            throw new IllegalArgumentException("Element is not a global element");
        }
        StringBuilder buf = new StringBuilder();
        String elname = xsel.getName();
        XSTypeDefinition xst = xsel.getTypeDefinition();
        isAnonType = xst.getAnonymous();
        String typename = xst.getName();
        String namespace = xst.getNamespace();
        String prefix = null;
        if (!xsNS.equals(namespace)) {
            prefix = this.getPrefix(namespace);
            typename = prefix + ":" + typename;
        }
        buf.append("<element name='" + elname + "'");
        if (!isAnonType) {
            buf.append(" type='" + typename + "' ");
        } else {
            buf.append(">").append(this.write(xst));
        }
        if (xsel.getNillable() && xsel.getScope() != 1) {
            buf.append(" nillable='true' ");
        }
        if (!isAnonType) {
            buf.append("/>");
        } else {
            buf.append("</element>");
        }
        return buf.toString();
    }

    public String write(XSModelGroup xsm) {
        StringBuilder buf = new StringBuilder();
        XSObjectList objlist = xsm.getParticles();
        int lenobj = objlist != null ? objlist.getLength() : 0;
        for (int i = 0; i < lenobj; ++i) {
            XSParticle jxsp = (XSParticle)objlist.item(i);
            XSTerm xterm = jxsp.getTerm();
            short termType = xterm.getType();
            if (termType == 2) {
                XSElementDeclaration xsel = (XSElementDeclaration)jxsp.getTerm();
                buf.append(this.write(xsel, jxsp));
                continue;
            }
            if (termType != 7) continue;
            XSObjectList olist = ((XSModelGroup)xterm).getParticles();
            int lobj = olist != null ? olist.getLength() : 0;
            for (int k = 0; k < lobj; ++k) {
                XSParticle jxp = (XSParticle)olist.item(k);
                XSTerm xsterm = jxp.getTerm();
                termType = xsterm.getType();
                if (termType == 2) {
                    buf.append(this.write((XSElementDeclaration)xsterm, jxsp));
                    continue;
                }
                if (termType != 7 || k <= 0) continue;
                buf.append(this.write((XSModelGroup)xsterm));
            }
        }
        return buf.toString();
    }

    public String write(XSTypeDefinition xstype) {
        StringBuilder buf = new StringBuilder();
        if (xstype instanceof XSComplexTypeDefinition) {
            XSParticle xsp;
            boolean isSimple;
            XSComplexTypeDefinition jxstype = (XSComplexTypeDefinition)xstype;
            String jxsTypeName = jxstype.getName();
            boolean bl = isSimple = jxstype.getContentType() == 1;
            if (xstype.getAnonymous()) {
                buf.append("<complexType>");
            } else {
                buf.append("<complexType name='" + jxsTypeName + "'>");
            }
            XSTypeDefinition xsbase = jxstype.getBaseType();
            String baseType = null;
            if (xsbase != null && !"anyType".equals(xsbase.getName())) {
                baseType = this.getPrefix(xsbase.getNamespace()) + ":" + xsbase.getName();
            }
            if (baseType != null) {
                buf.append(isSimple ? "<simpleContent>" : "<complexContent>");
                buf.append("<extension base='" + baseType + "'>");
            }
            if ((xsp = jxstype.getParticle()) != null) {
                this.appendComplexTypeDefinition(buf, jxstype);
            }
            XSObjectList list = jxstype.getAttributeUses();
            for (int i = 0; i < list.getLength(); ++i) {
                XSAttributeUse use = (XSAttributeUse)list.item(i);
                XSAttributeDeclaration decl = use.getAttrDeclaration();
                buf.append(this.write(decl));
            }
            if (baseType != null) {
                buf.append("</extension>");
                buf.append(isSimple ? "</simpleContent>" : "</complexContent>");
            }
            buf.append("</complexType>");
        } else if (xstype instanceof XSSimpleTypeDefinition) {
            XSTypeDefinition xsbase = xstype.getBaseType();
            buf.append("<simpleType name='" + xstype.getName() + "'>");
            if (xsbase != null && !"anyType".equals(xsbase.getName())) {
                String baseType = xsbase.getName();
                String ns = xsbase.getNamespace();
                if (!xsNS.equals(ns)) {
                    String prefix = this.getPrefix(ns);
                    baseType = prefix + ":" + baseType;
                }
                buf.append("<restriction base='" + baseType + "'>");
                StringList list = ((XSSimpleTypeDefinition)xstype).getLexicalEnumeration();
                for (int i = 0; i < list.getLength(); ++i) {
                    String listItem = DOMWriter.normalize((String)list.item(i), (boolean)false);
                    buf.append("<enumeration value='" + listItem + "'/>");
                }
                buf.append("</restriction>");
            }
            buf.append("</simpleType>");
        }
        return buf.toString();
    }

    private void appendSchemaDefinitions(StringBuilder buffer, XSNamespaceItemList itemlist) {
        int len = itemlist != null ? itemlist.getLength() : 0;
        for (int i = 0; i < len; ++i) {
            XSNamespaceItem nsitem = itemlist.item(i);
            String ns = nsitem.getSchemaNamespace();
            if (xsNS.equals(ns)) continue;
            buffer.append(SchemaUtils.getSchemaDefinitions(ns));
        }
    }

    private void appendComplexTypeDefinition(StringBuilder buf, XSComplexTypeDefinition jxstype) {
        XSParticle xsp = jxstype.getParticle();
        XSTerm xsterm = xsp.getTerm();
        short deriveMethod = jxstype.getDerivationMethod();
        if (xsterm instanceof XSElementDeclaration) {
            buf.append("<sequence>");
            XSElementDeclaration xsel = (XSElementDeclaration)xsterm;
            buf.append(this.write(xsel, xsp));
            buf.append("</sequence>");
        } else if (xsterm instanceof XSModelGroup) {
            XSModelGroup jmg = (XSModelGroup)xsterm;
            XSObjectList objlist = jmg.getParticles();
            String end = null;
            switch (jmg.getCompositor()) {
                case 3: {
                    buf.append("<all>");
                    end = "</all>";
                    break;
                }
                case 2: {
                    buf.append("<choice>");
                    end = "</choice>";
                    break;
                }
                default: {
                    buf.append("<sequence>");
                    end = "</sequence>";
                }
            }
            int lenobj = objlist != null ? objlist.getLength() : 0;
            for (int i = 0; i < lenobj; ++i) {
                XSParticle jxsp = (XSParticle)objlist.item(i);
                XSTerm xterm = jxsp.getTerm();
                if (xterm instanceof XSElementDeclaration) {
                    XSElementDeclaration xsel = (XSElementDeclaration)jxsp.getTerm();
                    buf.append(this.write(xsel, jxsp));
                    continue;
                }
                if (!(xterm instanceof XSModelGroup) || deriveMethod == 1 && i != lenobj - 1 || i == 0) continue;
                XSObjectList olist = ((XSModelGroup)xterm).getParticles();
                int lobj = olist != null ? olist.getLength() : 0;
                for (int k = 0; k < lobj; ++k) {
                    XSParticle jxp = (XSParticle)olist.item(k);
                    XSTerm jxpterm = jxp.getTerm();
                    short termType = jxpterm.getType();
                    if (termType == 2) {
                        buf.append(this.write((XSElementDeclaration)jxpterm, jxsp));
                        continue;
                    }
                    if (termType != 7) continue;
                    buf.append(this.write((XSModelGroup)jxpterm));
                }
            }
            buf.append(end);
        }
    }

    private void appendTypes(StringBuilder buffer, XSModel xsmodel) {
        XSNamedMap xsmap = xsmodel.getComponents((short)3);
        int len = xsmap != null ? xsmap.getLength() : 0;
        for (int i = 0; i < len; ++i) {
            XSTypeDefinition xstype = (XSTypeDefinition)xsmap.item(i);
            if (xsNS.equals(xstype.getNamespace())) continue;
            buffer.append(this.write(xstype));
        }
    }

    private void appendGlobalElements(StringBuilder buffer, XSModel xsmodel) {
        XSNamedMap xsmap = xsmodel.getComponents((short)2);
        int len = xsmap != null ? xsmap.getLength() : 0;
        for (int i = 0; i < len; ++i) {
            XSElementDeclaration xsel = (XSElementDeclaration)xsmap.item(i);
            if (xsNS.equals(xsel.getNamespace())) continue;
            buffer.append(this.write(xsel));
        }
    }

    public void copyXSModel(XSModel xsmodel, JBossXSModel jb) {
        int i;
        if (xsmodel == null) {
            throw new IllegalArgumentException("Illegal Null Argument:xsmodel");
        }
        if (jb == null) {
            throw new IllegalArgumentException("Illegal Null Argument:jb");
        }
        jb.setXSNamespaceItemList(xsmodel.getNamespaceItems());
        XSNamedMap xsmp = xsmodel.getComponents((short)2);
        int len = xsmp != null ? xsmp.getLength() : 0;
        for (i = 0; i < len; ++i) {
            XSElementDeclaration xsel = (XSElementDeclaration)xsmp.item(i);
            jb.addXSElementDeclaration(xsel);
        }
        xsmp = xsmodel.getComponents((short)3);
        len = xsmp != null ? xsmp.getLength() : 0;
        for (i = 0; i < len; ++i) {
            XSTypeDefinition xstype = (XSTypeDefinition)xsmp.item(i);
            if (xsNS.equals(xstype.getNamespace())) continue;
            jb.addXSTypeDefinition(xstype);
        }
        xsmp = xsmodel.getComponents((short)1);
        len = xsmp != null ? xsmp.getLength() : 0;
        for (i = 0; i < len; ++i) {
            XSAttributeDeclaration xsattr = (XSAttributeDeclaration)xsmp.item(i);
            jb.addXSAttributeDeclaration(xsattr);
        }
        XSObjectList xo = xsmodel.getAnnotations();
        len = xo != null ? xo.getLength() : 0;
        for (int i2 = 0; i2 < len; ++i2) {
            XSAnnotation xa = (XSAnnotation)xo.item(i2);
            jb.addXSAnnotation(xa);
        }
    }

    private String getPrefix(String namespace) {
        if (this.namespaceRegistry == null) {
            throw new IllegalArgumentException("nameespaceRegistry can not be null!");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("namespace can not be null");
        }
        if (namespace.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (namespace.equals(this.targetNamespace)) {
            return "tns";
        }
        if (namespace.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            return "soap11-enc";
        }
        if (namespace.equals("http://www.w3.org/2001/XMLSchema-instance")) {
            return "xsi";
        }
        String prefix = this.namespaceRegistry.getPrefix(namespace);
        return prefix == null ? "tns" : prefix;
    }
}

