/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.binding;

import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import org.jboss.logging.Logger;
import org.jboss.ws.core.binding.BindingException;
import org.jboss.ws.core.binding.SerializationContext;
import org.jboss.ws.core.binding.SerializerSupport;
import org.jboss.ws.util.xml.BufferedStreamResult;
import org.jboss.wsf.common.DOMWriter;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementSerializer
extends SerializerSupport {
    private static final Logger log = Logger.getLogger(ElementSerializer.class);

    @Override
    public Result serialize(QName xmlName, QName xmlType, Object value, SerializationContext serContext, NamedNodeMap attributes) throws BindingException {
        log.debug((Object)("serialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]"));
        if (value == null) {
            throw new IllegalArgumentException("Element value cannot be null");
        }
        if (!(value instanceof Element)) {
            throw new IllegalArgumentException("Value is not a Element: " + value.getClass().getName());
        }
        String xmlFragment = DOMWriter.printNode((Node)((Element)value), (boolean)false);
        return new BufferedStreamResult(xmlFragment);
    }
}

