/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client.serviceref;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedStubPropertyMetaData;

final class CXFServiceRefStubPropertyConfigurer
implements Configurer {
    private UnifiedServiceRefMetaData serviceRefMD;
    private Configurer delegate;

    public CXFServiceRefStubPropertyConfigurer(UnifiedServiceRefMetaData serviceRefMD, Configurer delegate) {
        this.serviceRefMD = serviceRefMD;
        this.delegate = delegate;
    }

    public void configureBean(Object beanInstance) {
        if (this.delegate != null) {
            this.delegate.configureBean(beanInstance);
        }
    }

    public void configureBean(String name, Object beanInstance) {
        if (name != null && beanInstance instanceof JaxWsProxyFactoryBean) {
            QName portQName = null;
            try {
                String portName = name.substring(0, name.indexOf(".jaxws-client.proxyFactory"));
                portQName = QName.valueOf(portName);
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).warn((Object)("Unable to retrieve port QName from '" + name + "', trying matching port using endpoint interface name only."));
            }
            this.configureJaxWsProxyFactoryBean(portQName, (JaxWsProxyFactoryBean)beanInstance);
        }
        if (this.delegate != null) {
            this.delegate.configureBean(name, beanInstance);
        }
    }

    private synchronized void configureJaxWsProxyFactoryBean(QName portQName, JaxWsProxyFactoryBean proxyFactory) {
        Class clazz = proxyFactory.getServiceClass();
        UnifiedPortComponentRefMetaData upcmd = this.serviceRefMD.getPortComponentRef(clazz != null ? clazz.getName() : null, portQName);
        if (upcmd != null) {
            this.setProperties(proxyFactory, upcmd);
            this.setWSFeature((JaxWsServiceFactoryBean)proxyFactory.getServiceFactory(), upcmd);
        }
    }

    private void setWSFeature(JaxWsServiceFactoryBean serviceFactoryBean, UnifiedPortComponentRefMetaData upcmd) {
        LinkedList<Object> features = new LinkedList<Object>();
        List prevFeatures = serviceFactoryBean.getWsFeatures();
        if (prevFeatures != null) {
            features.addAll(prevFeatures);
        }
        if (upcmd.isMtomEnabled()) {
            if (upcmd.getMtomThreshold() > 0) {
                features.add(new MTOMFeature(true, upcmd.getMtomThreshold()));
            } else {
                features.add(new MTOMFeature(true));
            }
        }
        if (upcmd.isAddressingEnabled()) {
            String refResponses = upcmd.getAddressingResponses();
            AddressingFeature.Responses responses = AddressingFeature.Responses.ALL;
            if ("ANONYMOUS".equals(refResponses)) {
                responses = AddressingFeature.Responses.ANONYMOUS;
            }
            if ("NON_ANONYMOUS".equals(refResponses)) {
                responses = AddressingFeature.Responses.NON_ANONYMOUS;
            }
            features.add(new AddressingFeature(true, upcmd.isAddressingRequired(), responses));
        }
        serviceFactoryBean.setWsFeatures(features);
    }

    private void setProperties(JaxWsProxyFactoryBean proxyFactory, UnifiedPortComponentRefMetaData upcmd) {
        HashMap<String, String> properties = proxyFactory.getProperties();
        if (properties == null) {
            properties = new HashMap<String, String>();
            proxyFactory.setProperties(properties);
        }
        for (UnifiedStubPropertyMetaData prop : upcmd.getStubProperties()) {
            properties.put(prop.getPropName(), prop.getPropValue());
        }
    }
}

