/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web.action.browse;

import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.music.Album;
import com.pugh.sockso.music.Artist;
import com.pugh.sockso.music.Track;
import com.pugh.sockso.templates.web.browse.TAlbum;
import com.pugh.sockso.web.BadRequestException;
import com.pugh.sockso.web.Request;
import com.pugh.sockso.web.action.WebAction;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Albumer
extends WebAction {
    @Override
    public void handleRequest() throws IOException, SQLException, BadRequestException {
        Request req = this.getRequest();
        int id = Integer.parseInt(req.getUrlParam(2));
        Album album = this.getAlbum(id);
        Vector<Track> tracks = this.getAlbumTracks(id);
        this.showAlbum(album, tracks);
    }

    protected void showAlbum(Album album, Vector<Track> tracks) throws IOException, SQLException {
        TAlbum tpl = new TAlbum();
        tpl.setAlbum(album);
        tpl.setTracks(tracks);
        this.getResponse().showHtml(tpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector<Track> getAlbumTracks(int albumId) throws SQLException {
        Vector<Track> vector;
        ResultSet rs = null;
        PreparedStatement st = null;
        try {
            Database db = this.getDatabase();
            String sql = Track.getSelectFromSql() + " where t.album_id = ? " + " order by t.track_no asc ";
            st = db.prepare(sql);
            st.setInt(1, albumId);
            rs = st.executeQuery();
            vector = Track.createVectorFromResultSet(rs);
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Album getAlbum(int id) throws SQLException, BadRequestException {
        Album album;
        ResultSet rs = null;
        PreparedStatement st = null;
        try {
            Database db = this.getDatabase();
            String sql = " select ar.id as artistId, ar.name as artistName,  al.id as albumId, al.name as albumName,  al.date_added, (  select count(*)  from play_log l  inner join tracks t  on t.id = l.track_id  where t.album_id = al.id  ) as playCount  from albums al  inner join artists ar  on ar.id = al.artist_id  where al.id = ?  limit 1 ";
            st = db.prepare(" select ar.id as artistId, ar.name as artistName,  al.id as albumId, al.name as albumName,  al.date_added, (  select count(*)  from play_log l  inner join tracks t  on t.id = l.track_id  where t.album_id = al.id  ) as playCount  from albums al  inner join artists ar  on ar.id = al.artist_id  where al.id = ?  limit 1 ");
            st.setInt(1, id);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new BadRequestException("album not found", 404);
            }
            album = new Album(new Artist(rs.getInt("artistId"), rs.getString("artistName")), rs.getInt("albumId"), rs.getString("albumName"), rs.getDate("date_added"), -1, rs.getInt("playCount"));
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
        return album;
    }
}

