/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.music;

import com.pugh.sockso.music.CollectionManager;
import com.pugh.sockso.music.MusicItem;
import java.util.Date;
import org.apache.log4j.Logger;

public class Artist
extends MusicItem {
    private final int albumCount;
    private final int trackCount;
    private final int playCount;
    private final Date dateAdded;
    private static Logger log = Logger.getLogger(CollectionManager.class);

    public Artist(int id, String name) {
        this(id, name, null, -1, -1);
    }

    public Artist(int id, String name, int playCount) {
        this(id, name, null, -1, -1, playCount);
    }

    public Artist(int id, String name, Date dateAdded, int albumCount, int trackCount) {
        this(id, name, dateAdded, albumCount, trackCount, -1);
    }

    public Artist(int id, String name, Date dateAdded, int albumCount, int trackCount, int playCount) {
        super("artist", id, name);
        this.dateAdded = dateAdded != null ? new Date(dateAdded.getTime()) : null;
        this.albumCount = albumCount;
        this.trackCount = trackCount;
        this.playCount = playCount;
    }

    public Date getDateAdded() {
        return new Date(this.dateAdded.getTime());
    }

    public int getTrackCount() {
        return this.trackCount;
    }

    public int getAlbumCount() {
        return this.albumCount;
    }

    public int getPlayCount() {
        return this.playCount;
    }
}

