/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso;

import com.pugh.sockso.Console;
import com.pugh.sockso.DBProperties;
import com.pugh.sockso.Manager;
import com.pugh.sockso.Options;
import com.pugh.sockso.Properties;
import com.pugh.sockso.UPNP;
import com.pugh.sockso.Utils;
import com.pugh.sockso.db.DBExporter;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.db.DatabaseConnectionException;
import com.pugh.sockso.db.HSQLDatabase;
import com.pugh.sockso.db.MySQLDatabase;
import com.pugh.sockso.db.SQLiteDatabase;
import com.pugh.sockso.gui.AppFrame;
import com.pugh.sockso.gui.Splash;
import com.pugh.sockso.music.CollectionManager;
import com.pugh.sockso.music.DBCollectionManager;
import com.pugh.sockso.resources.FileResources;
import com.pugh.sockso.resources.JarResources;
import com.pugh.sockso.resources.Resources;
import com.pugh.sockso.web.HttpServer;
import com.pugh.sockso.web.HttpsServer;
import com.pugh.sockso.web.IpFinder;
import com.pugh.sockso.web.Server;
import com.pugh.sockso.web.SessionCleaner;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Main {
    private static final Logger log = Logger.getLogger(Main.class);
    private static Database db;
    private static Properties p;
    private static Server sv;
    private static CollectionManager cm;
    private static Manager manager;
    private static Resources r;

    public static void main(String[] args) throws Exception {
        Main.initLogger(Main.getLogPropsFile("default"));
        OptionParser parser = Options.getParser();
        OptionSet options = null;
        try {
            options = parser.parse(args);
        }
        catch (Exception e) {
            System.err.println("Invalid command line switch!\n");
        }
        if (options == null || options.has("help")) {
            parser.printHelpOn((OutputStream)System.out);
            Main.exit(false);
        }
        if (options.has("version")) {
            System.out.println("Sockso 1.2");
            Main.exit(false);
        }
        if (options.hasArgument("datadir")) {
            File dir = new File((String)options.valueOf("datadir"));
            if (!dir.exists()) {
                log.error((Object)(dir.getAbsolutePath() + " does not exist"));
                Main.exit(1);
            }
            Utils.setApplicationDirectory(dir);
        }
        Main.setupAppDirectory();
        try {
            db = Main.getDatabase(options);
            db.connect(options);
        }
        catch (Exception e) {
            log.error((Object)e);
            Main.exit(1);
        }
        if (options.hasArgument("logtype")) {
            PropertyConfigurator.configure((String)Main.getLogPropsFile(options.valueOf("logtype").toString()));
        }
        if (options.has("query")) {
            Main.actionQuery(options);
        } else if (options.has("admin")) {
            Main.actionAdmin(options);
        } else {
            Main.actionDefault(options);
        }
    }

    private static void actionAdmin(OptionSet options) throws Exception {
        boolean useGui = Main.getUseGui(options);
        String locale = Main.getLocale(options);
        log.info((Object)("Initializing Resources (" + locale + ")"));
        r = Main.getResources(options);
        r.init(locale);
        if (useGui) {
            Splash.start(r);
        }
        log.info((Object)"Loading Properties");
        p = new DBProperties(db);
        p.init();
        log.info((Object)"Starting Collection Manager");
        cm = new DBCollectionManager(db, p);
        cm.start();
        IpFinder ipFinder = new IpFinder(p, options);
        ipFinder.init();
        manager = useGui ? new AppFrame(db, p, null, cm, r, ipFinder) : new Console(db, p, cm, r);
        manager.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void actionQuery(OptionSet options) {
        BufferedReader in = null;
        try {
            String sql = "";
            String line = "";
            in = new BufferedReader(options.hasArgument("query") ? new FileReader(options.valueOf("query").toString()) : new InputStreamReader(System.in));
            while ((line = in.readLine()) != null) {
                sql = sql + line + "\n";
            }
            DBExporter exporter = new DBExporter(db);
            System.out.print(exporter.export(sql, DBExporter.Format.XML));
            Utils.close(in);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        finally {
            Utils.close(in);
        }
    }

    private static void actionDefault(OptionSet options) throws Exception {
        boolean useGui = Main.getUseGui(options);
        String locale = Main.getLocale(options);
        log.info((Object)("Initializing Resources (" + locale + ")"));
        r = Main.getResources(options);
        r.init(locale);
        if (useGui) {
            Splash.start(r);
        }
        log.info((Object)"Loading Properties");
        p = new DBProperties(db);
        p.init();
        log.info((Object)"Starting Collection Manager");
        cm = new DBCollectionManager(db, p);
        cm.start();
        new SessionCleaner(db).init();
        IpFinder ipFinder = new IpFinder(p, options);
        ipFinder.init();
        log.info((Object)"Starting Web Server");
        sv = Main.getServer(options);
        sv.start(options);
        if (options.has("upnp")) {
            log.info((Object)"Trying UPNP Magic");
            UPNP.tryPortForwarding(sv.getPort());
        }
        manager = useGui ? new AppFrame(db, p, sv, cm, r, ipFinder) : new Console(db, p, cm, r);
        manager.open();
    }

    protected static Database getDatabase(OptionSet options) throws DatabaseConnectionException {
        String dbtype;
        String string = dbtype = options.has("dbtype") ? options.valueOf("dbtype").toString() : "";
        if (dbtype.equals("mysql")) {
            return new MySQLDatabase();
        }
        if (dbtype.equals("sqlite")) {
            return new SQLiteDatabase();
        }
        return new HSQLDatabase();
    }

    protected static boolean getUseGui(OptionSet options) {
        return !options.has("nogui");
    }

    protected static String getLocale(OptionSet options) {
        return options.has("locale") ? options.valueOf("locale").toString() : "en";
    }

    protected static Resources getResources(OptionSet options) {
        String resourceType = options.has("resourcestype") ? options.valueOf("resourcestype").toString() : "";
        log.debug((Object)("Resources type: " + resourceType));
        return resourceType.equals("jar") ? new JarResources() : new FileResources();
    }

    protected static Server getServer(OptionSet options) {
        return options.has("ssl") ? new HttpsServer(db, p, r, cm) : new HttpServer(db, p, r, cm);
    }

    private static String getLogPropsFile(String type) {
        return "log/" + type + ".properties";
    }

    public static void exit() {
        Main.exit(0, true);
    }

    public static void exit(int status) {
        Main.exit(status, true);
    }

    public static void exit(boolean showOutput) {
        Main.exit(0, showOutput);
    }

    public static void exit(int status, boolean showOutput) {
        if (showOutput) {
            log.info((Object)"Shutting Down");
        }
        if (cm != null) {
            cm.shutdown();
        }
        if (sv != null) {
            sv.shutdown();
        }
        if (manager != null) {
            manager.close();
        }
        if (db != null) {
            db.close();
        }
        if (showOutput) {
            log.info((Object)"Thank you for your attention, bye!");
        }
        System.exit(status);
    }

    private static void setupAppDirectory() {
        String[] dirs;
        for (String dir : dirs = new String[]{Utils.getApplicationDirectory(), Utils.getCoversDirectory()}) {
            File file = new File(dir);
            if (file.exists() || file.mkdir()) continue;
            log.fatal((Object)("Unable to create directory: " + dir));
            Main.exit(1);
        }
    }

    public static void initTestLogger() {
        Main.initLogger("dist-files/log/test.properties");
    }

    private static void initLogger(String propsFile) {
        PropertyConfigurator.configure((String)propsFile);
    }
}

