/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.actions.generated.instance.ArrowLinkArrowXmlAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.modes.ArrowLinkAdapter;
import freemind.modes.MindMapLink;
import freemind.modes.MindMapLinkRegistry;
import freemind.modes.mindmapmode.MindMapArrowLinkModel;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.FreemindAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.actions.xml.ActorXml;
import java.awt.event.ActionEvent;

public class ChangeArrowsInArrowLinkAction
extends FreemindAction
implements ActorXml {
    MindMapArrowLinkModel arrowLink;
    boolean hasStartArrow;
    boolean hasEndArrow;
    private final MindMapController controller;

    public ChangeArrowsInArrowLinkAction(MindMapController controller, String text, String iconPath, MindMapArrowLinkModel arrowLink, boolean hasStartArrow, boolean hasEndArrow) {
        super("change_arrows_in_arrow_link", iconPath, controller);
        this.controller = controller;
        this.arrowLink = arrowLink;
        this.hasStartArrow = hasStartArrow;
        this.hasEndArrow = hasEndArrow;
        this.addActor(this);
    }

    public void actionPerformed(ActionEvent e) {
        this.changeArrowsOfArrowLink(this.arrowLink, this.hasStartArrow, this.hasEndArrow);
    }

    public void changeArrowsOfArrowLink(MindMapArrowLinkModel arrowLink, boolean hasStartArrow, boolean hasEndArrow) {
        this.controller.getActionFactory().startTransaction((String)this.getValue("Name"));
        this.controller.getActionFactory().executeAction(this.getActionPair(arrowLink, hasStartArrow, hasEndArrow));
        this.controller.getActionFactory().endTransaction((String)this.getValue("Name"));
    }

    private ActionPair getActionPair(MindMapArrowLinkModel arrowLink2, boolean hasStartArrow2, boolean hasEndArrow2) {
        return new ActionPair((XmlAction)this.createArrowLinkArrowXmlAction(arrowLink2, hasStartArrow2, hasEndArrow2), (XmlAction)this.createArrowLinkArrowXmlAction(arrowLink2, arrowLink2.getStartArrow(), arrowLink2.getEndArrow()));
    }

    public void act(XmlAction action) {
        if (action instanceof ArrowLinkArrowXmlAction) {
            ArrowLinkArrowXmlAction arrowAction = (ArrowLinkArrowXmlAction)action;
            MindMapLink link = this.getLinkRegistry().getLinkForID(arrowAction.getId());
            ((ArrowLinkAdapter)link).setStartArrow(arrowAction.getStartArrow());
            ((ArrowLinkAdapter)link).setEndArrow(arrowAction.getEndArrow());
            this.controller.nodeChanged(link.getSource());
            this.controller.nodeChanged(link.getTarget());
        }
    }

    public Class getDoActionClass() {
        return ArrowLinkArrowXmlAction.class;
    }

    private ArrowLinkArrowXmlAction createArrowLinkArrowXmlAction(MindMapArrowLinkModel arrowLink, boolean hasStartArrow, boolean hasEndArrow) {
        return this.createArrowLinkArrowXmlAction(arrowLink, hasStartArrow ? "Default" : "None", hasEndArrow ? "Default" : "None");
    }

    private ArrowLinkArrowXmlAction createArrowLinkArrowXmlAction(MindMapArrowLinkModel arrowLink, String hasStartArrow, String hasEndArrow) {
        ArrowLinkArrowXmlAction action = new ArrowLinkArrowXmlAction();
        action.setStartArrow(hasStartArrow);
        action.setEndArrow(hasEndArrow);
        action.setId(arrowLink.getUniqueID());
        return action;
    }

    private MindMapLinkRegistry getLinkRegistry() {
        return this.controller.getMap().getLinkRegistry();
    }
}

