/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller;

import freemind.controller.BlindIcon;
import freemind.controller.MenuItemSelectedListener;
import freemind.controller.StructuredMenuItemHolder;
import freemind.main.HtmlTools;
import freemind.main.Resources;
import freemind.main.Tools;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class StructuredMenuHolder {
    public static final int ICON_SIZE = 16;
    private String mOutputString;
    private static Icon blindIcon = new BlindIcon(16);
    private static final String SELECTED_ICON_PATH = "images/button_ok.png";
    private static final String SEPARATOR_TEXT = "000";
    private static final String ORDER_NAME = "/order";
    Map menuMap;
    private static Logger logger = null;
    private int mIndent;
    private static ImageIcon sSelectedIcon;

    public StructuredMenuHolder() {
        if (logger == null) {
            logger = Resources.getInstance().getLogger(this.getClass().getName());
        }
        this.menuMap = new HashMap();
        Vector order = new Vector();
        this.menuMap.put(ORDER_NAME, order);
        if (sSelectedIcon == null) {
            sSelectedIcon = new ImageIcon(Resources.getInstance().getResource(SELECTED_ICON_PATH));
        }
    }

    public JMenu addMenu(JMenu item, String category) {
        StringTokenizer tokens = new StringTokenizer(category, "/");
        return (JMenu)this.addMenu((Object)item, tokens);
    }

    public JMenuItem addMenuItem(JMenuItem item, String category) {
        StringTokenizer tokens = new StringTokenizer(category, "/");
        StructuredMenuItemHolder holder = new StructuredMenuItemHolder();
        holder.setAction(item.getAction());
        holder.setMenuItem(item);
        this.adjustTooltips(holder);
        this.addMenu(holder, tokens);
        return item;
    }

    public JMenuItem addAction(Action item, String category) {
        StringTokenizer tokens = new StringTokenizer(category, "/");
        StructuredMenuItemHolder holder = new StructuredMenuItemHolder();
        holder.setAction(item);
        if (item instanceof MenuItemSelectedListener) {
            holder.setMenuItem(new JCheckBoxMenuItem(item));
        } else {
            holder.setMenuItem(new JMenuItem(item));
        }
        this.adjustTooltips(holder);
        this.addMenu(holder, tokens);
        return holder.getMenuItem();
    }

    private void adjustTooltips(StructuredMenuItemHolder holder) {
        String toolTipText;
        if (Tools.isMacOsX() && (toolTipText = holder.getMenuItem().getToolTipText()) != null) {
            String toolTipTextWithoutTags = HtmlTools.removeHtmlTagsFromString(toolTipText);
            logger.finest("Old tool tip: " + toolTipText + ", New tool tip: " + toolTipTextWithoutTags);
            holder.getMenuItem().setToolTipText(toolTipTextWithoutTags);
        }
    }

    public void addCategory(String category) {
        StringTokenizer tokens = new StringTokenizer(category + "/blank", "/");
        MapTokenPair categoryPair = this.getCategoryMap(tokens, this.menuMap);
    }

    public void addSeparator(String category) {
        String sep = category;
        if (!sep.endsWith("/")) {
            sep = sep + "/";
        }
        sep = sep + SEPARATOR_TEXT;
        StringTokenizer tokens = new StringTokenizer(sep, "/");
        MapTokenPair categoryPair = this.getCategoryMap(tokens, this.menuMap);
        categoryPair.map.put(categoryPair.token, new SeparatorHolder());
        categoryPair.order.add(categoryPair.token);
    }

    private Object addMenu(Object item, StringTokenizer tokens) {
        MapTokenPair categoryPair = this.getCategoryMap(tokens, this.menuMap);
        categoryPair.map.put(categoryPair.token, item);
        categoryPair.order.add(categoryPair.token);
        return item;
    }

    private MapTokenPair getCategoryMap(StringTokenizer tokens, Map thisMap) {
        if (tokens.hasMoreTokens()) {
            String nextToken = tokens.nextToken();
            if (tokens.hasMoreTokens()) {
                if (!thisMap.containsKey(nextToken)) {
                    HashMap newMap = new HashMap();
                    Vector newOrder = new Vector();
                    newMap.put(ORDER_NAME, newOrder);
                    thisMap.put(nextToken, newMap);
                }
                Map nextMap = (Map)thisMap.get(nextToken);
                Vector order = (Vector)thisMap.get(ORDER_NAME);
                if (!order.contains(nextToken)) {
                    order.add(nextToken);
                }
                return this.getCategoryMap(tokens, nextMap);
            }
            Vector order = (Vector)thisMap.get(ORDER_NAME);
            return new MapTokenPair(thisMap, nextToken, order);
        }
        return null;
    }

    public void updateMenus(final JMenuBar myItem, String prefix) {
        MapTokenPair pair = this.getCategoryMap(new StringTokenizer(prefix, "/"), this.menuMap);
        Map myMap = (Map)pair.map.get(pair.token);
        this.updateMenus(new MenuAdder(){

            public void addMenuItem(StructuredMenuItemHolder holder) {
                Tools.setLabelAndMnemonic(holder.getMenuItem(), null);
                myItem.add(holder.getMenuItem());
            }

            public void addSeparator() {
                throw new NoSuchMethodError("addSeparator for JMenuBar");
            }

            public void addCategory(String category) {
            }
        }, myMap, new DefaultMenuAdderCreator());
    }

    public void updateMenus(final JPopupMenu myItem, String prefix) {
        MapTokenPair pair = this.getCategoryMap(new StringTokenizer(prefix, "/"), this.menuMap);
        Map myMap = (Map)pair.map.get(pair.token);
        this.updateMenus(new MenuAdder(){
            StructuredMenuListener listener = new StructuredMenuListener();

            public void addMenuItem(StructuredMenuItemHolder holder) {
                Tools.setLabelAndMnemonic(holder.getMenuItem(), null);
                JMenuItem menuItem = holder.getMenuItem();
                StructuredMenuHolder.adjustMenuItem(menuItem);
                myItem.add(menuItem);
                if (myItem instanceof MenuEventSupplier) {
                    MenuEventSupplier receiver = (MenuEventSupplier)((Object)myItem);
                    receiver.addMenuListener(this.listener);
                    this.listener.addItem(holder);
                }
            }

            public void addSeparator() {
                if (StructuredMenuHolder.lastItemIsASeparator(myItem)) {
                    return;
                }
                myItem.addSeparator();
            }

            public void addCategory(String category) {
            }
        }, myMap, new DefaultMenuAdderCreator());
    }

    public void updateMenus(final JToolBar bar, String prefix) {
        MapTokenPair pair = this.getCategoryMap(new StringTokenizer(prefix, "/"), this.menuMap);
        Map myMap = (Map)pair.map.get(pair.token);
        this.updateMenus(new MenuAdder(){

            public void addMenuItem(StructuredMenuItemHolder holder) {
                bar.add(holder.getAction());
            }

            public void addSeparator() {
                bar.addSeparator();
            }

            public void addCategory(String category) {
            }
        }, myMap, new DefaultMenuAdderCreator());
    }

    private static void adjustMenuItem(JMenuItem item) {
        if (item.getIcon() == null) {
            item.setIcon(blindIcon);
        } else if (item.getIcon().getIconWidth() < 16) {
            item.setIconTextGap(item.getIconTextGap() + (16 - item.getIcon().getIconWidth()));
        }
    }

    private void updateMenus(MenuAdder menuAdder, Map thisMap, MenuAdderCreator factory) {
        Vector myVector = (Vector)thisMap.get(ORDER_NAME);
        Iterator i = myVector.iterator();
        while (i.hasNext()) {
            MenuAdder nextItem;
            String category = (String)i.next();
            if (category.equals(".")) continue;
            Object nextObject = thisMap.get(category);
            if (nextObject instanceof SeparatorHolder) {
                menuAdder.addSeparator();
                continue;
            }
            if (nextObject instanceof StructuredMenuItemHolder) {
                StructuredMenuItemHolder holder = (StructuredMenuItemHolder)nextObject;
                menuAdder.addMenuItem(holder);
                continue;
            }
            if (!(nextObject instanceof Map)) continue;
            menuAdder.addCategory(category);
            Map nextMap = (Map)nextObject;
            if (nextMap.containsKey(".")) {
                JMenu baseObject = (JMenu)nextMap.get(".");
                StructuredMenuItemHolder holder = new StructuredMenuItemHolder();
                holder.setMenuItem(baseObject);
                menuAdder.addMenuItem(holder);
                nextItem = factory.createAdder(baseObject);
            } else {
                nextItem = menuAdder;
            }
            ++this.mIndent;
            this.updateMenus(nextItem, nextMap, factory);
            --this.mIndent;
        }
    }

    public String toString() {
        this.mIndent = 0;
        this.mOutputString = "";
        this.updateMenus(new PrintMenuAdder(), this.menuMap, new PrintMenuAdderCreator());
        return this.mOutputString;
    }

    private void print(String string) {
        for (int i = 0; i < this.mIndent; ++i) {
            this.mOutputString = this.mOutputString + "  ";
        }
        this.mOutputString = this.mOutputString + string + "\n";
    }

    public static boolean lastItemIsASeparator(JMenu menu) {
        return menu.getItemCount() > 0 && menu.getMenuComponents()[menu.getItemCount() - 1] instanceof JSeparator;
    }

    public static boolean lastItemIsASeparator(JPopupMenu menu) {
        return menu.getComponentCount() > 0 && menu.getComponent(menu.getComponentCount() - 1) instanceof JPopupMenu.Separator;
    }

    private static void setSelected(JMenuItem menuItem, boolean state) {
        if (state) {
            menuItem.setIcon(sSelectedIcon);
        } else {
            menuItem.setIcon((Icon)menuItem.getAction().getValue("SmallIcon"));
        }
    }

    public static class StructuredMenuListener
    implements MenuListener {
        private Vector menuItemHolder = new Vector();

        public void menuSelected(MenuEvent arg0) {
            Iterator i = this.menuItemHolder.iterator();
            while (i.hasNext()) {
                StructuredMenuItemHolder holder = (StructuredMenuItemHolder)i.next();
                Action action = holder.getAction();
                boolean isEnabled = false;
                JMenuItem menuItem = holder.getMenuItem();
                if (holder.getEnabledListener() != null) {
                    try {
                        isEnabled = holder.getEnabledListener().isEnabled(menuItem, action);
                    }
                    catch (Exception e) {
                        Resources.getInstance().logException(e);
                    }
                    menuItem.setEnabled(isEnabled);
                }
                if (!(isEnabled = menuItem.isEnabled()) || holder.getSelectionListener() == null) continue;
                boolean selected = false;
                try {
                    selected = holder.getSelectionListener().isSelected(menuItem, action);
                }
                catch (Exception e) {
                    Resources.getInstance().logException(e);
                }
                if (menuItem instanceof JCheckBoxMenuItem) {
                    JCheckBoxMenuItem checkItem = (JCheckBoxMenuItem)menuItem;
                    checkItem.setSelected(selected);
                    continue;
                }
                StructuredMenuHolder.setSelected(menuItem, selected);
            }
        }

        public void menuDeselected(MenuEvent arg0) {
        }

        public void menuCanceled(MenuEvent arg0) {
        }

        public void addItem(StructuredMenuItemHolder holder) {
            this.menuItemHolder.add(holder);
        }
    }

    public static interface MenuEventSupplier {
        public void addMenuListener(MenuListener var1);

        public void removeMenuListener(MenuListener var1);
    }

    private class PrintMenuAdderCreator
    implements MenuAdderCreator {
        private PrintMenuAdderCreator() {
        }

        public MenuAdder createAdder(JMenu baseObject) {
            return new PrintMenuAdder();
        }
    }

    private class SeparatorHolder {
    }

    private class DefaultMenuAdderCreator
    implements MenuAdderCreator {
        private DefaultMenuAdderCreator() {
        }

        public MenuAdder createAdder(JMenu baseObject) {
            return new MenuItemAdder(baseObject);
        }
    }

    private static interface MenuAdderCreator {
        public MenuAdder createAdder(JMenu var1);
    }

    private static class MenuItemAdder
    implements MenuAdder {
        private JMenu myItem;
        private StructuredMenuListener listener;

        public MenuItemAdder(JMenu myItem) {
            this.myItem = myItem;
            this.listener = new StructuredMenuListener();
            myItem.addMenuListener(this.listener);
        }

        public void addMenuItem(StructuredMenuItemHolder holder) {
            Tools.setLabelAndMnemonic(holder.getMenuItem(), null);
            JMenuItem item = holder.getMenuItem();
            StructuredMenuHolder.adjustMenuItem(item);
            this.listener.addItem(holder);
            this.myItem.add(item);
        }

        public void addSeparator() {
            if (StructuredMenuHolder.lastItemIsASeparator(this.myItem)) {
                return;
            }
            this.myItem.addSeparator();
        }

        public void addCategory(String category) {
        }
    }

    private static interface MenuAdder {
        public void addMenuItem(StructuredMenuItemHolder var1);

        public void addSeparator();

        public void addCategory(String var1);
    }

    private class MapTokenPair {
        Map map;
        String token;
        Vector order;

        MapTokenPair(Map map, String token, Vector order) {
            this.map = map;
            this.token = token;
            this.order = order;
        }
    }

    private final class PrintMenuAdder
    implements MenuAdder {
        private PrintMenuAdder() {
        }

        public void addMenuItem(StructuredMenuItemHolder holder) {
            StructuredMenuHolder.this.print("JMenuItem '" + holder.getMenuItem().getActionCommand() + "'");
        }

        public void addSeparator() {
            StructuredMenuHolder.this.print("Separator ''");
        }

        public void addCategory(String category) {
            StructuredMenuHolder.this.print("Category: '" + category + "'");
        }
    }
}

