#include "ibm.h"

#include "x86.h"
#include "x86_flags.h"
#include "386_common.h"
#include "codegen.h"
#include "codegen_accumulate.h"
#include "codegen_ir.h"
#include "codegen_ops.h"
#include "codegen_ops_mmx_loadstore.h"
#include "codegen_ops_helpers.h"

uint32_t ropMOVD_r_d(codeblock_t *block, ir_data_t *ir, uint8_t opcode, uint32_t fetchdat, uint32_t op_32, uint32_t op_pc) {
	int dest_reg = (fetchdat >> 3) & 7;

	uop_MMX_ENTER(ir);
	codegen_mark_code_present(block, cs + op_pc, 1);
	if ((fetchdat & 0xc0) == 0xc0) {
		int src_reg = fetchdat & 7;
		uop_MOVZX(ir, IREG_MM(dest_reg), IREG_32(src_reg));
	} else {
		x86seg *target_seg;

		uop_MOV_IMM(ir, IREG_oldpc, cpu_state.oldpc);
		target_seg = codegen_generate_ea(ir, op_ea_seg, fetchdat, op_ssegs, &op_pc, op_32, 0);
		codegen_check_seg_read(block, ir, target_seg);
		uop_MEM_LOAD_REG(ir, IREG_temp0, ireg_seg_base(target_seg), IREG_eaaddr);
		uop_MOVZX(ir, IREG_MM(dest_reg), IREG_temp0);
	}

	return op_pc + 1;
}
uint32_t ropMOVD_d_r(codeblock_t *block, ir_data_t *ir, uint8_t opcode, uint32_t fetchdat, uint32_t op_32, uint32_t op_pc) {
	int src_reg = (fetchdat >> 3) & 7;

	if (cpu_iscyrix && (cpu_cur_status & CPU_STATUS_SMM))
		return 0;

	uop_MMX_ENTER(ir);
	codegen_mark_code_present(block, cs + op_pc, 1);
	if ((fetchdat & 0xc0) == 0xc0) {
		int dest_reg = fetchdat & 7;
		uop_MOVZX(ir, IREG_32(dest_reg), IREG_MM(src_reg));
	} else {
		x86seg *target_seg;

		uop_MOV_IMM(ir, IREG_oldpc, cpu_state.oldpc);
		target_seg = codegen_generate_ea(ir, op_ea_seg, fetchdat, op_ssegs, &op_pc, op_32, 0);
		codegen_check_seg_write(block, ir, target_seg);
		CHECK_SEG_LIMITS(block, ir, target_seg, IREG_eaaddr, 3);
		uop_MOVZX(ir, IREG_temp0, IREG_MM(src_reg));
		uop_MEM_STORE_REG(ir, ireg_seg_base(target_seg), IREG_eaaddr, IREG_temp0);
	}

	return op_pc + 1;
}

uint32_t ropMOVQ_r_q(codeblock_t *block, ir_data_t *ir, uint8_t opcode, uint32_t fetchdat, uint32_t op_32, uint32_t op_pc) {
	int dest_reg = (fetchdat >> 3) & 7;

	uop_MMX_ENTER(ir);
	codegen_mark_code_present(block, cs + op_pc, 1);
	if ((fetchdat & 0xc0) == 0xc0) {
		int src_reg = fetchdat & 7;
		uop_MOV(ir, IREG_MM(dest_reg), IREG_MM(src_reg));
	} else {
		x86seg *target_seg;

		uop_MOV_IMM(ir, IREG_oldpc, cpu_state.oldpc);
		target_seg = codegen_generate_ea(ir, op_ea_seg, fetchdat, op_ssegs, &op_pc, op_32, 0);
		codegen_check_seg_read(block, ir, target_seg);
		uop_MEM_LOAD_REG(ir, IREG_MM(dest_reg), ireg_seg_base(target_seg), IREG_eaaddr);
	}

	return op_pc + 1;
}

uint32_t ropMOVQ_q_r(codeblock_t *block, ir_data_t *ir, uint8_t opcode, uint32_t fetchdat, uint32_t op_32, uint32_t op_pc) {
	int src_reg = (fetchdat >> 3) & 7;

	uop_MMX_ENTER(ir);
	codegen_mark_code_present(block, cs + op_pc, 1);
	if ((fetchdat & 0xc0) == 0xc0) {
		int dest_reg = fetchdat & 7;
		uop_MOV(ir, IREG_MM(dest_reg), IREG_MM(src_reg));
	} else {
		x86seg *target_seg;

		uop_MOV_IMM(ir, IREG_oldpc, cpu_state.oldpc);
		target_seg = codegen_generate_ea(ir, op_ea_seg, fetchdat, op_ssegs, &op_pc, op_32, 0);
		codegen_check_seg_write(block, ir, target_seg);
		CHECK_SEG_LIMITS(block, ir, target_seg, IREG_eaaddr, 7);
		uop_MEM_STORE_REG(ir, ireg_seg_base(target_seg), IREG_eaaddr, IREG_MM(src_reg));
	}

	return op_pc + 1;
}
