/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop;

import com.openstego.desktop.OpenStego;
import com.openstego.desktop.OpenStegoException;
import com.openstego.desktop.OpenStegoPlugin;
import com.openstego.desktop.util.CommonUtil;
import com.openstego.desktop.util.LabelUtil;
import com.openstego.desktop.util.PluginManager;
import com.openstego.desktop.util.cmd.CmdLineOption;
import com.openstego.desktop.util.cmd.CmdLineOptions;
import com.openstego.desktop.util.cmd.CmdLineParser;
import com.openstego.desktop.util.cmd.PasswordInput;
import java.io.File;
import java.util.List;

public class OpenStegoCmd {
    private static LabelUtil labelUtil = LabelUtil.getInstance("OpenStego");

    public static void execute(String[] args) {
        block36: {
            String command = null;
            String pluginName = null;
            OpenStego stego = null;
            CmdLineParser parser = null;
            CmdLineOptions options = null;
            CmdLineOption option = null;
            List<CmdLineOption> optionList = null;
            OpenStegoPlugin plugin = null;
            try {
                parser = new CmdLineParser(OpenStegoCmd.getStdCmdLineOptions(null), args);
                if (!parser.isValid()) {
                    OpenStegoCmd.displayUsage();
                    return;
                }
                pluginName = parser.getParsedOptions().getOptionValue("-a");
                if (pluginName != null && !pluginName.equals("")) {
                    plugin = PluginManager.getPluginByName(pluginName);
                    if (plugin == null) {
                        throw new OpenStegoException(null, "OpenStego", 11, pluginName);
                    }
                } else {
                    List<OpenStegoPlugin> plugins = PluginManager.getPlugins();
                    if (plugins.size() == 1) {
                        plugin = plugins.get(0);
                    } else if (plugins.size() > 1 && (optionList = parser.getParsedOptionsAsList()).size() > 0) {
                        command = optionList.get(0).getName();
                        if (command.equals("embed") || command.equals("extract")) {
                            plugins = PluginManager.getDataHidingPlugins();
                            if (plugins.size() == 1) {
                                plugin = plugins.get(0);
                            }
                        } else if ((command.equals("gensig") || command.equals("embedmark") || command.equals("checkmark")) && (plugins = PluginManager.getWatermarkingPlugins()).size() == 1) {
                            plugin = plugins.get(0);
                        }
                    }
                }
                if (plugin != null) {
                    parser = new CmdLineParser(OpenStegoCmd.getStdCmdLineOptions(plugin), args);
                }
                optionList = parser.getParsedOptionsAsList();
                options = parser.getParsedOptions();
                for (int i = 0; i < optionList.size(); ++i) {
                    option = optionList.get(i);
                    if (i == 0 && option.getType() != 0 || i > 0 && option.getType() == 0) {
                        OpenStegoCmd.displayUsage();
                        return;
                    }
                    if (i != 0) continue;
                    command = option.getName();
                }
                if (parser.getNonStdOptions().size() > 0) {
                    OpenStegoCmd.displayUsage();
                    return;
                }
                if (!command.equals("help") && !command.equals("algorithms")) {
                    if (plugin == null) {
                        throw new OpenStegoException(null, "OpenStego", 9);
                    }
                    stego = new OpenStego(plugin, plugin.createConfig(parser.getParsedOptions()));
                }
                if (command.equals("embed")) {
                    OpenStegoCmd.executeEmbed(options, stego);
                    break block36;
                }
                if (command.equals("embedmark")) {
                    OpenStegoCmd.executeEmbedMark(options, stego);
                    break block36;
                }
                if (command.equals("extract")) {
                    OpenStegoCmd.executeExtract(options, stego);
                    break block36;
                }
                if (command.equals("checkmark")) {
                    OpenStegoCmd.executeCheckMark(options, stego);
                    break block36;
                }
                if (command.equals("gensig")) {
                    OpenStegoCmd.executeGenSig(options, stego);
                    break block36;
                }
                if (command.equals("diff")) {
                    OpenStegoCmd.executeDiff(options, stego);
                    break block36;
                }
                if (command.equals("readformats")) {
                    List<String> formats = plugin.getReadableFileExtensions();
                    for (int i = 0; i < formats.size(); ++i) {
                        System.out.println(formats.get(i));
                    }
                    break block36;
                }
                if (command.equals("writeformats")) {
                    List<String> formats = plugin.getWritableFileExtensions();
                    for (int i = 0; i < formats.size(); ++i) {
                        System.out.println(formats.get(i));
                    }
                    break block36;
                }
                if (command.equals("algorithms")) {
                    List<OpenStegoPlugin> plugins = PluginManager.getPlugins();
                    for (int i = 0; i < plugins.size(); ++i) {
                        plugin = plugins.get(i);
                        System.out.println(plugin.getName() + " " + plugin.getPurposesLabel() + " - " + plugin.getDescription());
                    }
                    break block36;
                }
                if (command.equals("help")) {
                    if (plugin == null) {
                        OpenStegoCmd.displayUsage();
                        return;
                    }
                    System.err.println(plugin.getUsage());
                    break block36;
                }
                OpenStegoCmd.displayUsage();
                return;
            }
            catch (OpenStegoException osEx) {
                if (osEx.getErrorCode() == 0) {
                    osEx.printStackTrace();
                } else {
                    System.err.println(osEx.getMessage());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static void executeEmbed(CmdLineOptions options, OpenStego stego) throws OpenStegoException {
        String msgFileName = options.getOptionValue("-mf");
        String coverFileName = options.getOptionValue("-cf");
        String stegoFileName = options.getOptionValue("-sf");
        List<File> coverFileList = null;
        if (stego.getConfig().isUseEncryption() && stego.getConfig().getPassword() == null) {
            stego.getConfig().setPassword(PasswordInput.readPassword(labelUtil.getString("cmd.msg.enterPassword") + " "));
        }
        if ((coverFileList = CommonUtil.parseFileList(coverFileName, ";")).size() <= 1) {
            if (coverFileList.size() == 0 && coverFileName != null && !coverFileName.equals("-")) {
                System.err.println(labelUtil.getString("cmd.msg.coverFileNotFound", coverFileName));
                return;
            }
            CommonUtil.writeFile(stego.embedData(msgFileName == null || msgFileName.equals("-") ? null : new File(msgFileName), coverFileList.size() == 0 ? null : coverFileList.get(0), stegoFileName == null || stegoFileName.equals("-") ? null : stegoFileName), stegoFileName == null || stegoFileName.equals("-") ? null : stegoFileName);
        } else {
            if (stegoFileName != null && !stegoFileName.equals("-")) {
                System.err.println(labelUtil.getString("cmd.warn.stegoFileIgnored"));
            }
            for (int i = 0; i < coverFileList.size(); ++i) {
                coverFileName = coverFileList.get(i).getName();
                CommonUtil.writeFile(stego.embedData(msgFileName == null || msgFileName.equals("-") ? null : new File(msgFileName), coverFileList.get(i), coverFileName), coverFileName);
                System.err.println(labelUtil.getString("cmd.msg.coverProcessed", coverFileName));
            }
        }
    }

    private static void executeEmbedMark(CmdLineOptions options, OpenStego stego) throws OpenStegoException {
        String sigFileName = options.getOptionValue("-gf");
        String coverFileName = options.getOptionValue("-cf");
        String stegoFileName = options.getOptionValue("-sf");
        List<File> coverFileList = CommonUtil.parseFileList(coverFileName, ";");
        if (coverFileList.size() <= 1) {
            if (coverFileList.size() == 0 && coverFileName != null && !coverFileName.equals("-")) {
                System.err.println(labelUtil.getString("cmd.msg.coverFileNotFound", coverFileName));
                return;
            }
            CommonUtil.writeFile(stego.embedMark(sigFileName == null || sigFileName.equals("-") ? null : new File(sigFileName), coverFileList.size() == 0 ? null : coverFileList.get(0), stegoFileName == null || stegoFileName.equals("-") ? null : stegoFileName), stegoFileName == null || stegoFileName.equals("-") ? null : stegoFileName);
        } else {
            if (stegoFileName != null && !stegoFileName.equals("-")) {
                System.err.println(labelUtil.getString("cmd.warn.stegoFileIgnored"));
            }
            for (int i = 0; i < coverFileList.size(); ++i) {
                coverFileName = coverFileList.get(i).getName();
                CommonUtil.writeFile(stego.embedMark(sigFileName == null || sigFileName.equals("-") ? null : new File(sigFileName), coverFileList.get(i), coverFileName), coverFileName);
                System.err.println(labelUtil.getString("cmd.msg.coverProcessed", coverFileName));
            }
        }
    }

    private static void executeExtract(CmdLineOptions options, OpenStego stego) throws OpenStegoException {
        List<?> msgData;
        String stegoFileName = options.getOptionValue("-sf");
        String extractDir = options.getOptionValue("-xd");
        if (stegoFileName == null) {
            OpenStegoCmd.displayUsage();
            return;
        }
        try {
            msgData = stego.extractData(new File(stegoFileName));
        }
        catch (OpenStegoException osEx) {
            if (osEx.getErrorCode() == 1 || osEx.getErrorCode() == 6) {
                if (stego.getConfig().getPassword() == null) {
                    stego.getConfig().setPassword(PasswordInput.readPassword(labelUtil.getString("cmd.msg.enterPassword") + " "));
                    try {
                        msgData = stego.extractData(new File(stegoFileName));
                    }
                    catch (OpenStegoException inEx) {
                        if (inEx.getErrorCode() == 1) {
                            System.err.println(inEx.getMessage());
                            return;
                        }
                        throw inEx;
                    }
                }
                System.err.println(osEx.getMessage());
                return;
            }
            throw osEx;
        }
        String extractFileName = options.getOptionValue("-xf");
        if (extractFileName == null && ((extractFileName = (String)msgData.get(0)) == null || extractFileName.equals(""))) {
            extractFileName = "untitled";
        }
        if (extractDir != null) {
            extractFileName = extractDir + File.separator + extractFileName;
        }
        CommonUtil.writeFile((byte[])msgData.get(1), extractFileName);
        System.err.println(labelUtil.getString("cmd.msg.fileExtracted", extractFileName));
    }

    private static void executeCheckMark(CmdLineOptions options, OpenStego stego) throws OpenStegoException {
        String stegoFileName = options.getOptionValue("-sf");
        String sigFileName = options.getOptionValue("-gf");
        if (stegoFileName == null || sigFileName == null) {
            OpenStegoCmd.displayUsage();
            return;
        }
        List<File> stegoFileList = CommonUtil.parseFileList(stegoFileName, ";");
        if (stegoFileList.size() == 1) {
            System.out.println(stego.checkMark(stegoFileList.get(0), new File(sigFileName)));
        } else {
            for (int i = 0; i < stegoFileList.size(); ++i) {
                stegoFileName = stegoFileList.get(i).getName();
                System.out.println(stegoFileName + "\t" + stego.checkMark(stegoFileList.get(i), new File(sigFileName)));
            }
        }
    }

    private static void executeGenSig(CmdLineOptions options, OpenStego stego) throws OpenStegoException {
        if (stego.getConfig().getPassword() == null) {
            stego.getConfig().setPassword(PasswordInput.readPassword(labelUtil.getString("cmd.msg.enterPassword") + " "));
        }
        String signatureFileName = options.getOptionValue("-gf");
        CommonUtil.writeFile(stego.generateSignature(), signatureFileName == null || signatureFileName.equals("-") ? null : signatureFileName);
    }

    private static void executeDiff(CmdLineOptions options, OpenStego stego) throws OpenStegoException {
        String coverFileName = options.getOptionValue("-cf");
        String stegoFileName = options.getOptionValue("-sf");
        String extractDir = options.getOptionValue("-xd");
        String extractFileName = options.getOptionValue("-xf");
        if (extractDir != null) {
            extractFileName = extractDir + File.separator + extractFileName;
        }
        CommonUtil.writeFile(stego.getDiff(new File(stegoFileName), new File(coverFileName), extractFileName), extractFileName);
    }

    private static void displayUsage() throws OpenStegoException {
        PluginManager.loadPlugins();
        System.err.print(labelUtil.getString("appName") + " " + labelUtil.getString("appVersion") + ". ");
        System.err.println(labelUtil.getString("copyright") + "\n");
        System.err.println(labelUtil.getString("cmd.usage", File.separator));
    }

    private static CmdLineOptions getStdCmdLineOptions(OpenStegoPlugin plugin) throws OpenStegoException {
        CmdLineOptions options = new CmdLineOptions();
        options.add("embed", "--embed", 0, false);
        options.add("extract", "--extract", 0, false);
        options.add("gensig", "--gensig", 0, false);
        options.add("embedmark", "--embedmark", 0, false);
        options.add("checkmark", "--checkmark", 0, false);
        options.add("diff", "--diff", 0, false);
        options.add("readformats", "--readformats", 0, false);
        options.add("writeformats", "--writeformats", 0, false);
        options.add("algorithms", "--algorithms", 0, false);
        options.add("help", "--help", 0, false);
        options.add("-a", "--algorithm", 1, true);
        options.add("-mf", "--messagefile", 1, true);
        options.add("-cf", "--coverfile", 1, true);
        options.add("-sf", "--stegofile", 1, true);
        options.add("-xf", "--extractfile", 1, true);
        options.add("-xd", "--extractdir", 1, true);
        options.add("-gf", "--sigfile", 1, true);
        options.add("-c", "--compress", 1, false);
        options.add("-C", "--nocompress", 1, false);
        options.add("-e", "--encrypt", 1, false);
        options.add("-E", "--noencrypt", 1, false);
        options.add("-p", "--password", 1, true);
        options.add("-A", "--cryptalgo", 1, true);
        if (plugin != null) {
            plugin.populateStdCmdLineOptions(options);
        }
        return options;
    }
}

