/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.tunnel;

import java.io.Closeable;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.io.GuacamoleWriter;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.protocol.GuacamoleFilter;
import org.apache.guacamole.protocol.GuacamoleInstruction;
import org.apache.guacamole.tunnel.InterceptedStream;
import org.apache.guacamole.tunnel.InterceptedStreamMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StreamInterceptingFilter<T extends Closeable>
implements GuacamoleFilter {
    private static final Logger logger = LoggerFactory.getLogger(StreamInterceptingFilter.class);
    private final InterceptedStreamMap<T> streams = new InterceptedStreamMap();
    private final GuacamoleTunnel tunnel;

    public StreamInterceptingFilter(GuacamoleTunnel tunnel) {
        this.tunnel = tunnel;
    }

    protected void sendInstruction(GuacamoleInstruction instruction) {
        GuacamoleWriter writer = this.tunnel.acquireWriter();
        try {
            writer.writeInstruction(instruction);
        }
        catch (GuacamoleException e) {
            logger.debug("Unable to send \"{}\" for intercepted stream.", (Object)instruction.getOpcode(), (Object)e);
        }
        this.tunnel.releaseWriter();
    }

    protected InterceptedStream<T> getInterceptedStream(String index) {
        return this.streams.get(index);
    }

    protected InterceptedStream<T> closeInterceptedStream(String index) {
        return this.streams.close(index);
    }

    protected boolean closeInterceptedStream(InterceptedStream<T> stream) {
        return this.streams.close(stream);
    }

    public void closeAllInterceptedStreams() {
        this.streams.closeAll();
    }

    protected abstract void handleInterceptedStream(InterceptedStream<T> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interceptStream(int index, T stream) throws GuacamoleException {
        InterceptedStream interceptedStream;
        String indexString = Integer.toString(index);
        GuacamoleTunnel guacamoleTunnel = this.tunnel;
        synchronized (guacamoleTunnel) {
            if (!this.tunnel.isOpen()) {
                return;
            }
            interceptedStream = new InterceptedStream(indexString, stream);
            this.streams.put(interceptedStream);
        }
        this.handleInterceptedStream(interceptedStream);
        this.streams.waitFor(interceptedStream);
        if (interceptedStream.hasStreamError()) {
            throw interceptedStream.getStreamError();
        }
    }
}

