/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.permission;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import org.apache.guacamole.GuacamoleClientException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.auth.Permissions;
import org.apache.guacamole.net.auth.permission.ObjectPermission;
import org.apache.guacamole.net.auth.permission.Permission;
import org.apache.guacamole.net.auth.permission.PermissionSet;
import org.apache.guacamole.net.auth.permission.SystemPermission;
import org.apache.guacamole.rest.APIPatch;
import org.apache.guacamole.rest.PATCH;
import org.apache.guacamole.rest.permission.APIPermissionSet;
import org.apache.guacamole.rest.permission.PermissionSetPatch;
import org.apache.guacamole.rest.permission.PermissionSetResource;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class PermissionSetResource {
    private static final String CONNECTION_PERMISSION_PATCH_PATH_PREFIX = "/connectionPermissions/";
    private static final String CONNECTION_GROUP_PERMISSION_PATCH_PATH_PREFIX = "/connectionGroupPermissions/";
    private static final String SHARING_PROFILE_PERMISSION_PATCH_PATH_PREFIX = "/sharingProfilePermissions/";
    private static final String ACTIVE_CONNECTION_PERMISSION_PATCH_PATH_PREFIX = "/activeConnectionPermissions/";
    private static final String USER_PERMISSION_PATCH_PATH_PREFIX = "/userPermissions/";
    private static final String USER_GROUP_PERMISSION_PATCH_PATH_PREFIX = "/userGroupPermissions/";
    private static final String SYSTEM_PERMISSION_PATCH_PATH = "/systemPermissions";
    private final Permissions permissions;

    public PermissionSetResource(Permissions permissions) {
        this.permissions = permissions;
    }

    @GET
    public APIPermissionSet getPermissions() throws GuacamoleException {
        return new APIPermissionSet(this.permissions);
    }

    private <PermissionType extends Permission> void updatePermissionSet(APIPatch.Operation operation, PermissionSetPatch<PermissionType> permissionSetPatch, PermissionType permission) throws GuacamoleException {
        switch (1.$SwitchMap$org$apache$guacamole$rest$APIPatch$Operation[operation.ordinal()]) {
            case 1: {
                permissionSetPatch.addPermission(permission);
                break;
            }
            case 2: {
                permissionSetPatch.removePermission(permission);
                break;
            }
            default: {
                throw new GuacamoleClientException("Unsupported patch operation: \"" + operation + "\"");
            }
        }
    }

    @PATCH
    public void patchPermissions(List<APIPatch<String>> patches) throws GuacamoleException {
        PermissionSetPatch connectionPermissionPatch = new PermissionSetPatch();
        PermissionSetPatch connectionGroupPermissionPatch = new PermissionSetPatch();
        PermissionSetPatch sharingProfilePermissionPatch = new PermissionSetPatch();
        PermissionSetPatch activeConnectionPermissionPatch = new PermissionSetPatch();
        PermissionSetPatch userPermissionPatch = new PermissionSetPatch();
        PermissionSetPatch userGroupPermissionPatch = new PermissionSetPatch();
        PermissionSetPatch systemPermissionPatch = new PermissionSetPatch();
        for (APIPatch<String> patch : patches) {
            ObjectPermission permission;
            ObjectPermission.Type type;
            String identifier;
            String path = patch.getPath();
            if (path.startsWith(CONNECTION_PERMISSION_PATCH_PATH_PREFIX)) {
                identifier = path.substring(CONNECTION_PERMISSION_PATCH_PATH_PREFIX.length());
                type = ObjectPermission.Type.valueOf((String)((String)patch.getValue()));
                permission = new ObjectPermission(type, identifier);
                this.updatePermissionSet(patch.getOp(), connectionPermissionPatch, (Permission)permission);
                continue;
            }
            if (path.startsWith(CONNECTION_GROUP_PERMISSION_PATCH_PATH_PREFIX)) {
                identifier = path.substring(CONNECTION_GROUP_PERMISSION_PATCH_PATH_PREFIX.length());
                type = ObjectPermission.Type.valueOf((String)((String)patch.getValue()));
                permission = new ObjectPermission(type, identifier);
                this.updatePermissionSet(patch.getOp(), connectionGroupPermissionPatch, (Permission)permission);
                continue;
            }
            if (path.startsWith(SHARING_PROFILE_PERMISSION_PATCH_PATH_PREFIX)) {
                identifier = path.substring(SHARING_PROFILE_PERMISSION_PATCH_PATH_PREFIX.length());
                type = ObjectPermission.Type.valueOf((String)((String)patch.getValue()));
                permission = new ObjectPermission(type, identifier);
                this.updatePermissionSet(patch.getOp(), sharingProfilePermissionPatch, (Permission)permission);
                continue;
            }
            if (path.startsWith(ACTIVE_CONNECTION_PERMISSION_PATCH_PATH_PREFIX)) {
                identifier = path.substring(ACTIVE_CONNECTION_PERMISSION_PATCH_PATH_PREFIX.length());
                type = ObjectPermission.Type.valueOf((String)((String)patch.getValue()));
                permission = new ObjectPermission(type, identifier);
                this.updatePermissionSet(patch.getOp(), activeConnectionPermissionPatch, (Permission)permission);
                continue;
            }
            if (path.startsWith(USER_PERMISSION_PATCH_PATH_PREFIX)) {
                identifier = path.substring(USER_PERMISSION_PATCH_PATH_PREFIX.length());
                type = ObjectPermission.Type.valueOf((String)((String)patch.getValue()));
                permission = new ObjectPermission(type, identifier);
                this.updatePermissionSet(patch.getOp(), userPermissionPatch, (Permission)permission);
                continue;
            }
            if (path.startsWith(USER_GROUP_PERMISSION_PATCH_PATH_PREFIX)) {
                identifier = path.substring(USER_GROUP_PERMISSION_PATCH_PATH_PREFIX.length());
                type = ObjectPermission.Type.valueOf((String)((String)patch.getValue()));
                permission = new ObjectPermission(type, identifier);
                this.updatePermissionSet(patch.getOp(), userGroupPermissionPatch, (Permission)permission);
                continue;
            }
            if (path.equals(SYSTEM_PERMISSION_PATCH_PATH)) {
                SystemPermission.Type type2 = SystemPermission.Type.valueOf((String)((String)patch.getValue()));
                SystemPermission permission2 = new SystemPermission(type2);
                this.updatePermissionSet(patch.getOp(), systemPermissionPatch, (Permission)permission2);
                continue;
            }
            throw new GuacamoleClientException("Unsupported patch path: \"" + path + "\"");
        }
        connectionPermissionPatch.apply((PermissionSet)this.permissions.getConnectionPermissions());
        connectionGroupPermissionPatch.apply((PermissionSet)this.permissions.getConnectionGroupPermissions());
        sharingProfilePermissionPatch.apply((PermissionSet)this.permissions.getSharingProfilePermissions());
        activeConnectionPermissionPatch.apply((PermissionSet)this.permissions.getActiveConnectionPermissions());
        userPermissionPatch.apply((PermissionSet)this.permissions.getUserPermissions());
        userGroupPermissionPatch.apply((PermissionSet)this.permissions.getUserGroupPermissions());
        systemPermissionPatch.apply((PermissionSet)this.permissions.getSystemPermissions());
    }
}

