/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.auth;

import com.google.inject.Inject;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.bind.DatatypeConverter;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleResourceNotFoundException;
import org.apache.guacamole.GuacamoleSession;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.rest.APIRequest;
import org.apache.guacamole.rest.auth.APIAuthenticationResult;
import org.apache.guacamole.rest.auth.AuthenticationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/tokens")
@Produces(value={"application/json"})
public class TokenRESTService {
    private static final Logger logger = LoggerFactory.getLogger(TokenRESTService.class);
    @Inject
    private AuthenticationService authenticationService;

    private Credentials getCredentials(HttpServletRequest request, String username, String password) {
        String authorization;
        if (username == null && password == null && (authorization = request.getHeader("Authorization")) != null && authorization.startsWith("Basic ")) {
            try {
                String basicBase64 = authorization.substring(6);
                String basicCredentials = new String(DatatypeConverter.parseBase64Binary((String)basicBase64), "UTF-8");
                int colon = basicCredentials.indexOf(58);
                if (colon != -1) {
                    username = basicCredentials.substring(0, colon);
                    password = basicCredentials.substring(colon + 1);
                } else {
                    logger.debug("Invalid HTTP Basic \"Authorization\" header received.");
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new UnsupportedOperationException("Unexpected lack of UTF-8 support.", e);
            }
        }
        return new Credentials(username, password, request);
    }

    @POST
    public APIAuthenticationResult createToken(@FormParam(value="username") String username, @FormParam(value="password") String password, @FormParam(value="token") String token, @Context HttpServletRequest consumedRequest, MultivaluedMap<String, String> parameters) throws GuacamoleException {
        APIRequest request = new APIRequest(consumedRequest, parameters);
        Credentials credentials = this.getCredentials((HttpServletRequest)request, username, password);
        token = this.authenticationService.authenticate(credentials, token);
        GuacamoleSession session = this.authenticationService.getGuacamoleSession(token);
        if (session == null) {
            throw new GuacamoleResourceNotFoundException("No such token.");
        }
        List userContexts = session.getUserContexts();
        ArrayList<String> authProviderIdentifiers = new ArrayList<String>(userContexts.size());
        for (UserContext userContext : userContexts) {
            authProviderIdentifiers.add(userContext.getAuthenticationProvider().getIdentifier());
        }
        AuthenticatedUser authenticatedUser = session.getAuthenticatedUser();
        return new APIAuthenticationResult(token, authenticatedUser.getIdentifier(), authenticatedUser.getAuthenticationProvider().getIdentifier(), authProviderIdentifiers);
    }

    @DELETE
    @Path(value="/{token}")
    public void invalidateToken(@PathParam(value="token") String authToken) throws GuacamoleException {
        if (!this.authenticationService.destroyGuacamoleSession(authToken)) {
            throw new GuacamoleResourceNotFoundException("No such token.");
        }
    }
}

