/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.auth;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.GuacamoleSession;
import org.apache.guacamole.GuacamoleUnauthorizedException;
import org.apache.guacamole.environment.Environment;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.net.auth.credentials.CredentialsInfo;
import org.apache.guacamole.net.auth.credentials.GuacamoleCredentialsException;
import org.apache.guacamole.net.auth.credentials.GuacamoleInvalidCredentialsException;
import org.apache.guacamole.net.event.AuthenticationFailureEvent;
import org.apache.guacamole.net.event.AuthenticationSuccessEvent;
import org.apache.guacamole.rest.auth.AuthTokenGenerator;
import org.apache.guacamole.rest.auth.DecoratedUserContext;
import org.apache.guacamole.rest.auth.DecorationService;
import org.apache.guacamole.rest.auth.TokenSessionMap;
import org.apache.guacamole.rest.event.ListenerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationService {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationService.class);
    @Inject
    private Environment environment;
    @Inject
    private List<AuthenticationProvider> authProviders;
    @Inject
    private TokenSessionMap tokenSessionMap;
    @Inject
    private AuthTokenGenerator authTokenGenerator;
    @Inject
    private DecorationService decorationService;
    @Inject
    private ListenerService listenerService;
    private static final String IPV4_ADDRESS_REGEX = "([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})";
    private static final String IPV6_ADDRESS_REGEX = "([0-9a-fA-F]*(:[0-9a-fA-F]*){0,7})";
    private static final String IP_ADDRESS_REGEX = "(([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})|([0-9a-fA-F]*(:[0-9a-fA-F]*){0,7}))";
    private static final Pattern X_FORWARDED_FOR = Pattern.compile("^(([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})|([0-9a-fA-F]*(:[0-9a-fA-F]*){0,7}))(, (([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})|([0-9a-fA-F]*(:[0-9a-fA-F]*){0,7})))*$");

    private String getLoggableAddress(HttpServletRequest request) {
        String header = request.getHeader("X-Forwarded-For");
        if (header != null && X_FORWARDED_FOR.matcher(header).matches()) {
            return "[" + header + ", " + request.getRemoteAddr() + "]";
        }
        return request.getRemoteAddr();
    }

    private AuthenticatedUser authenticateUser(Credentials credentials) throws GuacamoleException {
        GuacamoleCredentialsException authFailure = null;
        for (AuthenticationProvider authProvider : this.authProviders) {
            try {
                AuthenticatedUser authenticatedUser = authProvider.authenticateUser(credentials);
                if (authenticatedUser == null) continue;
                return authenticatedUser;
            }
            catch (GuacamoleCredentialsException e) {
                if (authFailure != null) continue;
                authFailure = e;
            }
        }
        if (authFailure != null) {
            throw authFailure;
        }
        throw new GuacamoleInvalidCredentialsException("Permission Denied.", CredentialsInfo.USERNAME_PASSWORD);
    }

    private AuthenticatedUser updateAuthenticatedUser(AuthenticatedUser authenticatedUser, Credentials credentials) throws GuacamoleException {
        AuthenticationProvider authProvider = authenticatedUser.getAuthenticationProvider();
        if ((authenticatedUser = authProvider.updateAuthenticatedUser(authenticatedUser, credentials)) == null) {
            throw new GuacamoleSecurityException("User re-authentication failed.");
        }
        return authenticatedUser;
    }

    private void fireAuthenticationSuccessEvent(AuthenticatedUser authenticatedUser) throws GuacamoleException {
        this.listenerService.handleEvent((Object)new AuthenticationSuccessEvent(authenticatedUser));
    }

    private void fireAuthenticationFailedEvent(Credentials credentials) throws GuacamoleException {
        this.listenerService.handleEvent((Object)new AuthenticationFailureEvent(credentials));
    }

    private AuthenticatedUser getAuthenticatedUser(GuacamoleSession existingSession, Credentials credentials) throws GuacamoleException {
        try {
            if (existingSession != null) {
                AuthenticatedUser updatedUser = this.updateAuthenticatedUser(existingSession.getAuthenticatedUser(), credentials);
                this.fireAuthenticationSuccessEvent(updatedUser);
                return updatedUser;
            }
            AuthenticatedUser authenticatedUser = this.authenticateUser(credentials);
            this.fireAuthenticationSuccessEvent(authenticatedUser);
            if (logger.isInfoEnabled()) {
                logger.info("User \"{}\" successfully authenticated from {}.", (Object)authenticatedUser.getIdentifier(), (Object)this.getLoggableAddress(credentials.getRequest()));
            }
            return authenticatedUser;
        }
        catch (GuacamoleException e) {
            this.fireAuthenticationFailedEvent(credentials);
            HttpServletRequest request = credentials.getRequest();
            String username = credentials.getUsername();
            if (username != null) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Authentication attempt from {} for user \"{}\" failed.", (Object)this.getLoggableAddress(request), (Object)username);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("Anonymous authentication attempt from {} failed.", (Object)this.getLoggableAddress(request));
            }
            throw e;
        }
    }

    private List<DecoratedUserContext> getUserContexts(GuacamoleSession existingSession, AuthenticatedUser authenticatedUser, Credentials credentials) throws GuacamoleException {
        ArrayList<DecoratedUserContext> userContexts = new ArrayList<DecoratedUserContext>(this.authProviders.size());
        if (existingSession != null) {
            List oldUserContexts = existingSession.getUserContexts();
            for (DecoratedUserContext userContext : oldUserContexts) {
                UserContext oldUserContext = userContext.getUndecoratedUserContext();
                AuthenticationProvider authProvider = oldUserContext.getAuthenticationProvider();
                UserContext updatedUserContext = authProvider.updateUserContext(oldUserContext, authenticatedUser, credentials);
                if (updatedUserContext != null) {
                    userContexts.add(this.decorationService.redecorate(userContext, updatedUserContext, authenticatedUser, credentials));
                    continue;
                }
                logger.debug("AuthenticationProvider \"{}\" retroactively destroyed its UserContext.", (Object)authProvider.getClass().getName());
            }
        } else {
            for (AuthenticationProvider authProvider : this.authProviders) {
                UserContext userContext = authProvider.getUserContext(authenticatedUser);
                if (userContext == null) continue;
                userContexts.add(this.decorationService.decorate(userContext, authenticatedUser, credentials));
            }
        }
        return userContexts;
    }

    public String authenticate(Credentials credentials, String token) throws GuacamoleException {
        String authToken;
        GuacamoleSession existingSession = token != null ? this.tokenSessionMap.get(token) : null;
        AuthenticatedUser authenticatedUser = this.getAuthenticatedUser(existingSession, credentials);
        List userContexts = this.getUserContexts(existingSession, authenticatedUser, credentials);
        if (existingSession != null) {
            authToken = token;
            existingSession.setAuthenticatedUser(authenticatedUser);
            existingSession.setUserContexts(userContexts);
        } else {
            authToken = this.authTokenGenerator.getToken();
            this.tokenSessionMap.put(authToken, new GuacamoleSession(this.environment, authenticatedUser, userContexts));
            logger.debug("Login was successful for user \"{}\".", (Object)authenticatedUser.getIdentifier());
        }
        return authToken;
    }

    public GuacamoleSession getGuacamoleSession(String authToken) throws GuacamoleException {
        GuacamoleSession session = this.tokenSessionMap.get(authToken);
        if (session == null) {
            throw new GuacamoleUnauthorizedException("Permission Denied.");
        }
        return session;
    }

    public boolean destroyGuacamoleSession(String authToken) {
        GuacamoleSession session = this.tokenSessionMap.remove(authToken);
        if (session == null) {
            return false;
        }
        session.invalidate();
        return true;
    }

    public List<DecoratedUserContext> getUserContexts(String authToken) throws GuacamoleException {
        return this.getGuacamoleSession(authToken).getUserContexts();
    }
}

