/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.jam.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public class ResourcePath {
    private File[] mFiles;

    public static ResourcePath forFiles(File[] files) {
        return new ResourcePath(files);
    }

    private ResourcePath(File[] files) {
        if (files == null) {
            throw new IllegalArgumentException("null files");
        }
        this.mFiles = files;
    }

    public URI[] toUriPath() {
        URI[] out = new URI[this.mFiles.length];
        for (int i2 = 0; i2 < this.mFiles.length; ++i2) {
            out[i2] = this.mFiles[i2].toURI();
        }
        return out;
    }

    public URL[] toUrlPath() throws MalformedURLException {
        URL[] out = new URL[this.mFiles.length];
        for (int i2 = 0; i2 < this.mFiles.length; ++i2) {
            out[i2] = this.mFiles[i2].toURL();
        }
        return out;
    }

    public InputStream findInPath(String resource) {
        for (int i2 = 0; i2 < this.mFiles.length; ++i2) {
            File f2 = new File(this.mFiles[i2], resource);
            try {
                if (!f2.exists()) continue;
                return new FileInputStream(f2);
            }
            catch (FileNotFoundException weird) {
                weird.printStackTrace();
            }
        }
        return null;
    }

    public String toString() {
        StringWriter out = new StringWriter();
        for (int i2 = 0; i2 < this.mFiles.length; ++i2) {
            out.write(this.mFiles[i2].getAbsolutePath());
            out.write(File.pathSeparatorChar);
        }
        return out.toString();
    }
}

