/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans;

import javax.xml.namespace.QName;

public final class QNameCache {
    private static final float DEFAULT_LOAD = 0.7f;
    private final float loadFactor;
    private int numEntries = 0;
    private int threshold;
    private int hashmask;
    private QName[] table;
    static final /* synthetic */ boolean $assertionsDisabled;

    public QNameCache(int initialCapacity, float loadFactor) {
        int capacity;
        if (!$assertionsDisabled && initialCapacity <= 0) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || loadFactor > 0.0f && loadFactor < 1.0f)) {
            throw new AssertionError();
        }
        for (capacity = 16; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.hashmask = capacity - 1;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new QName[capacity];
    }

    public QNameCache(int initialCapacity) {
        this(initialCapacity, 0.7f);
    }

    public QName getName(String uri, String localName) {
        return this.getName(uri, localName, "");
    }

    public QName getName(String uri, String localName, String prefix) {
        if (!$assertionsDisabled && localName == null) {
            throw new AssertionError();
        }
        if (uri == null) {
            uri = "";
        }
        if (prefix == null) {
            prefix = "";
        }
        int index = QNameCache.hash(uri, localName, prefix) & this.hashmask;
        while (true) {
            QName q2;
            if ((q2 = this.table[index]) == null) {
                ++this.numEntries;
                if (this.numEntries >= this.threshold) {
                    this.rehash();
                }
                this.table[index] = new QName(uri, localName, prefix);
                return this.table[index];
            }
            if (QNameCache.equals(q2, uri, localName, prefix)) {
                return q2;
            }
            index = index - 1 & this.hashmask;
        }
    }

    private void rehash() {
        int newLength = this.table.length * 2;
        QName[] newTable = new QName[newLength];
        int newHashmask = newLength - 1;
        for (int i2 = 0; i2 < this.table.length; ++i2) {
            QName q2 = this.table[i2];
            if (q2 == null) continue;
            int newIndex = QNameCache.hash(q2.getNamespaceURI(), q2.getLocalPart(), q2.getPrefix()) & newHashmask;
            while (newTable[newIndex] != null) {
                newIndex = newIndex - 1 & newHashmask;
            }
            newTable[newIndex] = q2;
        }
        this.table = newTable;
        this.hashmask = newHashmask;
        this.threshold = (int)((float)newLength * this.loadFactor);
    }

    private static int hash(String uri, String localName, String prefix) {
        int h2 = 0;
        h2 += prefix.hashCode() << 10;
        h2 += uri.hashCode() << 5;
        return h2 += localName.hashCode();
    }

    private static boolean equals(QName q2, String uri, String localName, String prefix) {
        return q2.getLocalPart().equals(localName) && q2.getNamespaceURI().equals(uri) && q2.getPrefix().equals(prefix);
    }

    static {
        $assertionsDisabled = !QNameCache.class.desiredAssertionStatus();
    }
}

