/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.gvt;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import org.apache.batik.swing.gvt.InteractorAdapter;
import org.apache.batik.swing.gvt.JGVTComponent;

public abstract class AbstractPanInteractor
extends InteractorAdapter {
    public static final Cursor PAN_CURSOR = new Cursor(13);
    protected boolean finished = true;
    protected int xStart;
    protected int yStart;
    protected int xCurrent;
    protected int yCurrent;
    protected Cursor previousCursor;

    @Override
    public boolean endInteraction() {
        return this.finished;
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        if (!this.finished) {
            this.mouseExited(e2);
            return;
        }
        this.finished = false;
        this.xStart = e2.getX();
        this.yStart = e2.getY();
        JGVTComponent c2 = (JGVTComponent)e2.getSource();
        this.previousCursor = c2.getCursor();
        c2.setCursor(PAN_CURSOR);
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        if (this.finished) {
            return;
        }
        this.finished = true;
        JGVTComponent c2 = (JGVTComponent)e2.getSource();
        this.xCurrent = e2.getX();
        this.yCurrent = e2.getY();
        AffineTransform at = AffineTransform.getTranslateInstance(this.xCurrent - this.xStart, this.yCurrent - this.yStart);
        AffineTransform rt = (AffineTransform)c2.getRenderingTransform().clone();
        rt.preConcatenate(at);
        c2.setRenderingTransform(rt);
        if (c2.getCursor() == PAN_CURSOR) {
            c2.setCursor(this.previousCursor);
        }
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        this.finished = true;
        JGVTComponent c2 = (JGVTComponent)e2.getSource();
        c2.setPaintingTransform(null);
        if (c2.getCursor() == PAN_CURSOR) {
            c2.setCursor(this.previousCursor);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        JGVTComponent c2 = (JGVTComponent)e2.getSource();
        this.xCurrent = e2.getX();
        this.yCurrent = e2.getY();
        AffineTransform at = AffineTransform.getTranslateInstance(this.xCurrent - this.xStart, this.yCurrent - this.yStart);
        c2.setPaintingTransform(at);
    }
}

