/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font;

import org.apache.batik.svggen.font.Point;
import org.apache.batik.svggen.font.table.GlyphDescription;

public class Glyph {
    protected short leftSideBearing;
    protected int advanceWidth;
    private Point[] points;

    public Glyph(GlyphDescription gd, short lsb, int advance) {
        this.leftSideBearing = lsb;
        this.advanceWidth = advance;
        this.describe(gd);
    }

    public int getAdvanceWidth() {
        return this.advanceWidth;
    }

    public short getLeftSideBearing() {
        return this.leftSideBearing;
    }

    public Point getPoint(int i2) {
        return this.points[i2];
    }

    public int getPointCount() {
        return this.points.length;
    }

    public void reset() {
    }

    public void scale(int factor) {
        for (Point point : this.points) {
            point.x = (point.x << 10) * factor >> 26;
            point.y = (point.y << 10) * factor >> 26;
        }
        this.leftSideBearing = (short)(this.leftSideBearing * factor >> 6);
        this.advanceWidth = this.advanceWidth * factor >> 6;
    }

    private void describe(GlyphDescription gd) {
        int endPtIndex = 0;
        this.points = new Point[gd.getPointCount() + 2];
        for (int i2 = 0; i2 < gd.getPointCount(); ++i2) {
            boolean endPt;
            boolean bl = endPt = gd.getEndPtOfContours(endPtIndex) == i2;
            if (endPt) {
                ++endPtIndex;
            }
            this.points[i2] = new Point(gd.getXCoordinate(i2), gd.getYCoordinate(i2), (gd.getFlags(i2) & 1) != 0, endPt);
        }
        this.points[gd.getPointCount()] = new Point(0, 0, true, true);
        this.points[gd.getPointCount() + 1] = new Point(this.advanceWidth, 0, true, true);
    }
}

