/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImagingOpException;

public class FilterUtil {
    private FilterUtil() {
    }

    public static BufferedImage filter(BufferedImageOp op, BufferedImage src) {
        return FilterUtil.filter(op, src, op.createCompatibleDestImage(src, null));
    }

    public static BufferedImage filter(BufferedImageOp op, BufferedImage src, BufferedImage dst) {
        try {
            return op.filter(src, dst);
        }
        catch (ImagingOpException e2) {
            BufferedImage _src = FilterUtil.copy(src);
            BufferedImage _dst = FilterUtil.copy(dst);
            op.filter(_src, _dst);
            Graphics2D gfx = dst.createGraphics();
            gfx.drawImage((Image)_dst, 0, 0, null);
            gfx.dispose();
            return dst;
        }
    }

    private static BufferedImage copy(BufferedImage img) {
        BufferedImage copy = new BufferedImage(img.getWidth(), img.getHeight(), 2);
        Graphics2D gfx = copy.createGraphics();
        gfx.drawImage((Image)img, 0, 0, null);
        gfx.dispose();
        return copy;
    }
}

