/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.geom;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.apache.batik.ext.awt.geom.Polygon2D;

public class Polyline2D
implements Shape,
Cloneable,
Serializable {
    private static final float ASSUME_ZERO = 0.001f;
    public int npoints;
    public float[] xpoints;
    public float[] ypoints;
    protected Rectangle2D bounds;
    private GeneralPath path;
    private GeneralPath closedPath;

    public Polyline2D() {
        this.xpoints = new float[4];
        this.ypoints = new float[4];
    }

    public Polyline2D(float[] xpoints, float[] ypoints, int npoints) {
        if (npoints > xpoints.length || npoints > ypoints.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        this.npoints = npoints;
        this.xpoints = new float[npoints + 1];
        this.ypoints = new float[npoints + 1];
        System.arraycopy(xpoints, 0, this.xpoints, 0, npoints);
        System.arraycopy(ypoints, 0, this.ypoints, 0, npoints);
        this.calculatePath();
    }

    public Polyline2D(int[] xpoints, int[] ypoints, int npoints) {
        if (npoints > xpoints.length || npoints > ypoints.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        this.npoints = npoints;
        this.xpoints = new float[npoints];
        this.ypoints = new float[npoints];
        for (int i2 = 0; i2 < npoints; ++i2) {
            this.xpoints[i2] = xpoints[i2];
            this.ypoints[i2] = ypoints[i2];
        }
        this.calculatePath();
    }

    public Polyline2D(Line2D line) {
        this.npoints = 2;
        this.xpoints = new float[2];
        this.ypoints = new float[2];
        this.xpoints[0] = (float)line.getX1();
        this.xpoints[1] = (float)line.getX2();
        this.ypoints[0] = (float)line.getY1();
        this.ypoints[1] = (float)line.getY2();
        this.calculatePath();
    }

    public void reset() {
        this.npoints = 0;
        this.bounds = null;
        this.path = new GeneralPath();
        this.closedPath = null;
    }

    public Object clone() {
        Polyline2D pol = new Polyline2D();
        for (int i2 = 0; i2 < this.npoints; ++i2) {
            pol.addPoint(this.xpoints[i2], this.ypoints[i2]);
        }
        return pol;
    }

    private void calculatePath() {
        this.path = new GeneralPath();
        this.path.moveTo(this.xpoints[0], this.ypoints[0]);
        for (int i2 = 1; i2 < this.npoints; ++i2) {
            this.path.lineTo(this.xpoints[i2], this.ypoints[i2]);
        }
        this.bounds = this.path.getBounds2D();
        this.closedPath = null;
    }

    private void updatePath(float x2, float y2) {
        this.closedPath = null;
        if (this.path == null) {
            this.path = new GeneralPath(0);
            this.path.moveTo(x2, y2);
            this.bounds = new Rectangle2D.Float(x2, y2, 0.0f, 0.0f);
        } else {
            this.path.lineTo(x2, y2);
            float _xmax = (float)this.bounds.getMaxX();
            float _ymax = (float)this.bounds.getMaxY();
            float _xmin = (float)this.bounds.getMinX();
            float _ymin = (float)this.bounds.getMinY();
            if (x2 < _xmin) {
                _xmin = x2;
            } else if (x2 > _xmax) {
                _xmax = x2;
            }
            if (y2 < _ymin) {
                _ymin = y2;
            } else if (y2 > _ymax) {
                _ymax = y2;
            }
            this.bounds = new Rectangle2D.Float(_xmin, _ymin, _xmax - _xmin, _ymax - _ymin);
        }
    }

    public void addPoint(Point2D p2) {
        this.addPoint((float)p2.getX(), (float)p2.getY());
    }

    public void addPoint(float x2, float y2) {
        if (this.npoints == this.xpoints.length) {
            float[] tmp = new float[this.npoints * 2];
            System.arraycopy(this.xpoints, 0, tmp, 0, this.npoints);
            this.xpoints = tmp;
            tmp = new float[this.npoints * 2];
            System.arraycopy(this.ypoints, 0, tmp, 0, this.npoints);
            this.ypoints = tmp;
        }
        this.xpoints[this.npoints] = x2;
        this.ypoints[this.npoints] = y2;
        ++this.npoints;
        this.updatePath(x2, y2);
    }

    @Override
    public Rectangle getBounds() {
        if (this.bounds == null) {
            return null;
        }
        return this.bounds.getBounds();
    }

    private void updateComputingPath() {
        if (this.npoints >= 1 && this.closedPath == null) {
            this.closedPath = (GeneralPath)this.path.clone();
            this.closedPath.closePath();
        }
    }

    public boolean contains(Point p2) {
        return false;
    }

    @Override
    public boolean contains(double x2, double y2) {
        return false;
    }

    public boolean contains(int x2, int y2) {
        return false;
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    @Override
    public boolean contains(Point2D p2) {
        return false;
    }

    @Override
    public boolean intersects(double x2, double y2, double w2, double h2) {
        if (this.npoints <= 0 || !this.bounds.intersects(x2, y2, w2, h2)) {
            return false;
        }
        this.updateComputingPath();
        return this.closedPath.intersects(x2, y2, w2, h2);
    }

    @Override
    public boolean intersects(Rectangle2D r2) {
        return this.intersects(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight());
    }

    @Override
    public boolean contains(double x2, double y2, double w2, double h2) {
        return false;
    }

    @Override
    public boolean contains(Rectangle2D r2) {
        return false;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        if (this.path == null) {
            return null;
        }
        return this.path.getPathIterator(at);
    }

    public Polygon2D getPolygon2D() {
        Polygon2D pol = new Polygon2D();
        for (int i2 = 0; i2 < this.npoints - 1; ++i2) {
            pol.addPoint(this.xpoints[i2], this.ypoints[i2]);
        }
        Point2D.Double p0 = new Point2D.Double(this.xpoints[0], this.ypoints[0]);
        Point2D.Double p1 = new Point2D.Double(this.xpoints[this.npoints - 1], this.ypoints[this.npoints - 1]);
        if (p0.distance(p1) > (double)0.001f) {
            pol.addPoint(this.xpoints[this.npoints - 1], this.ypoints[this.npoints - 1]);
        }
        return pol;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.path.getPathIterator(at);
    }
}

