/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.events;

import java.util.HashMap;
import org.apache.batik.dom.util.IntTable;
import org.w3c.dom.events.EventListener;

public class EventListenerList {
    protected int n;
    protected Entry head;
    protected IntTable counts = new IntTable();
    protected Entry[] listeners;
    protected HashMap listenersNS = new HashMap();

    public void addListener(String namespaceURI, Object group, EventListener listener) {
        Entry e2 = this.head;
        while (e2 != null) {
            if ((namespaceURI != null && namespaceURI.equals(e2.namespaceURI) || namespaceURI == null && e2.namespaceURI == null) && e2.listener == listener) {
                return;
            }
            e2 = e2.next;
        }
        this.head = new Entry(listener, namespaceURI, group, this.head);
        this.counts.inc(namespaceURI);
        ++this.n;
        this.listeners = null;
        this.listenersNS.remove(namespaceURI);
    }

    public void removeListener(String namespaceURI, EventListener listener) {
        if (this.head == null) {
            return;
        }
        if (this.head != null && (namespaceURI != null && namespaceURI.equals(this.head.namespaceURI) || namespaceURI == null && this.head.namespaceURI == null) && listener == this.head.listener) {
            this.head = this.head.next;
        } else {
            Entry prev = this.head;
            Entry e2 = this.head.next;
            while (e2 != null) {
                if ((namespaceURI != null && namespaceURI.equals(e2.namespaceURI) || namespaceURI == null && e2.namespaceURI == null) && e2.listener == listener) {
                    prev.next = e2.next;
                    break;
                }
                prev = e2;
                e2 = e2.next;
            }
            if (e2 == null) {
                return;
            }
        }
        this.counts.dec(namespaceURI);
        --this.n;
        this.listeners = null;
        this.listenersNS.remove(namespaceURI);
    }

    public Entry[] getEventListeners() {
        if (this.listeners != null) {
            return this.listeners;
        }
        this.listeners = new Entry[this.n];
        int i2 = 0;
        Entry e2 = this.head;
        while (e2 != null) {
            this.listeners[i2++] = e2;
            e2 = e2.next;
        }
        return this.listeners;
    }

    public Entry[] getEventListeners(String namespaceURI) {
        if (namespaceURI == null) {
            return this.getEventListeners();
        }
        Entry[] ls = (Entry[])this.listenersNS.get(namespaceURI);
        if (ls != null) {
            return ls;
        }
        int count = this.counts.get(namespaceURI);
        if (count == 0) {
            return null;
        }
        ls = new Entry[count];
        this.listenersNS.put(namespaceURI, ls);
        int i2 = 0;
        Entry e2 = this.head;
        while (i2 < count) {
            if (namespaceURI.equals(e2.namespaceURI)) {
                ls[i2++] = e2;
            }
            e2 = e2.next;
        }
        return ls;
    }

    public boolean hasEventListener(String namespaceURI) {
        if (namespaceURI == null) {
            return this.n != 0;
        }
        return this.counts.get(namespaceURI) != 0;
    }

    public int size() {
        return this.n;
    }

    public static class Entry {
        protected EventListener listener;
        protected String namespaceURI;
        protected Object group;
        protected boolean mark;
        protected Entry next;

        public Entry(EventListener listener, String namespaceURI, Object group, Entry next) {
            this.listener = listener;
            this.namespaceURI = namespaceURI;
            this.group = group;
            this.next = next;
        }

        public EventListener getListener() {
            return this.listener;
        }

        public Object getGroup() {
            return this.group;
        }

        public String getNamespaceURI() {
            return this.namespaceURI;
        }
    }
}

