/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine;

public class StringIntMap {
    protected Entry[] table;
    protected int count;

    public StringIntMap(int c2) {
        this.table = new Entry[c2 - (c2 >> 2) + 1];
    }

    public int get(String key) {
        int hash = key.hashCode() & Integer.MAX_VALUE;
        int index = hash % this.table.length;
        Entry e2 = this.table[index];
        while (e2 != null) {
            if (e2.hash == hash && e2.key.equals(key)) {
                return e2.value;
            }
            e2 = e2.next;
        }
        return -1;
    }

    public void put(String key, int value) {
        Entry e2;
        int hash = key.hashCode() & Integer.MAX_VALUE;
        int index = hash % this.table.length;
        Entry e3 = this.table[index];
        while (e3 != null) {
            if (e3.hash == hash && e3.key.equals(key)) {
                e3.value = value;
                return;
            }
            e3 = e3.next;
        }
        int len = this.table.length;
        if (this.count++ >= len - (len >> 2)) {
            this.rehash();
            index = hash % this.table.length;
        }
        this.table[index] = e2 = new Entry(hash, key, value, this.table[index]);
    }

    protected void rehash() {
        Entry[] oldTable = this.table;
        this.table = new Entry[oldTable.length * 2 + 1];
        for (int i2 = oldTable.length - 1; i2 >= 0; --i2) {
            Entry old = oldTable[i2];
            while (old != null) {
                Entry e2 = old;
                old = old.next;
                int index = e2.hash % this.table.length;
                e2.next = this.table[index];
                this.table[index] = e2;
            }
        }
    }

    protected static class Entry {
        public final int hash;
        public String key;
        public int value;
        public Entry next;

        public Entry(int hash, String key, int value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

