/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge.svg12;

import org.apache.batik.anim.dom.BindableElement;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.ScriptingEnvironment;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.bridge.svg12.ContentSelectionChangedEvent;
import org.apache.batik.bridge.svg12.SVG12BridgeUpdateHandler;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;

public class BindableElementBridge
extends AbstractGraphicsNodeBridge
implements SVG12BridgeUpdateHandler {
    @Override
    public String getNamespaceURI() {
        return "*";
    }

    @Override
    public String getLocalName() {
        return "*";
    }

    @Override
    public Bridge getInstance() {
        return new BindableElementBridge();
    }

    @Override
    public GraphicsNode createGraphicsNode(BridgeContext ctx, Element e2) {
        if (!SVGUtilities.matchUserAgent(e2, ctx.getUserAgent())) {
            return null;
        }
        CompositeGraphicsNode gn = this.buildCompositeGraphicsNode(ctx, e2, null);
        return gn;
    }

    public CompositeGraphicsNode buildCompositeGraphicsNode(BridgeContext ctx, Element e2, CompositeGraphicsNode gn) {
        ScriptingEnvironment se;
        BindableElement be = (BindableElement)e2;
        Element shadowTree = be.getXblShadowTree();
        UpdateManager um = ctx.getUpdateManager();
        ScriptingEnvironment scriptingEnvironment = se = um == null ? null : um.getScriptingEnvironment();
        if (se != null && shadowTree != null) {
            se.addScriptingListeners(shadowTree);
        }
        if (gn == null) {
            gn = new CompositeGraphicsNode();
            this.associateSVGContext(ctx, e2, gn);
        } else {
            int s2 = gn.size();
            for (int i2 = 0; i2 < s2; ++i2) {
                gn.remove(0);
            }
        }
        GVTBuilder builder = ctx.getGVTBuilder();
        if (shadowTree != null) {
            GraphicsNode shadowNode = builder.build(ctx, shadowTree);
            if (shadowNode != null) {
                gn.add(shadowNode);
            }
        } else {
            for (Node m2 = e2.getFirstChild(); m2 != null; m2 = m2.getNextSibling()) {
                GraphicsNode n2;
                if (m2.getNodeType() != 1 || (n2 = builder.build(ctx, (Element)m2)) == null) continue;
                gn.add(n2);
            }
        }
        return gn;
    }

    @Override
    public void dispose() {
        BindableElement be = (BindableElement)this.e;
        if (be != null && be.getCSSFirstChild() != null) {
            BindableElementBridge.disposeTree(be.getCSSFirstChild());
        }
        super.dispose();
    }

    @Override
    protected GraphicsNode instantiateGraphicsNode() {
        return null;
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public void buildGraphicsNode(BridgeContext ctx, Element e2, GraphicsNode node) {
        this.initializeDynamicSupport(ctx, e2, node);
    }

    @Override
    public void handleDOMNodeInsertedEvent(MutationEvent evt) {
        BindableElement be = (BindableElement)this.e;
        Element shadowTree = be.getXblShadowTree();
        if (shadowTree == null && evt.getTarget() instanceof Element) {
            this.handleElementAdded((CompositeGraphicsNode)this.node, this.e, (Element)((Object)evt.getTarget()));
        }
    }

    @Override
    public void handleBindingEvent(Element bindableElement, Element shadowTree) {
        CompositeGraphicsNode gn = this.node.getParent();
        gn.remove(this.node);
        BindableElementBridge.disposeTree(this.e);
        this.handleElementAdded(gn, this.e.getParentNode(), this.e);
    }

    @Override
    public void handleContentSelectionChangedEvent(ContentSelectionChangedEvent csce) {
    }

    protected void handleElementAdded(CompositeGraphicsNode gn, Node parent, Element childElt) {
        GVTBuilder builder = this.ctx.getGVTBuilder();
        GraphicsNode childNode = builder.build(this.ctx, childElt);
        if (childNode == null) {
            return;
        }
        int idx = -1;
        for (Node ps = childElt.getPreviousSibling(); ps != null; ps = ps.getPreviousSibling()) {
            GraphicsNode psgn;
            if (ps.getNodeType() != 1) continue;
            Element pse = (Element)ps;
            for (psgn = this.ctx.getGraphicsNode(pse); psgn != null && psgn.getParent() != gn; psgn = psgn.getParent()) {
            }
            if (psgn != null && (idx = gn.indexOf(psgn)) != -1) break;
        }
        gn.add(++idx, childNode);
    }
}

