/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;

public abstract class UnitProcessor
extends org.apache.batik.parser.UnitProcessor {
    public static UnitProcessor.Context createContext(BridgeContext ctx, Element e2) {
        return new DefaultContext(ctx, e2);
    }

    public static float svgHorizontalCoordinateToObjectBoundingBox(String s2, String attr, UnitProcessor.Context ctx) {
        return UnitProcessor.svgToObjectBoundingBox(s2, attr, (short)2, ctx);
    }

    public static float svgVerticalCoordinateToObjectBoundingBox(String s2, String attr, UnitProcessor.Context ctx) {
        return UnitProcessor.svgToObjectBoundingBox(s2, attr, (short)1, ctx);
    }

    public static float svgOtherCoordinateToObjectBoundingBox(String s2, String attr, UnitProcessor.Context ctx) {
        return UnitProcessor.svgToObjectBoundingBox(s2, attr, (short)0, ctx);
    }

    public static float svgHorizontalLengthToObjectBoundingBox(String s2, String attr, UnitProcessor.Context ctx) {
        return UnitProcessor.svgLengthToObjectBoundingBox(s2, attr, (short)2, ctx);
    }

    public static float svgVerticalLengthToObjectBoundingBox(String s2, String attr, UnitProcessor.Context ctx) {
        return UnitProcessor.svgLengthToObjectBoundingBox(s2, attr, (short)1, ctx);
    }

    public static float svgOtherLengthToObjectBoundingBox(String s2, String attr, UnitProcessor.Context ctx) {
        return UnitProcessor.svgLengthToObjectBoundingBox(s2, attr, (short)0, ctx);
    }

    public static float svgLengthToObjectBoundingBox(String s2, String attr, short d2, UnitProcessor.Context ctx) {
        float v2 = UnitProcessor.svgToObjectBoundingBox(s2, attr, d2, ctx);
        if (v2 < 0.0f) {
            throw new BridgeException(UnitProcessor.getBridgeContext(ctx), ctx.getElement(), "length.negative", new Object[]{attr, s2});
        }
        return v2;
    }

    public static float svgToObjectBoundingBox(String s2, String attr, short d2, UnitProcessor.Context ctx) {
        try {
            return org.apache.batik.parser.UnitProcessor.svgToObjectBoundingBox(s2, attr, d2, ctx);
        }
        catch (ParseException pEx) {
            throw new BridgeException(UnitProcessor.getBridgeContext(ctx), ctx.getElement(), pEx, "attribute.malformed", new Object[]{attr, s2, pEx});
        }
    }

    public static float svgHorizontalLengthToUserSpace(String s2, String attr, UnitProcessor.Context ctx) {
        return UnitProcessor.svgLengthToUserSpace(s2, attr, (short)2, ctx);
    }

    public static float svgVerticalLengthToUserSpace(String s2, String attr, UnitProcessor.Context ctx) {
        return UnitProcessor.svgLengthToUserSpace(s2, attr, (short)1, ctx);
    }

    public static float svgOtherLengthToUserSpace(String s2, String attr, UnitProcessor.Context ctx) {
        return UnitProcessor.svgLengthToUserSpace(s2, attr, (short)0, ctx);
    }

    public static float svgHorizontalCoordinateToUserSpace(String s2, String attr, UnitProcessor.Context ctx) {
        return UnitProcessor.svgToUserSpace(s2, attr, (short)2, ctx);
    }

    public static float svgVerticalCoordinateToUserSpace(String s2, String attr, UnitProcessor.Context ctx) {
        return UnitProcessor.svgToUserSpace(s2, attr, (short)1, ctx);
    }

    public static float svgOtherCoordinateToUserSpace(String s2, String attr, UnitProcessor.Context ctx) {
        return UnitProcessor.svgToUserSpace(s2, attr, (short)0, ctx);
    }

    public static float svgLengthToUserSpace(String s2, String attr, short d2, UnitProcessor.Context ctx) {
        float v2 = UnitProcessor.svgToUserSpace(s2, attr, d2, ctx);
        if (v2 < 0.0f) {
            throw new BridgeException(UnitProcessor.getBridgeContext(ctx), ctx.getElement(), "length.negative", new Object[]{attr, s2});
        }
        return v2;
    }

    public static float svgToUserSpace(String s2, String attr, short d2, UnitProcessor.Context ctx) {
        try {
            return org.apache.batik.parser.UnitProcessor.svgToUserSpace(s2, attr, d2, ctx);
        }
        catch (ParseException pEx) {
            throw new BridgeException(UnitProcessor.getBridgeContext(ctx), ctx.getElement(), pEx, "attribute.malformed", new Object[]{attr, s2, pEx});
        }
    }

    protected static BridgeContext getBridgeContext(UnitProcessor.Context ctx) {
        if (ctx instanceof DefaultContext) {
            return ((DefaultContext)ctx).ctx;
        }
        return null;
    }

    public static class DefaultContext
    implements UnitProcessor.Context {
        protected Element e;
        protected BridgeContext ctx;

        public DefaultContext(BridgeContext ctx, Element e2) {
            this.ctx = ctx;
            this.e = e2;
        }

        @Override
        public Element getElement() {
            return this.e;
        }

        @Override
        public float getPixelUnitToMillimeter() {
            return this.ctx.getUserAgent().getPixelUnitToMillimeter();
        }

        @Override
        public float getPixelToMM() {
            return this.getPixelUnitToMillimeter();
        }

        @Override
        public float getFontSize() {
            return CSSUtilities.getComputedStyle(this.e, 22).getFloatValue();
        }

        @Override
        public float getXHeight() {
            return 0.5f;
        }

        @Override
        public float getViewportWidth() {
            return this.ctx.getViewport(this.e).getWidth();
        }

        @Override
        public float getViewportHeight() {
            return this.ctx.getViewport(this.e).getHeight();
        }
    }
}

