/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.apache.batik.apps.svgbrowser.JSVGViewerFrame;

public class LocalHistory {
    protected JSVGViewerFrame svgFrame;
    protected JMenu menu;
    protected int index;
    protected List visitedURIs = new ArrayList();
    protected int currentURI = -1;
    protected ButtonGroup group = new ButtonGroup();
    protected ActionListener actionListener = new RadioListener();
    protected int state;
    protected static final int STABLE_STATE = 0;
    protected static final int BACK_PENDING_STATE = 1;
    protected static final int FORWARD_PENDING_STATE = 2;
    protected static final int RELOAD_PENDING_STATE = 3;

    public LocalHistory(JMenuBar mb, JSVGViewerFrame svgFrame) {
        this.svgFrame = svgFrame;
        int mc = mb.getMenuCount();
        for (int i2 = 0; i2 < mc; ++i2) {
            JMenu m2 = mb.getMenu(i2);
            int ic = m2.getItemCount();
            for (int j2 = 0; j2 < ic; ++j2) {
                String s2;
                JMenuItem mi = m2.getItem(j2);
                if (mi == null || !"@@@".equals(s2 = mi.getText())) continue;
                this.menu = m2;
                this.index = j2;
                m2.remove(j2);
                return;
            }
        }
        throw new IllegalArgumentException("No '@@@' marker found");
    }

    public void back() {
        this.update();
        this.state = 1;
        this.currentURI -= 2;
        this.svgFrame.showSVGDocument((String)this.visitedURIs.get(this.currentURI + 1));
    }

    public boolean canGoBack() {
        return this.currentURI > 0;
    }

    public void forward() {
        this.update();
        this.state = 2;
        this.svgFrame.showSVGDocument((String)this.visitedURIs.get(this.currentURI + 1));
    }

    public boolean canGoForward() {
        return this.currentURI < this.visitedURIs.size() - 1;
    }

    public void reload() {
        this.update();
        this.state = 3;
        --this.currentURI;
        this.svgFrame.showSVGDocument((String)this.visitedURIs.get(this.currentURI + 1));
    }

    public void update(String uri) {
        JMenuItem mi;
        JMenuItem mi2;
        int i2;
        if (this.currentURI < -1) {
            throw new IllegalStateException("Unexpected currentURI:" + this.currentURI);
        }
        this.state = 0;
        if (++this.currentURI < this.visitedURIs.size()) {
            if (!this.visitedURIs.get(this.currentURI).equals(uri)) {
                int len = this.menu.getItemCount();
                for (i2 = len - 1; i2 >= this.index + this.currentURI + 1; --i2) {
                    mi2 = this.menu.getItem(i2);
                    this.group.remove(mi2);
                    this.menu.remove(i2);
                }
                this.visitedURIs = this.visitedURIs.subList(0, this.currentURI + 1);
            }
            mi = this.menu.getItem(this.index + this.currentURI);
            this.group.remove(mi);
            this.menu.remove(this.index + this.currentURI);
            this.visitedURIs.set(this.currentURI, uri);
        } else {
            if (this.visitedURIs.size() >= 15) {
                this.visitedURIs.remove(0);
                mi = this.menu.getItem(this.index);
                this.group.remove(mi);
                this.menu.remove(this.index);
                --this.currentURI;
            }
            this.visitedURIs.add(uri);
        }
        String text = uri;
        i2 = uri.lastIndexOf(47);
        if (i2 == -1) {
            i2 = uri.lastIndexOf(92);
        }
        if (i2 != -1) {
            text = uri.substring(i2 + 1);
        }
        mi2 = new JRadioButtonMenuItem(text);
        mi2.setToolTipText(uri);
        mi2.setActionCommand(uri);
        mi2.addActionListener(this.actionListener);
        this.group.add(mi2);
        mi2.setSelected(true);
        this.menu.insert(mi2, this.index + this.currentURI);
    }

    protected void update() {
        switch (this.state) {
            case 1: {
                this.currentURI += 2;
                break;
            }
            case 3: {
                ++this.currentURI;
                break;
            }
        }
    }

    protected class RadioListener
    implements ActionListener {
        protected RadioListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            String uri = e2.getActionCommand();
            LocalHistory.this.currentURI = this.getItemIndex((JMenuItem)e2.getSource()) - 1;
            LocalHistory.this.svgFrame.showSVGDocument(uri);
        }

        public int getItemIndex(JMenuItem item) {
            int ic = LocalHistory.this.menu.getItemCount();
            for (int i2 = LocalHistory.this.index; i2 < ic; ++i2) {
                if (LocalHistory.this.menu.getItem(i2) != item) continue;
                return i2 - LocalHistory.this.index;
            }
            throw new IllegalArgumentException("MenuItem is not from my menu!");
        }
    }
}

