/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.batik.bridge.Mark;
import org.apache.batik.bridge.TextNode;
import org.apache.batik.gvt.GVTTreeWalker;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.util.gui.ExtendedGridBagConstraints;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.ButtonFactory;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.apache.batik.util.resources.ResourceManager;

public class FindDialog
extends JDialog
implements ActionMap {
    protected static final String RESOURCES = "org.apache.batik.apps.svgbrowser.resources.FindDialog";
    public static final String FIND_ACTION = "FindButtonAction";
    public static final String CLEAR_ACTION = "ClearButtonAction";
    public static final String CLOSE_ACTION = "CloseButtonAction";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.apps.svgbrowser.resources.FindDialog", Locale.getDefault());
    protected static ResourceManager resources = new ResourceManager(bundle);
    protected ButtonFactory buttonFactory;
    protected GraphicsNode gvtRoot;
    protected GVTTreeWalker walker;
    protected int currentIndex;
    protected JTextField search;
    protected JButton findButton;
    protected JButton clearButton;
    protected JButton closeButton;
    protected JCheckBox caseSensitive;
    protected JSVGCanvas svgCanvas;
    protected JRadioButton highlightButton;
    protected JRadioButton highlightCenterButton;
    protected JRadioButton highlightCenterZoomButton;
    protected Map listeners = new HashMap(10);

    public FindDialog(JSVGCanvas svgCanvas) {
        this(null, svgCanvas);
    }

    public FindDialog(Frame owner, JSVGCanvas svgCanvas) {
        super(owner, resources.getString("Dialog.title"));
        this.svgCanvas = svgCanvas;
        this.buttonFactory = new ButtonFactory(bundle, this);
        this.listeners.put(FIND_ACTION, new FindButtonAction());
        this.listeners.put(CLEAR_ACTION, new ClearButtonAction());
        this.listeners.put(CLOSE_ACTION, new CloseButtonAction());
        JPanel p2 = new JPanel(new BorderLayout());
        p2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        p2.add((Component)this.createFindPanel(), "Center");
        p2.add((Component)this.createShowResultPanel(), "South");
        this.getContentPane().add((Component)p2, "Center");
        this.getContentPane().add((Component)this.createButtonsPanel(), "South");
    }

    protected JPanel createFindPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getString("Panel.title")));
        ExtendedGridBagConstraints gbc = new ExtendedGridBagConstraints();
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.setWeight(0.0, 0.0);
        gbc.setGridBounds(0, 0, 1, 1);
        panel.add((Component)new JLabel(resources.getString("FindLabel.text")), gbc);
        gbc.fill = 2;
        gbc.setWeight(1.0, 0.0);
        gbc.setGridBounds(1, 0, 2, 1);
        this.search = new JTextField(20);
        panel.add((Component)this.search, gbc);
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.setWeight(0.0, 0.0);
        gbc.setGridBounds(1, 1, 1, 1);
        this.caseSensitive = this.buttonFactory.createJCheckBox("CaseSensitiveCheckBox");
        panel.add((Component)this.caseSensitive, gbc);
        return panel;
    }

    protected JPanel createShowResultPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getString("ShowResultPanel.title")));
        ExtendedGridBagConstraints gbc = new ExtendedGridBagConstraints();
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.setWeight(0.0, 0.0);
        ButtonGroup grp = new ButtonGroup();
        this.highlightButton = this.buttonFactory.createJRadioButton("Highlight");
        this.highlightButton.setSelected(true);
        grp.add(this.highlightButton);
        gbc.setGridBounds(0, 0, 1, 1);
        panel.add((Component)this.highlightButton, gbc);
        this.highlightCenterButton = this.buttonFactory.createJRadioButton("HighlightAndCenter");
        grp.add(this.highlightCenterButton);
        gbc.setGridBounds(0, 1, 1, 1);
        panel.add((Component)this.highlightCenterButton, gbc);
        this.highlightCenterZoomButton = this.buttonFactory.createJRadioButton("HighlightCenterAndZoom");
        grp.add(this.highlightCenterZoomButton);
        gbc.setGridBounds(0, 2, 1, 1);
        panel.add((Component)this.highlightCenterZoomButton, gbc);
        return panel;
    }

    protected JPanel createButtonsPanel() {
        JPanel panel = new JPanel(new FlowLayout(2));
        this.findButton = this.buttonFactory.createJButton("FindButton");
        panel.add(this.findButton);
        this.clearButton = this.buttonFactory.createJButton("ClearButton");
        panel.add(this.clearButton);
        this.closeButton = this.buttonFactory.createJButton("CloseButton");
        panel.add(this.closeButton);
        return panel;
    }

    public void setGraphicsNode(GraphicsNode gvtRoot) {
        this.gvtRoot = gvtRoot;
        this.walker = gvtRoot != null ? new GVTTreeWalker(gvtRoot) : null;
    }

    protected GraphicsNode getNext(String text) {
        GraphicsNode gn;
        int index;
        if (this.walker == null && this.gvtRoot != null) {
            this.walker = new GVTTreeWalker(this.gvtRoot);
        }
        if ((index = this.match(gn = this.walker.getCurrentGraphicsNode(), text, this.currentIndex + text.length())) >= 0) {
            this.currentIndex = index;
        } else {
            this.currentIndex = 0;
            gn = this.walker.nextGraphicsNode();
            while (gn != null && (this.currentIndex = this.match(gn, text, this.currentIndex)) < 0) {
                this.currentIndex = 0;
                gn = this.walker.nextGraphicsNode();
            }
        }
        return gn;
    }

    protected int match(GraphicsNode node, String text, int index) {
        if (!(node instanceof TextNode) || !node.isVisible() || text == null || text.length() == 0) {
            return -1;
        }
        String s2 = ((TextNode)node).getText();
        if (!this.caseSensitive.isSelected()) {
            s2 = s2.toLowerCase();
            text = text.toLowerCase();
        }
        return s2.indexOf(text, index);
    }

    protected void showSelectedGraphicsNode() {
        double sy;
        double sx;
        double scale;
        GraphicsNode gn = this.walker.getCurrentGraphicsNode();
        if (!(gn instanceof TextNode)) {
            return;
        }
        TextNode textNode = (TextNode)gn;
        String text = textNode.getText();
        String pattern = this.search.getText();
        if (!this.caseSensitive.isSelected()) {
            text = text.toLowerCase();
            pattern = pattern.toLowerCase();
        }
        int end = text.indexOf(pattern, this.currentIndex);
        AttributedCharacterIterator aci = textNode.getAttributedCharacterIterator();
        aci.first();
        for (int i2 = 0; i2 < end; ++i2) {
            aci.next();
        }
        Mark startMark = textNode.getMarkerForChar(aci.getIndex(), true);
        for (int i3 = 0; i3 < pattern.length() - 1; ++i3) {
            aci.next();
        }
        Mark endMark = textNode.getMarkerForChar(aci.getIndex(), false);
        this.svgCanvas.select(startMark, endMark);
        if (this.highlightButton.isSelected()) {
            return;
        }
        Shape s2 = textNode.getHighlightShape();
        AffineTransform at = this.highlightCenterZoomButton.isSelected() ? this.svgCanvas.getInitialTransform() : this.svgCanvas.getRenderingTransform();
        Rectangle gnb = at.createTransformedShape(s2).getBounds();
        Dimension canvasSize = this.svgCanvas.getSize();
        AffineTransform Tx = AffineTransform.getTranslateInstance(-((RectangularShape)gnb).getX() - ((RectangularShape)gnb).getWidth() / 2.0, -((RectangularShape)gnb).getY() - ((RectangularShape)gnb).getHeight() / 2.0);
        if (this.highlightCenterZoomButton.isSelected() && (scale = Math.min(sx = (double)canvasSize.width / ((RectangularShape)gnb).getWidth(), sy = (double)canvasSize.height / ((RectangularShape)gnb).getHeight()) / 8.0) > 1.0) {
            Tx.preConcatenate(AffineTransform.getScaleInstance(scale, scale));
        }
        Tx.preConcatenate(AffineTransform.getTranslateInstance(canvasSize.width / 2, canvasSize.height / 2));
        AffineTransform newRT = new AffineTransform(at);
        newRT.preConcatenate(Tx);
        this.svgCanvas.setRenderingTransform(newRT);
    }

    @Override
    public Action getAction(String key) throws MissingListenerException {
        return (Action)this.listeners.get(key);
    }

    protected class CloseButtonAction
    extends AbstractAction {
        protected CloseButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            FindDialog.this.dispose();
        }
    }

    protected class ClearButtonAction
    extends AbstractAction {
        protected ClearButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            FindDialog.this.search.setText(null);
            FindDialog.this.walker = null;
        }
    }

    protected class FindButtonAction
    extends AbstractAction {
        protected FindButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            String text = FindDialog.this.search.getText();
            if (text == null || text.length() == 0) {
                return;
            }
            GraphicsNode gn = FindDialog.this.getNext(text);
            if (gn != null) {
                FindDialog.this.showSelectedGraphicsNode();
            } else {
                FindDialog.this.walker = null;
                JOptionPane.showMessageDialog(FindDialog.this, resources.getString("End.text"), resources.getString("End.title"), 1);
            }
        }
    }
}

