/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.dom.AnimationTarget;
import org.apache.batik.anim.values.AnimatableValue;

public class AnimatableIntegerValue
extends AnimatableValue {
    protected int value;

    protected AnimatableIntegerValue(AnimationTarget target) {
        super(target);
    }

    public AnimatableIntegerValue(AnimationTarget target, int v2) {
        super(target);
        this.value = v2;
    }

    @Override
    public AnimatableValue interpolate(AnimatableValue result, AnimatableValue to, float interpolation, AnimatableValue accumulation, int multiplier) {
        AnimatableIntegerValue res = result == null ? new AnimatableIntegerValue(this.target) : (AnimatableIntegerValue)result;
        int v2 = this.value;
        if (to != null) {
            AnimatableIntegerValue toInteger = (AnimatableIntegerValue)to;
            v2 = (int)((float)v2 + ((float)this.value + interpolation * (float)(toInteger.getValue() - this.value)));
        }
        if (accumulation != null) {
            AnimatableIntegerValue accInteger = (AnimatableIntegerValue)accumulation;
            v2 += multiplier * accInteger.getValue();
        }
        if (res.value != v2) {
            res.value = v2;
            res.hasChanged = true;
        }
        return res;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public boolean canPace() {
        return true;
    }

    @Override
    public float distanceTo(AnimatableValue other) {
        AnimatableIntegerValue o2 = (AnimatableIntegerValue)other;
        return Math.abs(this.value - o2.value);
    }

    @Override
    public AnimatableValue getZeroValue() {
        return new AnimatableIntegerValue(this.target, 0);
    }

    @Override
    public String getCssText() {
        return Integer.toString(this.value);
    }
}

