/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.dom;

import org.apache.batik.anim.dom.SVGOMElement;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.util.XBLConstants;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public abstract class XBLOMElement
extends SVGOMElement
implements XBLConstants {
    protected String prefix;

    protected XBLOMElement() {
    }

    protected XBLOMElement(String prefix, AbstractDocument owner) {
        this.ownerDocument = owner;
        this.setPrefix(prefix);
    }

    @Override
    public String getNodeName() {
        if (this.prefix == null || this.prefix.equals("")) {
            return this.getLocalName();
        }
        return this.prefix + ':' + this.getLocalName();
    }

    @Override
    public String getNamespaceURI() {
        return "http://www.w3.org/2004/xbl";
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{(int)this.getNodeType(), this.getNodeName()});
        }
        if (prefix != null && !prefix.equals("") && !DOMUtilities.isValidName(prefix)) {
            throw this.createDOMException((short)5, "prefix", new Object[]{(int)this.getNodeType(), this.getNodeName(), prefix});
        }
        this.prefix = prefix;
    }

    @Override
    protected Node export(Node n2, AbstractDocument d2) {
        super.export(n2, d2);
        XBLOMElement e2 = (XBLOMElement)n2;
        e2.prefix = this.prefix;
        return n2;
    }

    @Override
    protected Node deepExport(Node n2, AbstractDocument d2) {
        super.deepExport(n2, d2);
        XBLOMElement e2 = (XBLOMElement)n2;
        e2.prefix = this.prefix;
        return n2;
    }

    @Override
    protected Node copyInto(Node n2) {
        super.copyInto(n2);
        XBLOMElement e2 = (XBLOMElement)n2;
        e2.prefix = this.prefix;
        return n2;
    }

    @Override
    protected Node deepCopyInto(Node n2) {
        super.deepCopyInto(n2);
        XBLOMElement e2 = (XBLOMElement)n2;
        e2.prefix = this.prefix;
        return n2;
    }
}

