/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.misc;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.antlr.misc.IntSet;
import org.antlr.misc.Interval;
import org.antlr.misc.IntervalSet;
import org.antlr.tool.Grammar;

public class BitSet
implements IntSet,
Cloneable {
    protected static final int BITS = 64;
    protected static final int LOG_BITS = 6;
    protected static final int MOD_MASK = 63;
    protected long[] bits;

    public BitSet() {
        this(64);
    }

    public BitSet(long[] bits_) {
        this.bits = bits_;
    }

    public BitSet(int nbits) {
        this.bits = new long[(nbits - 1 >> 6) + 1];
    }

    public void add(int el) {
        int n2 = BitSet.wordNumber(el);
        if (n2 >= this.bits.length) {
            this.growToInclude(el);
        }
        int n3 = n2;
        this.bits[n3] = this.bits[n3] | BitSet.bitMask(el);
    }

    public void addAll(IntSet set) {
        if (set instanceof BitSet) {
            this.orInPlace((BitSet)set);
        } else if (set instanceof IntervalSet) {
            IntervalSet other = (IntervalSet)set;
            Iterator<Interval> iter = other.intervals.iterator();
            while (iter.hasNext()) {
                Interval I2 = iter.next();
                this.orInPlace(BitSet.range(I2.a, I2.b));
            }
        } else {
            throw new IllegalArgumentException("can't add " + set.getClass().getName() + " to BitSet");
        }
    }

    public void addAll(int[] elements) {
        if (elements == null) {
            return;
        }
        for (int i2 = 0; i2 < elements.length; ++i2) {
            int e2 = elements[i2];
            this.add(e2);
        }
    }

    public void addAll(Iterable elements) {
        if (elements == null) {
            return;
        }
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            Object o2 = it.next();
            if (!(o2 instanceof Integer)) {
                throw new IllegalArgumentException();
            }
            Integer eI = (Integer)o2;
            this.add(eI);
        }
    }

    public IntSet and(IntSet a2) {
        BitSet s2 = (BitSet)this.clone();
        s2.andInPlace((BitSet)a2);
        return s2;
    }

    public void andInPlace(BitSet a2) {
        int i2;
        int min = Math.min(this.bits.length, a2.bits.length);
        for (i2 = min - 1; i2 >= 0; --i2) {
            int n2 = i2;
            this.bits[n2] = this.bits[n2] & a2.bits[i2];
        }
        for (i2 = min; i2 < this.bits.length; ++i2) {
            this.bits[i2] = 0L;
        }
    }

    private static final long bitMask(int bitNumber) {
        int bitPosition = bitNumber & 0x3F;
        return 1L << bitPosition;
    }

    public void clear() {
        for (int i2 = this.bits.length - 1; i2 >= 0; --i2) {
            this.bits[i2] = 0L;
        }
    }

    public void clear(int el) {
        int n2 = BitSet.wordNumber(el);
        if (n2 >= this.bits.length) {
            this.growToInclude(el);
        }
        int n3 = n2;
        this.bits[n3] = this.bits[n3] & (BitSet.bitMask(el) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public Object clone() {
        BitSet s2;
        try {
            s2 = (BitSet)super.clone();
            s2.bits = new long[this.bits.length];
            System.arraycopy(this.bits, 0, s2.bits, 0, this.bits.length);
        }
        catch (CloneNotSupportedException e2) {
            throw new InternalError();
        }
        return s2;
    }

    public int size() {
        int deg = 0;
        for (int i2 = this.bits.length - 1; i2 >= 0; --i2) {
            long word = this.bits[i2];
            if (word == 0L) continue;
            for (int bit = 63; bit >= 0; --bit) {
                if ((word & 1L << bit) == 0L) continue;
                ++deg;
            }
        }
        return deg;
    }

    public boolean equals(Object other) {
        block5: {
            int i2;
            int n2;
            BitSet otherSet;
            block4: {
                if (other == null || !(other instanceof BitSet)) {
                    return false;
                }
                otherSet = (BitSet)other;
                n2 = Math.min(this.bits.length, otherSet.bits.length);
                for (i2 = 0; i2 < n2; ++i2) {
                    if (this.bits[i2] == otherSet.bits[i2]) continue;
                    return false;
                }
                if (this.bits.length <= n2) break block4;
                for (i2 = n2 + 1; i2 < this.bits.length; ++i2) {
                    if (this.bits[i2] == 0L) continue;
                    return false;
                }
                break block5;
            }
            if (otherSet.bits.length <= n2) break block5;
            for (i2 = n2 + 1; i2 < otherSet.bits.length; ++i2) {
                if (otherSet.bits[i2] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public void growToInclude(int bit) {
        int newSize = Math.max(this.bits.length << 1, this.numWordsToHold(bit));
        long[] newbits = new long[newSize];
        System.arraycopy(this.bits, 0, newbits, 0, this.bits.length);
        this.bits = newbits;
    }

    public boolean member(int el) {
        int n2 = BitSet.wordNumber(el);
        if (n2 >= this.bits.length) {
            return false;
        }
        return (this.bits[n2] & BitSet.bitMask(el)) != 0L;
    }

    public int getSingleElement() {
        for (int i2 = 0; i2 < this.bits.length << 6; ++i2) {
            if (!this.member(i2)) continue;
            return i2;
        }
        return -7;
    }

    public boolean isNil() {
        for (int i2 = this.bits.length - 1; i2 >= 0; --i2) {
            if (this.bits[i2] == 0L) continue;
            return false;
        }
        return true;
    }

    public IntSet complement() {
        BitSet s2 = (BitSet)this.clone();
        s2.notInPlace();
        return s2;
    }

    public IntSet complement(IntSet set) {
        if (set == null) {
            return this.complement();
        }
        return set.subtract(this);
    }

    public void notInPlace() {
        for (int i2 = this.bits.length - 1; i2 >= 0; --i2) {
            this.bits[i2] = this.bits[i2] ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public void notInPlace(int maxBit) {
        this.notInPlace(0, maxBit);
    }

    public void notInPlace(int minBit, int maxBit) {
        this.growToInclude(maxBit);
        for (int i2 = minBit; i2 <= maxBit; ++i2) {
            int n2;
            int n3 = n2 = BitSet.wordNumber(i2);
            this.bits[n3] = this.bits[n3] ^ BitSet.bitMask(i2);
        }
    }

    private final int numWordsToHold(int el) {
        return (el >> 6) + 1;
    }

    public static BitSet of(int el) {
        BitSet s2 = new BitSet(el + 1);
        s2.add(el);
        return s2;
    }

    public static BitSet of(Collection elements) {
        BitSet s2 = new BitSet();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Integer el = (Integer)iter.next();
            s2.add(el);
        }
        return s2;
    }

    public static BitSet of(IntSet set) {
        if (set == null) {
            return null;
        }
        if (set instanceof BitSet) {
            return (BitSet)set;
        }
        if (set instanceof IntervalSet) {
            BitSet s2 = new BitSet();
            s2.addAll(set);
            return s2;
        }
        throw new IllegalArgumentException("can't create BitSet from " + set.getClass().getName());
    }

    public static BitSet of(Map elements) {
        return BitSet.of(elements.keySet());
    }

    public static BitSet range(int a2, int b2) {
        BitSet s2 = new BitSet(b2 + 1);
        for (int i2 = a2; i2 <= b2; ++i2) {
            int n2;
            int n3 = n2 = BitSet.wordNumber(i2);
            s2.bits[n3] = s2.bits[n3] | BitSet.bitMask(i2);
        }
        return s2;
    }

    public IntSet or(IntSet a2) {
        if (a2 == null) {
            return this;
        }
        BitSet s2 = (BitSet)this.clone();
        s2.orInPlace((BitSet)a2);
        return s2;
    }

    public void orInPlace(BitSet a2) {
        if (a2 == null) {
            return;
        }
        if (a2.bits.length > this.bits.length) {
            this.setSize(a2.bits.length);
        }
        int min = Math.min(this.bits.length, a2.bits.length);
        for (int i2 = min - 1; i2 >= 0; --i2) {
            int n2 = i2;
            this.bits[n2] = this.bits[n2] | a2.bits[i2];
        }
    }

    public void remove(int el) {
        int n2 = BitSet.wordNumber(el);
        if (n2 >= this.bits.length) {
            this.growToInclude(el);
        }
        int n3 = n2;
        this.bits[n3] = this.bits[n3] & (BitSet.bitMask(el) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private void setSize(int nwords) {
        long[] newbits = new long[nwords];
        int n2 = Math.min(nwords, this.bits.length);
        System.arraycopy(this.bits, 0, newbits, 0, n2);
        this.bits = newbits;
    }

    public int numBits() {
        return this.bits.length << 6;
    }

    public int lengthInLongWords() {
        return this.bits.length;
    }

    public boolean subset(BitSet a2) {
        if (a2 == null) {
            return false;
        }
        return ((Object)this.and(a2)).equals(this);
    }

    public void subtractInPlace(BitSet a2) {
        if (a2 == null) {
            return;
        }
        for (int i2 = 0; i2 < this.bits.length && i2 < a2.bits.length; ++i2) {
            int n2 = i2;
            this.bits[n2] = this.bits[n2] & (a2.bits[i2] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public IntSet subtract(IntSet a2) {
        if (a2 == null || !(a2 instanceof BitSet)) {
            return null;
        }
        BitSet s2 = (BitSet)this.clone();
        s2.subtractInPlace((BitSet)a2);
        return s2;
    }

    public List toList() {
        throw new NoSuchMethodError("BitSet.toList() unimplemented");
    }

    public int[] toArray() {
        int[] elems = new int[this.size()];
        int en = 0;
        for (int i2 = 0; i2 < this.bits.length << 6; ++i2) {
            if (!this.member(i2)) continue;
            elems[en++] = i2;
        }
        return elems;
    }

    public long[] toPackedArray() {
        return this.bits;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Grammar g2) {
        StringBuffer buf = new StringBuffer();
        String separator = ",";
        boolean havePrintedAnElement = false;
        buf.append('{');
        for (int i2 = 0; i2 < this.bits.length << 6; ++i2) {
            if (!this.member(i2)) continue;
            if (i2 > 0 && havePrintedAnElement) {
                buf.append(separator);
            }
            if (g2 != null) {
                buf.append(g2.getTokenDisplayName(i2));
            } else {
                buf.append(i2);
            }
            havePrintedAnElement = true;
        }
        buf.append('}');
        return buf.toString();
    }

    public String toString(String separator, List vocabulary) {
        if (vocabulary == null) {
            return this.toString(null);
        }
        String str = "";
        for (int i2 = 0; i2 < this.bits.length << 6; ++i2) {
            if (!this.member(i2)) continue;
            if (str.length() > 0) {
                str = str + separator;
            }
            str = i2 >= vocabulary.size() ? str + "'" + (char)i2 + "'" : (vocabulary.get(i2) == null ? str + "'" + (char)i2 + "'" : str + (String)vocabulary.get(i2));
        }
        return str;
    }

    public String toStringOfHalfWords() {
        StringBuffer s2 = new StringBuffer();
        for (int i2 = 0; i2 < this.bits.length; ++i2) {
            if (i2 != 0) {
                s2.append(", ");
            }
            long tmp = this.bits[i2];
            s2.append(tmp &= 0xFFFFFFFFL);
            s2.append("UL");
            s2.append(", ");
            tmp = this.bits[i2] >>> 32;
            s2.append(tmp &= 0xFFFFFFFFL);
            s2.append("UL");
        }
        return s2.toString();
    }

    public String toStringOfWords() {
        StringBuffer s2 = new StringBuffer();
        for (int i2 = 0; i2 < this.bits.length; ++i2) {
            if (i2 != 0) {
                s2.append(", ");
            }
            s2.append(this.bits[i2]);
            s2.append("L");
        }
        return s2.toString();
    }

    public String toStringWithRanges() {
        return this.toString();
    }

    private static final int wordNumber(int bit) {
        return bit >> 6;
    }
}

