/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.codegen;

import java.util.List;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.Transition;
import org.antlr.codegen.CodeGenerator;
import org.antlr.misc.Utils;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;

public class ACyclicDFACodeGenerator {
    protected CodeGenerator parentGenerator;

    public ACyclicDFACodeGenerator(CodeGenerator parent) {
        this.parentGenerator = parent;
    }

    public ST genFixedLookaheadDecision(STGroup templates, DFA dfa) {
        return this.walkFixedDFAGeneratingStateMachine(templates, dfa, dfa.startState, 1);
    }

    protected ST walkFixedDFAGeneratingStateMachine(STGroup templates, DFA dfa, DFAState s2, int k2) {
        ST targetST;
        ST edgeST;
        int i2;
        if (s2.isAcceptState()) {
            ST dfaST = templates.getInstanceOf("dfaAcceptState");
            dfaST.add("alt", Utils.integer(s2.getUniquelyPredictedAlt()));
            return dfaST;
        }
        String dfaStateName = "dfaState";
        String dfaLoopbackStateName = "dfaLoopbackState";
        String dfaOptionalBlockStateName = "dfaOptionalBlockState";
        String dfaEdgeName = "dfaEdge";
        if (this.parentGenerator.canGenerateSwitch(s2)) {
            dfaStateName = "dfaStateSwitch";
            dfaLoopbackStateName = "dfaLoopbackStateSwitch";
            dfaOptionalBlockStateName = "dfaOptionalBlockStateSwitch";
            dfaEdgeName = "dfaEdgeSwitch";
        }
        ST dfaST = templates.getInstanceOf(dfaStateName);
        if (dfa.getNFADecisionStartState().decisionStateType == 1) {
            dfaST = templates.getInstanceOf(dfaLoopbackStateName);
        } else if (dfa.getNFADecisionStartState().decisionStateType == 3) {
            dfaST = templates.getInstanceOf(dfaOptionalBlockStateName);
        }
        dfaST.add("k", Utils.integer(k2));
        dfaST.add("stateNumber", Utils.integer(s2.stateNumber));
        dfaST.add("semPredState", s2.isResolvedWithPredicates());
        int EOTPredicts = -1;
        DFAState EOTTarget = null;
        for (i2 = 0; i2 < s2.getNumberOfTransitions(); ++i2) {
            DFAState target;
            SemanticContext preds;
            Transition edge = s2.transition(i2);
            if (edge.label.getAtom() == -2) {
                EOTTarget = (DFAState)edge.target;
                EOTPredicts = EOTTarget.getUniquelyPredictedAlt();
                continue;
            }
            edgeST = templates.getInstanceOf(dfaEdgeName);
            if (edgeST.impl.formalArguments.get("labels") != null) {
                List labels = edge.label.getSet().toList();
                for (int j2 = 0; j2 < labels.size(); ++j2) {
                    Integer vI = (Integer)labels.get(j2);
                    String label = this.parentGenerator.getTokenTypeAsTargetLabel(vI);
                    labels.set(j2, label);
                }
                edgeST.add("labels", labels);
            } else {
                edgeST.add("labelExpr", this.parentGenerator.genLabelExpr(templates, edge, k2));
            }
            if (!edge.label.isSemanticPredicate() && (preds = (target = (DFAState)edge.target).getGatedPredicatesInNFAConfigurations()) != null) {
                ST predST = preds.genExpr(this.parentGenerator, this.parentGenerator.getTemplates(), dfa);
                edgeST.add("predicates", predST);
            }
            targetST = this.walkFixedDFAGeneratingStateMachine(templates, dfa, (DFAState)edge.target, k2 + 1);
            edgeST.add("targetState", targetST);
            dfaST.add("edges", edgeST);
        }
        if (EOTPredicts != -1) {
            dfaST.add("eotPredictsAlt", Utils.integer(EOTPredicts));
        } else if (EOTTarget != null && EOTTarget.getNumberOfTransitions() > 0) {
            for (i2 = 0; i2 < EOTTarget.getNumberOfTransitions(); ++i2) {
                Transition predEdge = EOTTarget.transition(i2);
                edgeST = templates.getInstanceOf(dfaEdgeName);
                edgeST.add("labelExpr", this.parentGenerator.genSemanticPredicateExpr(templates, predEdge));
                targetST = this.walkFixedDFAGeneratingStateMachine(templates, dfa, (DFAState)predEdge.target, k2 + 1);
                edgeST.add("targetState", targetST);
                dfaST.add("edges", edgeST);
            }
        }
        return dfaST;
    }
}

