/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DFAOptimizer;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.Label;
import org.antlr.analysis.NFAConfiguration;
import org.antlr.analysis.NFAContext;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.NonLLStarDecisionException;
import org.antlr.analysis.PredicateLabel;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.Transition;
import org.antlr.misc.BitSet;
import org.antlr.misc.OrderedHashSet;
import org.antlr.misc.Utils;
import org.antlr.runtime.Token;
import org.antlr.tool.ErrorManager;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NFAToDFAConverter {
    protected List work = new LinkedList();
    protected NFAContext[] contextTrees;
    protected DFA dfa;
    public static boolean debug = false;
    public static boolean SINGLE_THREADED_NFA_CONVERSION = true;
    protected boolean computingStartState = false;

    public NFAToDFAConverter(DFA dfa) {
        this.dfa = dfa;
        int nAlts = dfa.getNumberOfAlts();
        this.initContextTrees(nAlts);
    }

    public void convert() {
        this.dfa.startState = this.computeStartState();
        while (this.work.size() > 0 && !this.dfa.nfa.grammar.NFAToDFAConversionExternallyAborted()) {
            int k2;
            DFAState d2 = (DFAState)this.work.get(0);
            if (this.dfa.nfa.grammar.composite.watchNFAConversion) {
                System.out.println(new StringBuffer().append("convert DFA state ").append(d2.stateNumber).append(" (").append(d2.nfaConfigurations.size()).append(" nfa states)").toString());
            }
            if ((k2 = this.dfa.getUserMaxLookahead()) > 0 && k2 == d2.getLookaheadDepth()) {
                this.resolveNonDeterminisms(d2);
                if (d2.isResolvedWithPredicates()) {
                    this.addPredicateTransitions(d2);
                } else {
                    d2.setAcceptState(true);
                }
            } else {
                this.findNewDFAStatesAndAddDFATransitions(d2);
            }
            this.work.remove(0);
        }
        this.dfa.findAllGatedSynPredsUsedInDFAAcceptStates();
    }

    protected DFAState computeStartState() {
        NFAState alt = this.dfa.decisionNFAStartState;
        DFAState startState = this.dfa.newState();
        this.computingStartState = true;
        int i2 = 0;
        int altNum = 1;
        while (alt != null) {
            NFAContext initialContext = this.contextTrees[i2];
            if (i2 == 0 && this.dfa.getNFADecisionStartState().decisionStateType == 1) {
                int numAltsIncludingExitBranch;
                altNum = numAltsIncludingExitBranch = this.dfa.nfa.grammar.getNumberOfAltsForDecisionNFA(this.dfa.decisionNFAStartState);
                this.closure((NFAState)alt.transition[0].target, altNum, initialContext, SemanticContext.EMPTY_SEMANTIC_CONTEXT, startState, true);
                altNum = 1;
            } else {
                this.closure((NFAState)alt.transition[0].target, altNum, initialContext, SemanticContext.EMPTY_SEMANTIC_CONTEXT, startState, true);
                ++altNum;
            }
            ++i2;
            if (alt.transition[1] == null) break;
            alt = (NFAState)alt.transition[1].target;
        }
        this.dfa.addState(startState);
        this.work.add(startState);
        this.computingStartState = false;
        return startState;
    }

    protected void findNewDFAStatesAndAddDFATransitions(DFAState d2) {
        boolean containsEOT;
        OrderedHashSet labels = d2.getReachableLabels();
        Label EOTLabel = new Label(-2);
        boolean bl = containsEOT = labels != null && labels.contains(EOTLabel);
        if (!this.dfa.isGreedy() && containsEOT) {
            this.convertToEOTAcceptState(d2);
            return;
        }
        int numberOfEdgesEmanating = 0;
        HashMap targetToLabelMap = new HashMap();
        int numLabels = 0;
        if (labels != null) {
            numLabels = labels.size();
        }
        for (int i2 = 0; i2 < numLabels; ++i2) {
            Label label = (Label)labels.get(i2);
            DFAState t2 = this.reach(d2, label);
            if (debug) {
                System.out.println(new StringBuffer().append("DFA state after reach ").append(label).append(" ").append(d2).append("-").append(label.toString(this.dfa.nfa.grammar)).append("->").append(t2).toString());
            }
            if (t2 == null) continue;
            if (t2.getUniqueAlt() == -1) {
                this.closure(t2);
            }
            DFAState targetState = this.addDFAStateToWorkList(t2);
            numberOfEdgesEmanating += NFAToDFAConverter.addTransition(d2, label, targetState, targetToLabelMap);
            targetState.setLookaheadDepth(d2.getLookaheadDepth() + 1);
        }
        if (!d2.isResolvedWithPredicates() && numberOfEdgesEmanating == 0) {
            this.dfa.probe.reportDanglingState(d2);
            int minAlt = this.resolveByPickingMinAlt(d2, null);
            d2.setAcceptState(true);
            this.dfa.setAcceptState(minAlt, d2);
        }
        if (d2.isResolvedWithPredicates()) {
            this.addPredicateTransitions(d2);
        }
    }

    protected static int addTransition(DFAState d2, Label label, DFAState targetState, Map targetToLabelMap) {
        int n2 = 0;
        if (DFAOptimizer.COLLAPSE_ALL_PARALLEL_EDGES) {
            Integer tI = Utils.integer(targetState.stateNumber);
            Transition oldTransition = (Transition)targetToLabelMap.get(tI);
            if (oldTransition != null) {
                if (label.getAtom() == -2) {
                    oldTransition.label = new Label(-2);
                } else if (oldTransition.label.getAtom() != -2) {
                    oldTransition.label.add(label);
                }
            } else {
                n2 = 1;
                label = (Label)label.clone();
                int transitionIndex = d2.addTransition(targetState, label);
                Transition trans = d2.getTransition(transitionIndex);
                targetToLabelMap.put(tI, trans);
            }
        } else {
            n2 = 1;
            d2.addTransition(targetState, label);
        }
        return n2;
    }

    public void closure(DFAState d2) {
        if (debug) {
            System.out.println(new StringBuffer().append("closure(").append(d2).append(")").toString());
        }
        ArrayList<NFAConfiguration> configs = new ArrayList<NFAConfiguration>();
        configs.addAll(d2.nfaConfigurations);
        int numConfigs = configs.size();
        for (int i2 = 0; i2 < numConfigs; ++i2) {
            NFAConfiguration c2 = (NFAConfiguration)configs.get(i2);
            if (c2.singleAtomTransitionEmanating) continue;
            this.closure(this.dfa.nfa.getState(c2.state), c2.alt, c2.context, c2.semanticContext, d2, false);
        }
        d2.closureBusy = null;
    }

    public void closure(NFAState p2, int alt, NFAContext context, SemanticContext semanticContext, DFAState d2, boolean collectPredicates) {
        NFAConfiguration proposedNFAConfiguration;
        if (debug) {
            System.out.println(new StringBuffer().append("closure at ").append(p2.enclosingRule.name).append(" state ").append(p2.stateNumber).append("|").append(alt).append(" filling DFA state ").append(d2.stateNumber).append(" with context ").append(context).toString());
        }
        if (NFAToDFAConverter.closureIsBusy(d2, proposedNFAConfiguration = new NFAConfiguration(p2.stateNumber, alt, context, semanticContext))) {
            if (debug) {
                System.out.println(new StringBuffer().append("avoid visiting exact closure computation NFA config: ").append(proposedNFAConfiguration).append(" in ").append(p2.enclosingRule.name).toString());
                System.out.println(new StringBuffer().append("state is ").append(d2.dfa.decisionNumber).append(".").append(d2.stateNumber).toString());
            }
            return;
        }
        d2.closureBusy.add(proposedNFAConfiguration);
        d2.addNFAConfiguration(p2, proposedNFAConfiguration);
        Transition transition0 = p2.transition[0];
        if (transition0 instanceof RuleClosureTransition) {
            int depth = context.recursionDepthEmanatingFromState(p2.stateNumber);
            if (depth == 1 && d2.dfa.getUserMaxLookahead() == 0) {
                d2.dfa.recursiveAltSet.add(alt);
                if (d2.dfa.recursiveAltSet.size() > 1) {
                    d2.abortedDueToMultipleRecursiveAlts = true;
                    throw new NonLLStarDecisionException(d2.dfa);
                }
            }
            if (depth >= NFAContext.MAX_SAME_RULE_INVOCATIONS_PER_NFA_CONFIG_STACK) {
                d2.abortedDueToRecursionOverflow = true;
                d2.dfa.probe.reportRecursionOverflow(d2, proposedNFAConfiguration);
                if (debug) {
                    System.out.println(new StringBuffer().append("analysis overflow in closure(").append(d2.stateNumber).append(")").toString());
                }
                return;
            }
            RuleClosureTransition ref = (RuleClosureTransition)transition0;
            NFAContext newContext = new NFAContext(context, p2);
            NFAState ruleTarget = (NFAState)ref.target;
            this.closure(ruleTarget, alt, newContext, semanticContext, d2, collectPredicates);
        } else if (p2.isAcceptState() && context.parent != null) {
            NFAState whichStateInvokedRule = context.invokingState;
            RuleClosureTransition edgeToRule = (RuleClosureTransition)whichStateInvokedRule.transition[0];
            NFAState continueState = edgeToRule.followState;
            NFAContext newContext = context.parent;
            this.closure(continueState, alt, newContext, semanticContext, d2, collectPredicates);
        } else {
            if (transition0 != null && transition0.isEpsilon()) {
                boolean collectPredicatesAfterAction = collectPredicates;
                if (transition0.isAction() && collectPredicates) {
                    collectPredicatesAfterAction = false;
                }
                this.closure((NFAState)transition0.target, alt, context, semanticContext, d2, collectPredicatesAfterAction);
            } else if (transition0 != null && transition0.isSemanticPredicate()) {
                SemanticContext labelContext = transition0.label.getSemanticContext();
                if (this.computingStartState) {
                    if (collectPredicates) {
                        this.dfa.predicateVisible = true;
                    } else {
                        this.dfa.hasPredicateBlockedByAction = true;
                    }
                }
                SemanticContext newSemanticContext = semanticContext;
                if (collectPredicates) {
                    int walkAlt = this.dfa.decisionNFAStartState.translateDisplayAltToWalkAlt(alt);
                    NFAState altLeftEdge = this.dfa.nfa.grammar.getNFAStateForAltOfDecision(this.dfa.decisionNFAStartState, walkAlt);
                    if (!labelContext.isSyntacticPredicate() || p2 == altLeftEdge.transition[0].target) {
                        newSemanticContext = SemanticContext.and(semanticContext, labelContext);
                    }
                }
                this.closure((NFAState)transition0.target, alt, context, newSemanticContext, d2, collectPredicates);
            }
            Transition transition1 = p2.transition[1];
            if (transition1 != null && transition1.isEpsilon()) {
                this.closure((NFAState)transition1.target, alt, context, semanticContext, d2, collectPredicates);
            }
        }
    }

    public static boolean closureIsBusy(DFAState d2, NFAConfiguration proposedNFAConfiguration) {
        return d2.closureBusy.contains(proposedNFAConfiguration);
    }

    public DFAState reach(DFAState d2, Label label) {
        DFAState labelDFATarget = this.dfa.newState();
        List<NFAConfiguration> configs = d2.configurationsWithLabeledEdges;
        int numConfigs = configs.size();
        for (int i2 = 0; i2 < numConfigs; ++i2) {
            NFAConfiguration c2 = configs.get(i2);
            if (c2.resolved || c2.resolveWithPredicate) continue;
            NFAState p2 = this.dfa.nfa.getState(c2.state);
            Transition edge = p2.transition[0];
            if (edge == null || !c2.singleAtomTransitionEmanating) continue;
            Label edgeLabel = edge.label;
            if (c2.context.parent != null && edgeLabel.label == -2 || !Label.intersect(label, edgeLabel)) continue;
            NFAConfiguration newC = labelDFATarget.addNFAConfiguration((NFAState)edge.target, c2.alt, c2.context, c2.semanticContext);
        }
        if (labelDFATarget.nfaConfigurations.size() == 0) {
            this.dfa.setState(labelDFATarget.stateNumber, null);
            labelDFATarget = null;
        }
        return labelDFATarget;
    }

    protected void convertToEOTAcceptState(DFAState d2) {
        Label eot = new Label(-2);
        int numConfigs = d2.nfaConfigurations.size();
        for (int i2 = 0; i2 < numConfigs; ++i2) {
            NFAConfiguration c2 = d2.nfaConfigurations.get(i2);
            if (c2.resolved || c2.resolveWithPredicate) continue;
            NFAState p2 = this.dfa.nfa.getState(c2.state);
            Transition edge = p2.transition[0];
            Label edgeLabel = edge.label;
            if (!edgeLabel.equals(eot)) continue;
            d2.setAcceptState(true);
            d2.nfaConfigurations.clear();
            d2.addNFAConfiguration(p2, c2.alt, c2.context, c2.semanticContext);
            return;
        }
    }

    protected DFAState addDFAStateToWorkList(DFAState d2) {
        DFAState existingState = this.dfa.addState(d2);
        if (d2 != existingState) {
            this.dfa.setState(d2.stateNumber, existingState);
            return existingState;
        }
        this.resolveNonDeterminisms(d2);
        int alt = d2.getUniquelyPredictedAlt();
        if (alt != -1) {
            d2 = this.convertToAcceptState(d2, alt);
        } else {
            this.work.add(d2);
        }
        return d2;
    }

    protected DFAState convertToAcceptState(DFAState d2, int alt) {
        DFAState acceptStateForAlt;
        if (DFAOptimizer.MERGE_STOP_STATES && d2.getNonDeterministicAlts() == null && !d2.abortedDueToRecursionOverflow && !d2.abortedDueToMultipleRecursiveAlts && (acceptStateForAlt = this.dfa.getAcceptState(alt)) != null) {
            SemanticContext gatedPreds = d2.getGatedPredicatesInNFAConfigurations();
            SemanticContext existingStateGatedPreds = acceptStateForAlt.getGatedPredicatesInNFAConfigurations();
            if (gatedPreds == null && existingStateGatedPreds == null || gatedPreds != null && existingStateGatedPreds != null && gatedPreds.equals(existingStateGatedPreds)) {
                this.dfa.setState(d2.stateNumber, acceptStateForAlt);
                this.dfa.removeState(d2);
                d2 = acceptStateForAlt;
                return d2;
            }
        }
        d2.setAcceptState(true);
        this.dfa.setAcceptState(alt, d2);
        return d2;
    }

    public void resolveNonDeterminisms(DFAState d2) {
        boolean resolved;
        Set allAlts;
        if (debug) {
            System.out.println(new StringBuffer().append("resolveNonDeterminisms ").append(d2.toString()).toString());
        }
        boolean conflictingLexerRules = false;
        Set nondeterministicAlts = d2.getNonDeterministicAlts();
        if (debug && nondeterministicAlts != null) {
            System.out.println(new StringBuffer().append("nondet alts=").append(nondeterministicAlts).toString());
        }
        NFAConfiguration anyConfig = d2.nfaConfigurations.get(0);
        NFAState anyState = this.dfa.nfa.getState(anyConfig.state);
        if (anyState.isEOTTargetState() && (allAlts = d2.getAltSet()) != null && allAlts.size() > 1) {
            nondeterministicAlts = allAlts;
            if (d2.dfa.isTokensRuleDecision()) {
                this.dfa.probe.reportLexerRuleNondeterminism(d2, allAlts);
                conflictingLexerRules = true;
            }
        }
        if (!d2.abortedDueToRecursionOverflow && nondeterministicAlts == null) {
            return;
        }
        if (!d2.abortedDueToRecursionOverflow && !conflictingLexerRules) {
            this.dfa.probe.reportNondeterminism(d2, nondeterministicAlts);
        }
        if (resolved = this.tryToResolveWithSemanticPredicates(d2, nondeterministicAlts)) {
            if (debug) {
                System.out.println(new StringBuffer().append("resolved DFA state ").append(d2.stateNumber).append(" with pred").toString());
            }
            d2.resolvedWithPredicates = true;
            this.dfa.probe.reportNondeterminismResolvedWithSemanticPredicate(d2);
            return;
        }
        this.resolveByChoosingFirstAlt(d2, nondeterministicAlts);
    }

    protected int resolveByChoosingFirstAlt(DFAState d2, Set nondeterministicAlts) {
        int exitAlt;
        int winningAlt = 0;
        winningAlt = this.dfa.isGreedy() ? this.resolveByPickingMinAlt(d2, nondeterministicAlts) : (nondeterministicAlts.contains(Utils.integer(exitAlt = this.dfa.getNumberOfAlts())) ? this.resolveByPickingExitAlt(d2, nondeterministicAlts) : this.resolveByPickingMinAlt(d2, nondeterministicAlts));
        return winningAlt;
    }

    protected int resolveByPickingMinAlt(DFAState d2, Set nondeterministicAlts) {
        int min = Integer.MAX_VALUE;
        min = nondeterministicAlts != null ? NFAToDFAConverter.getMinAlt(nondeterministicAlts) : d2.minAltInConfigurations;
        NFAToDFAConverter.turnOffOtherAlts(d2, min, nondeterministicAlts);
        return min;
    }

    protected int resolveByPickingExitAlt(DFAState d2, Set nondeterministicAlts) {
        int exitAlt = this.dfa.getNumberOfAlts();
        NFAToDFAConverter.turnOffOtherAlts(d2, exitAlt, nondeterministicAlts);
        return exitAlt;
    }

    protected static void turnOffOtherAlts(DFAState d2, int min, Set<Integer> nondeterministicAlts) {
        int numConfigs = d2.nfaConfigurations.size();
        for (int i2 = 0; i2 < numConfigs; ++i2) {
            NFAConfiguration configuration = d2.nfaConfigurations.get(i2);
            if (configuration.alt == min || nondeterministicAlts != null && !nondeterministicAlts.contains(Utils.integer(configuration.alt))) continue;
            configuration.resolved = true;
        }
    }

    protected static int getMinAlt(Set<Integer> nondeterministicAlts) {
        int min = Integer.MAX_VALUE;
        for (Integer altI : nondeterministicAlts) {
            int alt = altI;
            if (alt >= min) continue;
            min = alt;
        }
        return min;
    }

    protected boolean tryToResolveWithSemanticPredicates(DFAState d2, Set nondeterministicAlts) {
        Map<Integer, SemanticContext> altToPredMap = this.getPredicatesPerNonDeterministicAlt(d2, nondeterministicAlts);
        if (altToPredMap.size() == 0) {
            return false;
        }
        this.dfa.probe.reportAltPredicateContext(d2, altToPredMap);
        if (nondeterministicAlts.size() - altToPredMap.size() > 1) {
            return false;
        }
        if (altToPredMap.size() == nondeterministicAlts.size() - 1) {
            SemanticContext unionOfPredicatesFromAllAlts;
            BitSet ndSet = BitSet.of(nondeterministicAlts);
            BitSet predSet = BitSet.of(altToPredMap);
            int nakedAlt = ndSet.subtract(predSet).getSingleElement();
            SemanticContext nakedAltPred = null;
            nakedAltPred = nakedAlt == NFAToDFAConverter.max(nondeterministicAlts) ? new SemanticContext.TruePredicate() : ((unionOfPredicatesFromAllAlts = NFAToDFAConverter.getUnionOfPredicates(altToPredMap)).isSyntacticPredicate() ? new SemanticContext.TruePredicate() : SemanticContext.not(unionOfPredicatesFromAllAlts));
            altToPredMap.put(Utils.integer(nakedAlt), nakedAltPred);
            int numConfigs = d2.nfaConfigurations.size();
            for (int i2 = 0; i2 < numConfigs; ++i2) {
                NFAConfiguration configuration = d2.nfaConfigurations.get(i2);
                if (configuration.alt != nakedAlt) continue;
                configuration.semanticContext = nakedAltPred;
            }
        }
        if (altToPredMap.size() == nondeterministicAlts.size()) {
            if (d2.abortedDueToRecursionOverflow) {
                d2.dfa.probe.removeRecursiveOverflowState(d2);
            }
            int numConfigs = d2.nfaConfigurations.size();
            for (int i3 = 0; i3 < numConfigs; ++i3) {
                NFAConfiguration configuration = d2.nfaConfigurations.get(i3);
                SemanticContext semCtx = altToPredMap.get(Utils.integer(configuration.alt));
                if (semCtx != null) {
                    configuration.resolveWithPredicate = true;
                    configuration.semanticContext = semCtx;
                    altToPredMap.remove(Utils.integer(configuration.alt));
                    if (!semCtx.isSyntacticPredicate()) continue;
                    this.dfa.nfa.grammar.synPredUsedInDFA(this.dfa, semCtx);
                    continue;
                }
                if (!nondeterministicAlts.contains(Utils.integer(configuration.alt))) continue;
                configuration.resolved = true;
            }
            return true;
        }
        return false;
    }

    protected Map<Integer, SemanticContext> getPredicatesPerNonDeterministicAlt(DFAState d2, Set nondeterministicAlts) {
        HashMap<Integer, SemanticContext> altToPredicateContextMap = new HashMap<Integer, SemanticContext>();
        HashMap altToSetOfContextsMap = new HashMap();
        for (Integer altI : nondeterministicAlts) {
            altToSetOfContextsMap.put(altI, new OrderedHashSet());
        }
        HashMap<Integer, Set<Token>> altToLocationsReachableWithoutPredicate = new HashMap<Integer, Set<Token>>();
        HashSet<Integer> nondetAltsWithUncoveredConfiguration = new HashSet<Integer>();
        int numConfigs = d2.nfaConfigurations.size();
        for (int i2 = 0; i2 < numConfigs; ++i2) {
            NFAConfiguration configuration = d2.nfaConfigurations.get(i2);
            Integer altI = Utils.integer(configuration.alt);
            if (!nondeterministicAlts.contains(altI)) continue;
            if (configuration.semanticContext != SemanticContext.EMPTY_SEMANTIC_CONTEXT) {
                Set predSet = (Set)altToSetOfContextsMap.get(altI);
                predSet.add(configuration.semanticContext);
                continue;
            }
            nondetAltsWithUncoveredConfiguration.add(altI);
        }
        ArrayList<Integer> incompletelyCoveredAlts = new ArrayList<Integer>();
        for (Integer altI : nondeterministicAlts) {
            Set contextsForThisAlt = (Set)altToSetOfContextsMap.get(altI);
            if (nondetAltsWithUncoveredConfiguration.contains(altI)) {
                if (contextsForThisAlt.size() <= 0) continue;
                incompletelyCoveredAlts.add(altI);
                continue;
            }
            SemanticContext combinedContext = null;
            for (SemanticContext ctx : contextsForThisAlt) {
                combinedContext = SemanticContext.or(combinedContext, ctx);
            }
            altToPredicateContextMap.put(altI, combinedContext);
        }
        if (incompletelyCoveredAlts.size() > 0) {
            for (int i3 = 0; i3 < numConfigs; ++i3) {
                NFAConfiguration configuration = d2.nfaConfigurations.get(i3);
                Integer altI = Utils.integer(configuration.alt);
                if (!incompletelyCoveredAlts.contains(altI) || configuration.semanticContext != SemanticContext.EMPTY_SEMANTIC_CONTEXT) continue;
                NFAState s2 = this.dfa.nfa.getState(configuration.state);
                if (s2.incidentEdgeLabel == null || s2.incidentEdgeLabel.label == -1) continue;
                if (s2.associatedASTNode == null || s2.associatedASTNode.token == null) {
                    ErrorManager.internalError("no AST/token for nonepsilon target w/o predicate");
                    continue;
                }
                HashSet<Token> locations = (HashSet<Token>)altToLocationsReachableWithoutPredicate.get(altI);
                if (locations == null) {
                    locations = new HashSet<Token>();
                    altToLocationsReachableWithoutPredicate.put(altI, locations);
                }
                locations.add(s2.associatedASTNode.token);
            }
            this.dfa.probe.reportIncompletelyCoveredAlts(d2, altToLocationsReachableWithoutPredicate);
        }
        return altToPredicateContextMap;
    }

    protected static SemanticContext getUnionOfPredicates(Map altToPredMap) {
        SemanticContext unionOfPredicatesFromAllAlts = null;
        for (SemanticContext semCtx : altToPredMap.values()) {
            if (unionOfPredicatesFromAllAlts == null) {
                unionOfPredicatesFromAllAlts = semCtx;
                continue;
            }
            unionOfPredicatesFromAllAlts = SemanticContext.or(unionOfPredicatesFromAllAlts, semCtx);
        }
        return unionOfPredicatesFromAllAlts;
    }

    protected void addPredicateTransitions(DFAState d2) {
        ArrayList<NFAConfiguration> configsWithPreds = new ArrayList<NFAConfiguration>();
        int numConfigs = d2.nfaConfigurations.size();
        for (int i2 = 0; i2 < numConfigs; ++i2) {
            NFAConfiguration c2 = d2.nfaConfigurations.get(i2);
            if (!c2.resolveWithPredicate) continue;
            configsWithPreds.add(c2);
        }
        Collections.sort(configsWithPreds, new Comparator(){

            public int compare(Object a2, Object b2) {
                NFAConfiguration ca = (NFAConfiguration)a2;
                NFAConfiguration cb = (NFAConfiguration)b2;
                if (ca.alt < cb.alt) {
                    return -1;
                }
                if (ca.alt > cb.alt) {
                    return 1;
                }
                return 0;
            }
        });
        ArrayList<NFAConfiguration> predConfigsSortedByAlt = configsWithPreds;
        for (int i3 = 0; i3 < predConfigsSortedByAlt.size(); ++i3) {
            NFAConfiguration c3 = (NFAConfiguration)predConfigsSortedByAlt.get(i3);
            DFAState predDFATarget = d2.dfa.getAcceptState(c3.alt);
            if (predDFATarget == null) {
                predDFATarget = this.dfa.newState();
                predDFATarget.addNFAConfiguration(this.dfa.nfa.getState(c3.state), c3.alt, c3.context, c3.semanticContext);
                predDFATarget.setAcceptState(true);
                this.dfa.setAcceptState(c3.alt, predDFATarget);
                DFAState existingState = this.dfa.addState(predDFATarget);
                if (predDFATarget != existingState) {
                    this.dfa.setState(predDFATarget.stateNumber, existingState);
                    predDFATarget = existingState;
                }
            }
            d2.addTransition(predDFATarget, new PredicateLabel(c3.semanticContext));
        }
    }

    protected void initContextTrees(int numberOfAlts) {
        this.contextTrees = new NFAContext[numberOfAlts];
        for (int i2 = 0; i2 < this.contextTrees.length; ++i2) {
            int alt = i2 + 1;
            this.contextTrees[i2] = new NFAContext(null, null);
        }
    }

    public static int max(Set s2) {
        if (s2 == null) {
            return Integer.MIN_VALUE;
        }
        int i2 = 0;
        int m2 = 0;
        for (Integer I2 : s2) {
            if (++i2 == 1) {
                m2 = I2;
                continue;
            }
            if (I2 <= m2) continue;
            m2 = I2;
        }
        return m2;
    }
}

