/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.Map;
import javax.help.SearchHit;
import javax.help.TOCItem;
import javax.help.search.SearchItem;

public class SearchTOCItem
extends TOCItem {
    private URL url;
    private Vector sivec;
    private boolean inTOC;
    private double confidence;

    public SearchTOCItem(Map.ID iD2, Map.ID iD3, HelpSet helpSet, Locale locale) {
        super(iD2, iD3, helpSet, locale);
        this.inTOC = true;
        this.url = null;
        this.sivec = new Vector();
        this.confidence = 0.0;
    }

    public SearchTOCItem(SearchItem searchItem) {
        super(null, null, null, HelpUtilities.localeFromLang(searchItem.getLang()));
        this.inTOC = false;
        this.setName(searchItem.getTitle());
        try {
            this.url = new URL(searchItem.getBase(), searchItem.getFilename());
        }
        catch (MalformedURLException malformedURLException) {
            this.url = null;
        }
        this.sivec = new Vector();
        SearchHit searchHit = new SearchHit(searchItem.getConfidence(), searchItem.getBegin(), searchItem.getEnd());
        this.confidence = searchItem.getConfidence();
        this.sivec.addElement(searchHit);
    }

    public void addSearchHit(SearchHit searchHit) {
        if (this.sivec.isEmpty()) {
            this.sivec.addElement(searchHit);
            this.confidence = searchHit.getConfidence();
        } else {
            int n2 = this.sivec.size() - 1;
            while (n2 >= 0) {
                SearchHit searchHit2 = (SearchHit)this.sivec.elementAt(n2);
                if (searchHit2.getConfidence() <= searchHit.getConfidence()) {
                    this.sivec.insertElementAt(searchHit, n2 + 1);
                    break;
                }
                if (n2 == 0) {
                    this.sivec.insertElementAt(searchHit, 0);
                    this.confidence = searchHit.getConfidence();
                }
                --n2;
            }
        }
    }

    public URL getURL() {
        return this.url;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public Enumeration getConfidences() {
        return new Enumeration(){
            int count = 0;

            public boolean hasMoreElements() {
                return this.count < SearchTOCItem.this.sivec.size();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object nextElement() {
                Vector vector = SearchTOCItem.this.sivec;
                synchronized (vector) {
                    block4: {
                        if (this.count >= SearchTOCItem.this.sivec.size()) break block4;
                        Double d2 = new Double(((SearchHit)SearchTOCItem.this.sivec.elementAt(this.count++)).getConfidence());
                        return d2;
                    }
                }
                throw new NoSuchElementException("Vector Enumeration");
            }
        };
    }

    public boolean inTOC() {
        return this.inTOC;
    }

    public Enumeration getSearchHits() {
        return this.sivec.elements();
    }

    public int hitCount() {
        return this.sivec.size();
    }
}

