/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.HitStore;
import com.sun.java.help.search.Location;
import com.sun.java.help.search.QueryHit;
import com.sun.java.help.search.SearchEnvironment;
import java.util.Vector;
import javax.help.search.SearchItem;
import javax.help.search.SearchQuery;

class Query {
    private double _currentStandard;
    private final int _nColumns;
    private double[] _missingPenalty;
    private double[] _upperboundTemplate;
    private double[] _penalties;
    private final SearchEnvironment _env;
    private int _hitCounter;
    private boolean _vote;
    private HitStore _store;

    public Query(SearchEnvironment searchEnvironment, int n2, double[] dArray) {
        this._env = searchEnvironment;
        this._nColumns = n2;
        this._missingPenalty = new double[n2];
        this._upperboundTemplate = new double[n2];
        this._penalties = dArray;
        this._hitCounter = 0;
        this._vote = false;
        this._currentStandard = (double)(n2 - 1) * 10.0 + 9.9999;
        this._store = new HitStore(this._currentStandard);
        int n3 = 0;
        while (n3 < this._nColumns) {
            this._missingPenalty[n3] = dArray != null ? dArray[n3] : 10.0;
            ++n3;
        }
        this.makePenaltiesTable();
    }

    public void makeEvent(int n2, SearchQuery searchQuery) {
        Vector<SearchItem> vector = new Vector<SearchItem>(n2);
        if (n2 > 0) {
            int n3 = n2;
            QueryHit queryHit = this._store.firstBestQueryHit();
            n2 = n3;
            while (queryHit != null) {
                try {
                    vector.addElement(this._env.makeItem(queryHit));
                }
                catch (Exception exception) {
                    System.err.println(exception + "hit not translated");
                }
                QueryHit queryHit2 = queryHit = --n2 > 0 ? this._store.nextBestQueryHit() : null;
            }
        }
        searchQuery.itemsFound(true, vector);
    }

    public double lookupPenalty(int n2) {
        return this._penalties[n2];
    }

    public double getOutOufOrderPenalty() {
        return 0.25;
    }

    public double getGapPenalty() {
        return 0.005;
    }

    public int getNColumns() {
        return this._nColumns;
    }

    public boolean goodEnough(double d2) {
        return d2 <= this._currentStandard;
    }

    public int[] getConceptArrayOfNewHit(double d2, Location location) {
        QueryHit queryHit = new QueryHit(location, d2, this._nColumns);
        this._store.addQueryHit(queryHit);
        ++this._hitCounter;
        return queryHit.getArray();
    }

    public void resetForNextDocument() {
        this._currentStandard = this._store.getCurrentStandard();
        int n2 = 0;
        while (n2 < this._nColumns) {
            this._upperboundTemplate[n2] = this._missingPenalty[n2];
            ++n2;
        }
        this._vote = false;
    }

    public boolean vote() {
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < this._nColumns) {
            d2 += this._upperboundTemplate[n2];
            ++n2;
        }
        this._vote = d2 <= this._currentStandard;
        return this._vote;
    }

    public void updateEstimate(int n2, double d2) {
        if (d2 < this._upperboundTemplate[n2]) {
            this._upperboundTemplate[n2] = d2;
        }
    }

    public void printHits(int n2) {
        if (n2 > 0) {
            int n3 = n2;
            QueryHit queryHit = this._store.firstBestQueryHit();
            n2 = n3;
            while (queryHit != null) {
                try {
                    System.out.println(this._env.hitToString(queryHit));
                }
                catch (Exception exception) {
                    System.err.println(exception + "hit not translated");
                }
                QueryHit queryHit2 = queryHit = --n2 > 0 ? this._store.nextBestQueryHit() : null;
            }
        }
    }

    private void makePenaltiesTable() {
        int n2 = 1 << this._nColumns;
        this._penalties = new double[n2];
        int n3 = 0;
        while (n3 < n2) {
            this._penalties[n3] = this.computePenalty(n3);
            ++n3;
        }
    }

    private double computePenalty(int n2) {
        double d2 = 0.0;
        int n3 = 0;
        while (n3 < this._nColumns) {
            if ((n2 & 1 << n3) == 0) {
                d2 += this._missingPenalty[n3];
            }
            ++n3;
        }
        return d2;
    }
}

