/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.impl;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.help.TreeItem;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.text.BoxView;
import javax.swing.text.EditorKit;
import javax.swing.text.View;

public class JHelpPrintHandler
implements ActionListener {
    public static final String PRINT_BUTTON_NAME = "PrintButton";
    public static final String PAGE_SETUP_BUTTON_NAME = "PageSetupButton";
    public static final String PRINT_LATER_BUTTON_NAME = "PrintLaterButton";
    private boolean enabled = true;
    private PrinterJob printerJob;
    private PageFormat pageFormat;
    private JHelp help;
    private HelpModel helpModel;
    private URL documentURL;
    private String documentTitle;
    private static WeakHashMap handlers;
    protected SwingPropertyChangeSupport changeSupport;
    private static final boolean debug = false;

    public JHelpPrintHandler(JHelp jHelp) {
        this.help = jHelp;
    }

    public static JHelpPrintHandler getJHelpPrintHandler(JHelp jHelp) {
        JHelpPrintHandler jHelpPrintHandler = null;
        if (handlers == null) {
            handlers = new WeakHashMap();
        } else {
            jHelpPrintHandler = (JHelpPrintHandler)handlers.get(jHelp);
        }
        if (jHelpPrintHandler == null) {
            jHelpPrintHandler = new JHelpPrintHandler(jHelp);
            handlers.put(jHelp, jHelpPrintHandler);
        }
        return jHelpPrintHandler;
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(string, object, object2);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this.enabled;
        this.enabled = bl;
        this.firePropertyChange("enabled", new Boolean(bl2), new Boolean(bl));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = null;
        Object object = actionEvent.getSource();
        if (object instanceof MenuComponent) {
            string = ((MenuComponent)object).getName();
        }
        if (object instanceof Component) {
            string = ((Component)object).getName();
        }
        if (this.isEnabled()) {
            if (string != null && string.equals(PAGE_SETUP_BUTTON_NAME)) {
                this.printSetup();
            } else if (this.getHelp() != null) {
                this.print(this.getURLs());
            } else if (this.getHelpModel() != null) {
                this.print(this.getHelpModel().getCurrentURL());
            }
        }
    }

    public void printSetup() {
        if (this.isEnabled()) {
            new PageSetupThread().start();
        }
    }

    public void print(URL uRL) {
        if (this.isEnabled()) {
            new PrintThread(uRL).start();
        }
    }

    public void print(URL[] uRLArray) {
        if (this.isEnabled()) {
            new PrintThread(uRLArray).start();
        }
    }

    private JHelp getHelp() {
        return this.help;
    }

    private URL[] getURLs() {
        TreeItem[] treeItemArray;
        URL[] uRLArray = null;
        if (this.getHelp() != null && (treeItemArray = this.getHelp().getSelectedItems()) != null) {
            JHelpPrintHandler.debug("pages to print: " + treeItemArray.length);
            uRLArray = new URL[treeItemArray.length];
            int n2 = 0;
            while (n2 < treeItemArray.length) {
                JHelpPrintHandler.debug("   " + treeItemArray[n2].getName() + ": " + treeItemArray[n2].getURL());
                uRLArray[n2] = treeItemArray[n2].getURL();
                ++n2;
            }
        }
        return uRLArray;
    }

    public PageFormat getPageFormat() {
        if (this.pageFormat == null && this.getPrinterJob() != null) {
            this.pageFormat = this.getPrinterJob().defaultPage();
        }
        return this.pageFormat;
    }

    public PageFormat getPF() {
        return this.getPageFormat();
    }

    public void setPageFormat(PageFormat pageFormat) {
        if (this.pageFormat == pageFormat) {
            return;
        }
        PageFormat pageFormat2 = this.pageFormat;
        this.pageFormat = pageFormat;
        this.firePropertyChange("pageFormat", pageFormat2, pageFormat);
    }

    public void setPF(PageFormat pageFormat) {
        this.setPageFormat(pageFormat);
    }

    public PrinterJob getPrinterJob() {
        if (this.printerJob == null) {
            try {
                this.printerJob = PrinterJob.getPrinterJob();
            }
            catch (SecurityException securityException) {
                this.setEnabled(false);
                JHelpPrintHandler.processException(securityException);
            }
        }
        return this.printerJob;
    }

    public void handlePageSetup(Component component) {
        component.setName(PAGE_SETUP_BUTTON_NAME);
    }

    public void setHelpModel(HelpModel helpModel) {
        HelpModel helpModel2 = this.helpModel;
        this.helpModel = helpModel;
        this.firePropertyChange("helpModel", helpModel2, helpModel);
    }

    public HelpModel getHelpModel() {
        return this.helpModel;
    }

    static Window getWindowForObject(Object object) {
        if (object == null || object instanceof Frame || object instanceof Dialog) {
            return (Window)object;
        }
        MenuContainer menuContainer = null;
        if (object instanceof MenuComponent) {
            menuContainer = ((MenuComponent)object).getParent();
        } else if (object instanceof Component) {
            menuContainer = ((Component)object).getParent();
        }
        return JHelpPrintHandler.getWindowForObject(menuContainer);
    }

    static Insets getInsetsForContainer(Container container) {
        Insets insets = container.getInsets();
        container = container.getParent();
        while (container != null) {
            Insets insets2 = container.getInsets();
            insets.bottom += insets2.bottom;
            insets.left += insets2.left;
            insets.right += insets2.right;
            insets.top += insets2.top;
            if (container instanceof Window) break;
            container = container.getParent();
        }
        return insets;
    }

    EditorKit createEditorKitForContentType(String string) {
        HelpModel helpModel = null;
        JHelp jHelp = this.getHelp();
        helpModel = jHelp != null ? jHelp.getModel() : this.getHelpModel();
        if (helpModel == null) {
            return null;
        }
        HelpSet helpSet = helpModel.getHelpSet();
        if (helpSet == null) {
            return null;
        }
        String string2 = (String)helpSet.getKeyData(HelpSet.kitTypeRegistry, string);
        if (string2 == null) {
            return null;
        }
        ClassLoader classLoader = (ClassLoader)helpSet.getKeyData(HelpSet.kitLoaderRegistry, string);
        if (classLoader == null) {
            classLoader = helpSet.getLoader();
        }
        EditorKit editorKit = null;
        try {
            Class<?> clazz = classLoader != null ? classLoader.loadClass(string2) : Class.forName(string2);
            editorKit = (EditorKit)clazz.newInstance();
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
            editorKit = null;
        }
        if (editorKit != null) {
            return (EditorKit)editorKit.clone();
        }
        return editorKit;
    }

    protected static Rectangle getViewRec(View view, float f2, float f3) {
        Rectangle rectangle = new Rectangle();
        view.setSize(f2, f3);
        rectangle.width = (int)Math.max((long)Math.ceil(view.getMinimumSpan(0)), (long)f2);
        rectangle.height = (int)Math.min((long)Math.ceil(view.getPreferredSpan(1)), Integer.MAX_VALUE);
        view.setSize(rectangle.width, rectangle.height);
        if (view.getView(0) instanceof BoxView) {
            BoxView boxView = (BoxView)view.getView(0);
            rectangle.width = boxView.getWidth();
            rectangle.height = boxView.getHeight();
        } else {
            rectangle.height = (int)Math.min((long)Math.ceil(view.getPreferredSpan(1)), Integer.MAX_VALUE);
        }
        return rectangle;
    }

    protected static void processException(Exception exception) {
        System.err.println(exception);
    }

    private static void debug(String string) {
    }

    class JHEditorPane
    extends JEditorPane {
        public JHEditorPane() {
            this.setDoubleBuffered(false);
            this.setEditable(false);
            this.setDropTarget(null);
        }

        public EditorKit getEditorKitForContentType(String string) {
            EditorKit editorKit = JHelpPrintHandler.this.createEditorKitForContentType(string);
            if (editorKit == null) {
                editorKit = super.getEditorKitForContentType(string);
            }
            return editorKit;
        }

        public void addMouseListener(MouseListener mouseListener) {
        }

        public void removeMouseListener(MouseListener mouseListener) {
        }

        public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        }

        public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        }

        public void addFocusListener(FocusListener focusListener) {
        }

        public void removeFocusListener(FocusListener focusListener) {
        }

        public void addKeyListener(KeyListener keyListener) {
        }

        public void removeKeyListener(KeyListener keyListener) {
        }
    }

    class JHFrame
    extends JFrame {
        JHFrame() {
        }

        public void addNotify() {
            this.getRootPane().addNotify();
        }

        public void validate() {
            this.validateTree();
        }

        public Graphics getGraphics() {
            return JHelpPrintHandler.this.getHelp().getGraphics();
        }
    }

    public class JHPageable
    implements Pageable {
        private JEditorPane editor;
        private URL[] urls;
        private PageFormat pf;
        private int lastIndex = -1;
        private int lastPage = 0;
        private Printable printable = new EmptyPrintable();
        private int numPages = 0;

        public JHPageable(JEditorPane jEditorPane, URL[] uRLArray, PageFormat pageFormat) {
            this.editor = jEditorPane;
            this.urls = uRLArray;
            this.pf = pageFormat;
        }

        public PageFormat getPageFormat(int n2) throws IndexOutOfBoundsException {
            return this.pf;
        }

        public int getNumberOfPages() {
            if (this.numPages != 0) {
                return this.numPages;
            }
            if (this.urls != null) {
                int n2 = 0;
                while (n2 < this.urls.length) {
                    JHPrintable jHPrintable = new JHPrintable(this.editor, this.urls[n2], this.pf, 0, true);
                    this.numPages += jHPrintable.getNumberOfPages();
                    ++n2;
                }
            }
            return this.numPages;
        }

        public Printable getPrintable(int n2) throws IndexOutOfBoundsException {
            JHelpPrintHandler.debug("JHPageable.getPrintable(" + n2 + "): lastIndex=" + this.lastIndex + ", lastPage" + this.lastPage);
            if (n2 < 0) {
                throw new IndexOutOfBoundsException(n2 + " < 0");
            }
            if (this.urls != null) {
                while (n2 >= this.lastPage && this.lastIndex + 1 < this.urls.length) {
                    if (this.urls[++this.lastIndex] != null) {
                        this.printable = new JHPrintable(this.editor, this.urls[this.lastIndex], this.pf, this.lastPage, true);
                        this.lastPage += ((JHPrintable)this.printable).getNumberOfPages();
                        continue;
                    }
                    this.printable = new EmptyPrintable();
                }
            }
            if (n2 > this.lastPage) {
                throw new IndexOutOfBoundsException(n2 + " > " + this.lastPage);
            }
            return this.printable;
        }
    }

    class EmptyPrintable
    implements Printable {
        EmptyPrintable() {
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n2) throws PrinterException {
            return 1;
        }
    }

    class JHPrintable
    implements Printable,
    PropertyChangeListener {
        JEditorPane editor;
        URL url;
        PageFormat pf;
        int firstPage;
        boolean scaleToFit;
        Vector transforms;

        public JHPrintable(JEditorPane jEditorPane, URL uRL, PageFormat pageFormat, int n2, boolean bl) {
            this.editor = jEditorPane;
            this.url = uRL;
            this.pf = pageFormat;
            this.firstPage = n2;
            this.scaleToFit = bl;
        }

        private synchronized void loadPage() {
            JHelpPrintHandler.debug("JHPrintable.loadPage(): " + this.url);
            URL uRL = this.editor.getPage();
            if (uRL != null && uRL.equals(this.url)) {
                return;
            }
            this.editor.addPropertyChangeListener("page", this);
            try {
                this.editor.setPage(this.url);
                this.wait();
            }
            catch (Exception exception) {
                JHelpPrintHandler.processException(exception);
            }
            this.editor.removePropertyChangeListener("page", this);
        }

        public int getNumberOfPages() {
            if (this.transforms == null) {
                this.loadPage();
                this.transforms = this.createTransforms();
            }
            return this.transforms.size();
        }

        public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.notifyAll();
        }

        /*
         * Exception decompiling
         */
        public Vector createTransforms() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 24[SIMPLE_IF_TAKEN]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void printHeader(Graphics2D graphics2D, int n2) {
            graphics2D.setClip(new Rectangle2D.Double(0.0, 0.0, this.pf.getWidth(), this.pf.getHeight()));
            graphics2D.setFont(new Font("Serif", 2, 10));
            String string = (String)this.editor.getDocument().getProperty("title") + " " + (n2 + 1) + "/" + this.transforms.size();
            Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
            graphics2D.drawString(string, (float)(this.pf.getWidth() - rectangle2D.getX() - rectangle2D.getWidth() - 36.0), 36.0f);
            graphics2D.setClip(new Rectangle2D.Double(this.pf.getImageableX(), this.pf.getImageableY(), this.pf.getImageableWidth(), this.pf.getImageableHeight()));
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n2) {
            JHelpPrintHandler.debug("Printing document page=" + n2);
            JHelpPrintHandler.debug("Printing page=" + (n2 -= this.firstPage));
            if (n2 >= this.getNumberOfPages()) {
                return 1;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            this.printHeader(graphics2D, n2);
            graphics2D.transform((AffineTransform)this.transforms.get(n2));
            JHelpPrintHandler.debug("Graphics tansform=" + graphics2D.getTransform());
            JHelpPrintHandler.debug("Graphics clip=" + graphics2D.getClip());
            Rectangle2D rectangle2D = graphics2D.getClip().getBounds2D();
            double d2 = ((PageTransform)this.transforms.get(n2)).getHeight();
            double d3 = rectangle2D.getY() + rectangle2D.getHeight() - 1.0 - d2;
            if (d3 > 0.0) {
                JHelpPrintHandler.debug("Graphics adjusted height=" + d3);
                graphics2D.clip(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight() - d3));
                rectangle2D = graphics2D.getClip().getBounds2D();
                JHelpPrintHandler.debug("Graphics tansform=" + graphics2D.getTransform());
                JHelpPrintHandler.debug("Graphics clip=" + graphics2D.getClip());
            }
            if (!(rectangle2D.getY() < d2)) {
                return 1;
            }
            this.editor.paint(graphics2D);
            return 0;
        }
    }

    class PageTransform
    extends AffineTransform {
        private double height;

        PageTransform() {
        }

        public double getHeight() {
            return this.height;
        }

        public void setHeight(double d2) {
            this.height = d2;
        }
    }

    class PrintThread
    extends Thread {
        private URL[] urls;
        private int index = 0;

        PrintThread(URL uRL) {
            this(new URL[]{uRL});
        }

        PrintThread(URL[] uRLArray) {
            this.urls = uRLArray;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            PrinterJob printerJob = JHelpPrintHandler.this.getPrinterJob();
            if (printerJob != null) {
                PrinterJob printerJob2 = printerJob;
                synchronized (printerJob2) {
                    JHEditorPane jHEditorPane = new JHEditorPane();
                    JHFrame jHFrame = new JHFrame();
                    jHFrame.setContentPane(jHEditorPane);
                    try {
                        printerJob.setPageable(new JHPageable(jHEditorPane, this.urls, (PageFormat)JHelpPrintHandler.this.getPageFormat().clone()));
                    }
                    catch (Exception exception) {
                        JHelpPrintHandler.processException(exception);
                    }
                    if (printerJob.printDialog()) {
                        try {
                            printerJob.print();
                        }
                        catch (Exception exception) {
                            JHelpPrintHandler.processException(exception);
                        }
                    }
                    jHFrame.dispose();
                }
            }
        }
    }

    class PageSetupThread
    extends Thread {
        PrinterJob job;

        PageSetupThread() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            PrinterJob printerJob = JHelpPrintHandler.this.getPrinterJob();
            if (printerJob != null) {
                PrinterJob printerJob2 = printerJob;
                synchronized (printerJob2) {
                    try {
                        JHelpPrintHandler.this.setPageFormat(printerJob.pageDialog(JHelpPrintHandler.this.getPageFormat()));
                    }
                    catch (Exception exception) {
                        JHelpPrintHandler.processException(exception);
                    }
                }
            }
        }
    }
}

