/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.MouseInputAdapter;

public class ScrollPaneOverview
extends JComponent {
    private static final int MAX_SIZE = 400;
    private static final int MAX_SCALE = 20;
    private Component _owner;
    private JScrollPane _scrollPane;
    private Component _viewComponent;
    protected JPopupMenu _popupMenu;
    private BufferedImage _image;
    private Rectangle _startRectangle;
    private Rectangle _rectangle;
    private Point _startPoint;
    private double _scale;
    private int xOffset;
    private int yOffset;
    private Color _selectionBorder = Color.BLACK;

    public ScrollPaneOverview(JScrollPane jScrollPane, Component component) {
        this._scrollPane = jScrollPane;
        this._owner = component;
        this._image = null;
        this._startRectangle = null;
        this._rectangle = null;
        this._startPoint = null;
        this._scale = 0.0;
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setCursor(Cursor.getPredefinedCursor(13));
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (ScrollPaneOverview.this._startPoint != null) {
                    Point point = mouseEvent.getPoint();
                    int n2 = (int)((double)(point.x - ((ScrollPaneOverview)ScrollPaneOverview.this)._startPoint.x) / ScrollPaneOverview.this._scale);
                    int n3 = (int)((double)(point.y - ((ScrollPaneOverview)ScrollPaneOverview.this)._startPoint.y) / ScrollPaneOverview.this._scale);
                    ScrollPaneOverview.this.scroll(n2, n3);
                }
                ScrollPaneOverview.this._startPoint = null;
                ScrollPaneOverview.this._startRectangle = ScrollPaneOverview.this._rectangle;
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (ScrollPaneOverview.this._startPoint == null) {
                    ScrollPaneOverview.this._startPoint = new Point(((ScrollPaneOverview)ScrollPaneOverview.this)._rectangle.x + ((ScrollPaneOverview)ScrollPaneOverview.this)._rectangle.width / 2, ((ScrollPaneOverview)ScrollPaneOverview.this)._rectangle.y + ((ScrollPaneOverview)ScrollPaneOverview.this)._rectangle.height / 2);
                }
                Point point = mouseEvent.getPoint();
                ScrollPaneOverview.this.moveRectangle(point.x - ((ScrollPaneOverview)ScrollPaneOverview.this)._startPoint.x, point.y - ((ScrollPaneOverview)ScrollPaneOverview.this)._startPoint.y);
            }
        };
        this.addMouseListener(mouseInputAdapter);
        this.addMouseMotionListener(mouseInputAdapter);
        this._popupMenu = new JPopupMenu();
        this._popupMenu.setLayout(new BorderLayout());
        this._popupMenu.add((Component)this, "Center");
    }

    public void setSelectionBorderColor(Color color) {
        this._selectionBorder = color;
    }

    public Color getSelectionBorder() {
        return this._selectionBorder;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this._image == null || this._rectangle == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Insets insets = this.getInsets();
        int n2 = insets.left;
        int n3 = insets.top;
        graphics.setColor(this._scrollPane.getViewport().getView().getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.drawImage(this._image, n2, n3, null);
        int n4 = this.getWidth() - insets.left - insets.right;
        int n5 = this.getHeight() - insets.top - insets.bottom;
        Area area = new Area(new Rectangle(n2, n3, n4, n5));
        area.subtract(new Area(this._rectangle));
        graphics.setColor(new Color(255, 255, 255, 128));
        graphics2D.fill(area);
        Color color = graphics.getColor();
        graphics.setColor(this._selectionBorder);
        graphics.drawRect(this._rectangle.x, this._rectangle.y, this._rectangle.width, this._rectangle.height);
        graphics.setColor(color);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this._image == null || this._rectangle == null) {
            return new Dimension();
        }
        Insets insets = this.getInsets();
        return new Dimension(this._image.getWidth(null) + insets.left + insets.right, this._image.getHeight(null) + insets.top + insets.bottom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display() {
        this._viewComponent = this._scrollPane.getViewport().getView();
        if (this._viewComponent == null) {
            return;
        }
        int n2 = Math.max(400, Math.max(this._scrollPane.getWidth(), this._scrollPane.getHeight()) / 2);
        int n3 = Math.min(this._viewComponent.getWidth(), this._scrollPane.getViewport().getWidth() * 20);
        if (n3 <= 0) {
            return;
        }
        int n4 = Math.min(this._viewComponent.getHeight(), this._scrollPane.getViewport().getHeight() * 20);
        if (n4 <= 0) {
            return;
        }
        double d2 = (double)n2 / (double)n3;
        double d3 = (double)n2 / (double)n4;
        this._scale = Math.max(0.05, Math.min(d2, d3));
        this._image = new BufferedImage((int)((double)n3 * this._scale), (int)((double)n4 * this._scale), 1);
        Graphics2D graphics2D = this._image.createGraphics();
        graphics2D.scale(this._scale, this._scale);
        graphics2D.setClip(this.xOffset, this.yOffset, n3, n4);
        boolean bl = this._viewComponent.isDoubleBuffered();
        try {
            if (this._viewComponent instanceof JComponent) {
                ((JComponent)this._viewComponent).setDoubleBuffered(false);
            }
            this._viewComponent.paint(graphics2D);
        }
        finally {
            if (this._viewComponent instanceof JComponent) {
                ((JComponent)this._viewComponent).setDoubleBuffered(bl);
            }
            graphics2D.dispose();
        }
        this._startRectangle = this._scrollPane.getViewport().getViewRect();
        Insets insets = this.getInsets();
        this._startRectangle.x = (int)(this._scale * (double)this._startRectangle.x + (double)insets.left);
        this._startRectangle.y = (int)(this._scale * (double)this._startRectangle.y + (double)insets.right);
        this._startRectangle.width = (int)((double)this._startRectangle.width * this._scale);
        this._startRectangle.height = (int)((double)this._startRectangle.height * this._scale);
        this._rectangle = this._startRectangle;
        Point point = new Point(this._rectangle.x + this._rectangle.width / 2, this._rectangle.y + this._rectangle.height / 2);
        this.showPopup(-point.x, -point.y, this._owner);
    }

    protected void showPopup(int n2, int n3, Component component) {
        this._popupMenu.show(component, n2, n3);
    }

    private void moveRectangle(int n2, int n3) {
        if (this._startRectangle == null) {
            return;
        }
        Insets insets = this.getInsets();
        Rectangle rectangle = new Rectangle(this._startRectangle);
        rectangle.x += n2;
        rectangle.y += n3;
        rectangle.x = Math.min(Math.max(rectangle.x, insets.left), this.getWidth() - insets.right - rectangle.width);
        rectangle.y = Math.min(Math.max(rectangle.y, insets.right), this.getHeight() - insets.bottom - rectangle.height);
        Rectangle rectangle2 = new Rectangle();
        Rectangle.union(this._rectangle, rectangle, rectangle2);
        rectangle2.grow(2, 2);
        this._rectangle = rectangle;
        this.paintImmediately(rectangle2);
    }

    private void scroll(int n2, int n3) {
        JComponent jComponent = (JComponent)this._scrollPane.getViewport().getView();
        Rectangle rectangle = jComponent.getVisibleRect();
        rectangle.x += this.xOffset + n2;
        rectangle.y += this.yOffset + n3;
        jComponent.scrollRectToVisible(rectangle);
        this._popupMenu.setVisible(false);
    }
}

