/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.PartialSide;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.LineBorder;

public class PartialLineBorder
extends LineBorder
implements PartialSide {
    private int _sides = 15;
    private int _roundedCornerSize = 5;

    public PartialLineBorder(Color color) {
        super(color);
    }

    public PartialLineBorder(Color color, int n2) {
        super(color, n2);
    }

    public PartialLineBorder(Color color, int n2, boolean bl) {
        super(color, n2, bl);
    }

    public PartialLineBorder(Color color, int n2, boolean bl, int n3) {
        super(color, n2, bl);
        this._roundedCornerSize = n3;
    }

    public PartialLineBorder(Color color, int n2, int n3) {
        super(color, n2);
        this._sides = n3;
    }

    public int getSides() {
        return this._sides;
    }

    public void setSides(int n2) {
        this._sides = n2;
    }

    public int getRoundedCornerSize() {
        return this._roundedCornerSize;
    }

    public void setRoundedCornerSize(int n2) {
        this._roundedCornerSize = n2;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        Color color = graphics.getColor();
        graphics.setColor(this.lineColor);
        for (int i2 = 0; i2 < this.thickness; ++i2) {
            if (this._sides == 15) {
                if (!this.roundedCorners) {
                    graphics.drawRect(n2 + i2, n3 + i2, n4 - i2 - i2 - 1, n5 - i2 - i2 - 1);
                    continue;
                }
                Object object = JideSwingUtilities.setupShapeAntialiasing(graphics);
                graphics.drawRoundRect(n2 + i2, n3 + i2, n4 - i2 - i2 - 1, n5 - i2 - i2 - 1, this._roundedCornerSize, this._roundedCornerSize);
                JideSwingUtilities.restoreShapeAntialiasing(graphics, object);
                continue;
            }
            if ((this._sides & 1) != 0) {
                graphics.drawLine(n2, n3 + i2, n2 + n4 - 1, n3 + i2);
            }
            if ((this._sides & 2) != 0) {
                graphics.drawLine(n2, n3 + n5 - i2 - 1, n2 + n4 - 1, n3 + n5 - i2 - 1);
            }
            if ((this._sides & 8) != 0) {
                graphics.drawLine(n2 + i2, n3, n2 + i2, n3 + n5 - 1);
            }
            if ((this._sides & 4) == 0) continue;
            graphics.drawLine(n2 + n4 - i2 - 1, n3, n2 + n4 - i2 - 1, n3 + n5 - 1);
        }
        graphics.setColor(color);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        Insets insets = super.getBorderInsets(component);
        if ((this._sides & 1) == 0) {
            insets.top = 0;
        }
        if ((this._sides & 2) == 0) {
            insets.bottom = 0;
        }
        if ((this._sides & 8) == 0) {
            insets.left = 0;
        }
        if ((this._sides & 4) == 0) {
            insets.right = 0;
        }
        return insets;
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        Insets insets2 = super.getBorderInsets(component, insets);
        if ((this._sides & 1) == 0) {
            insets2.top = 0;
        }
        if ((this._sides & 2) == 0) {
            insets2.bottom = 0;
        }
        if ((this._sides & 8) == 0) {
            insets2.left = 0;
        }
        if ((this._sides & 4) == 0) {
            insets2.right = 0;
        }
        return insets2;
    }
}

