/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.dialog.JideOptionPane;
import com.jidesoft.swing.JideSplitPaneDivider;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.AWTError;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JideBoxLayout
implements LayoutManager2,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(JideBoxLayout.class.getName());
    private boolean doReset = true;
    protected int _axis;
    protected Container _target;
    private int _gap = 0;
    protected int[] _componentSizes;
    public static final String FIX = "fix";
    public static final String FLEXIBLE = "flexible";
    public static final String VARY = "vary";
    private final HashMap<Component, Object> _constraintMap = new HashMap();
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int LINE_AXIS = 2;
    public static final int PAGE_AXIS = 3;
    private boolean _resetWhenInvalidate = true;
    private boolean _alwaysLayout = true;
    private static final long serialVersionUID = -183922972679053590L;

    public JideBoxLayout(Container container) {
        this(container, 0);
    }

    public JideBoxLayout(Container container, int n2) {
        this(container, n2, 0);
    }

    public JideBoxLayout(Container container, int n2, int n3) {
        if (n2 != 0 && n2 != 1 && n2 != 2 && n2 != 3) {
            throw new AWTError("Invalid axis");
        }
        this._axis = n2;
        this._target = container;
        this._gap = n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n2;
            int n3;
            int n42;
            boolean bl;
            int n5;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(this + " layoutContainer started");
            }
            Dimension dimension = container.getSize();
            if (dimension.height <= 0 || dimension.width <= 0) {
                return;
            }
            Insets insets = this._target.getInsets();
            if (this.doReset) {
                this._componentSizes = new int[this._target.getComponentCount()];
                n5 = this.getAvailableSize(dimension, insets);
                if ((n5 -= this.getGapSize()) <= 0) {
                    return;
                }
                bl = this.calculateComponentSizes(n5, 0, this._target.getComponentCount());
                if (!bl) {
                    if (!this.isAlwaysLayout() && "false".equals(SecurityUtils.getProperty("JideBoxLayout.alwaysLayout", "false"))) {
                        for (int i2 = 0; i2 < this._target.getComponentCount(); ++i2) {
                            Component component = this._target.getComponent(i2);
                            this.setComponentToSize(component, 0, 0, insets, dimension);
                        }
                        this.redoLayout(container);
                    }
                    return;
                }
                this.doReset = false;
                if (this._componentSizes.length == 0) {
                    container.repaint();
                }
            } else {
                n5 = 0;
                for (int n42 : this._componentSizes) {
                    n5 += n42;
                }
                boolean bl2 = bl = n5 + this.getGapSize() != this.getSizeForPrimaryAxis(dimension);
                if (bl) {
                    n3 = this.getAvailableSize(dimension, insets);
                    if ((n3 -= this.getGapSize()) <= 0) {
                        return;
                    }
                    n2 = this.calculateComponentSizes(n3, 0, this._target.getComponentCount()) ? 1 : 0;
                    if (n2 == 0) {
                        if (!this.isAlwaysLayout() && "false".equals(SecurityUtils.getProperty("JideBoxLayout.alwaysLayout", "false"))) {
                            for (n42 = 0; n42 < this._target.getComponentCount(); ++n42) {
                                Component component = this._target.getComponent(n42);
                                this.setComponentToSize(component, 0, 0, insets, dimension);
                            }
                            this.redoLayout(container);
                        }
                        return;
                    }
                }
            }
            ComponentOrientation componentOrientation = this._target.getComponentOrientation();
            bl = componentOrientation.isLeftToRight();
            n3 = this.getSizeForPrimaryAxis(insets, true);
            n2 = 0;
            if (!bl && JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
                n3 = dimension.width - n3;
            }
            for (n42 = 0; n42 < this._target.getComponentCount(); ++n42) {
                int n6;
                Component component = this._target.getComponent(n42);
                int n7 = this.getPreferredSizeOfComponent(component);
                if (!bl && JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
                    this.setComponentToSize(component, this._componentSizes[n42], n3 -= this._componentSizes[n42], insets, dimension);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("layoutContainer index: " + n42 + " size: " + this._componentSizes[n42]);
                    }
                    if (this._componentSizes[n42] != 0) {
                        n3 -= this._gap;
                    }
                } else {
                    this.setComponentToSize(component, this._componentSizes[n42], n3, insets, dimension);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("layoutContainer index: " + n42 + " size: " + this._componentSizes[n42]);
                    }
                    n3 += this._componentSizes[n42];
                    if (this._componentSizes[n42] != 0) {
                        n3 += this._gap;
                    }
                }
                if ((n6 = this.getPreferredSizeOfComponent(component)) == n7) continue;
                n2 = 1;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("layoutContainer ended");
            }
            if (this._target instanceof JideOptionPane) {
                for (n42 = 0; n42 < container.getComponentCount(); ++n42) {
                    container.getComponent(n42).invalidate();
                }
                if (n2 != 0) {
                    this.redoLayout(container);
                }
            }
        }
    }

    private void redoLayout(Container container) {
        Container container2;
        for (container2 = container.getParent(); container2 != null && !(container2 instanceof Dialog); container2 = container2.getParent()) {
        }
        if (container2 != null) {
            ((Dialog)container2).pack();
        }
    }

    protected boolean calculateComponentSizes(int n2, int n3, int n4) {
        boolean bl;
        int n5;
        int n6;
        int n7 = n2;
        int n8 = 0;
        int n9 = 0;
        int n10 = -1;
        int n11 = 0;
        int n12 = 0;
        int n13 = -1;
        int n14 = -1;
        for (n6 = n3; n6 < n4; ++n6) {
            Component component = this._target.getComponent(n6);
            if (!component.isVisible()) continue;
            Object object = this._constraintMap.get(component);
            int n15 = this.getSizeForPrimaryAxis(component.getMinimumSize());
            n5 = this.getSizeForPrimaryAxis(this.getPreferredSizeOf(component, n6));
            if (FIX.equals(object)) {
                n7 -= Math.max(n5, n15);
                continue;
            }
            if (VARY.equals(object)) {
                n10 = n6;
                this.getPreferredSizeOf(component, n6);
                n8 = n15;
                continue;
            }
            if (n5 > n15) {
                n12 += n5 - n15;
            }
            n11 += n5;
            n9 += n15;
            n13 = n6;
            if (n5 == 0) continue;
            n14 = n6;
        }
        if (!this.isAlwaysLayout() && "false".equals(SecurityUtils.getProperty("JideBoxLayout.alwaysLayout", "false")) && n7 - n8 < 0) {
            return false;
        }
        n6 = n10 != -1 ? 1 : 0;
        boolean bl2 = bl = n7 - n8 >= n11;
        if (n6 == 0 || n6 != 0 && !bl) {
            double d2 = bl ? (n11 == 0 ? 0.0 : (double)(n7 - n8) / (double)n11) : (n12 == 0 ? 0.0 : (double)(n7 - n8 - n9) / (double)n12);
            for (n5 = n3; n5 < n4; ++n5) {
                Component component = this._target.getComponent(n5);
                if (!component.isVisible()) {
                    this.setComponentSize(n5, 0);
                    continue;
                }
                Object object = this._constraintMap.get(component);
                int n16 = this.getSizeForPrimaryAxis(component.getMinimumSize());
                int n17 = this.getSizeForPrimaryAxis(this.getPreferredSizeOf(component, n5));
                if (FIX.equals(object)) {
                    this.setComponentSize(n5, Math.max(n17, n16));
                    continue;
                }
                if (VARY.equals(object)) {
                    this.setComponentSize(n5, n8);
                    continue;
                }
                if (bl) {
                    this.setComponentSize(n5, (int)((double)n17 * d2));
                    continue;
                }
                this.setComponentSize(n5, n16 + (int)((double)(n17 - n16) * d2));
            }
        } else {
            for (int i2 = n3; i2 < n4; ++i2) {
                Component component = this._target.getComponent(i2);
                if (!component.isVisible()) {
                    this.setComponentSize(i2, 0);
                    continue;
                }
                Object object = this._constraintMap.get(component);
                int n18 = this.getSizeForPrimaryAxis(component.getMinimumSize());
                int n19 = this.getSizeForPrimaryAxis(this.getPreferredSizeOf(component, i2));
                if (FIX.equals(object)) {
                    this.setComponentSize(i2, Math.max(n19, n18));
                    continue;
                }
                if (VARY.equals(object)) {
                    this.setComponentSize(i2, n7 - n11);
                    continue;
                }
                this.setComponentSize(i2, Math.max(n19, n18));
            }
        }
        int n20 = 0;
        for (int i3 = n3; i3 < n4; ++i3) {
            n20 += this._componentSizes[i3];
        }
        if (n20 != n2) {
            if (n10 != -1) {
                this.setComponentSizeByGap(n10, n2 - n20);
            } else if (n14 != -1) {
                this.setComponentSizeByGap(n14, n2 - n20);
            } else if (n13 != -1) {
                this.setComponentSizeByGap(n13, n2 - n20);
            }
        }
        return true;
    }

    private void setComponentSizeByGap(int n2, int n3) {
        if (SystemInfo.isJdk15Above() && this._target.getComponent(n2).isMinimumSizeSet()) {
            this.setComponentSize(n2, Math.max(this._componentSizes[n2] + n3, this.getSizeForPrimaryAxis(this._target.getComponent(n2).getMinimumSize())));
        } else {
            this.setComponentSize(n2, this._componentSizes[n2] + n3);
        }
    }

    private void setComponentSize(int n2, int n3) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("setComponentSize index: " + n2 + " size: " + n3);
        }
        this._componentSizes[n2] = n3;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.layoutReset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container container) {
        int n2 = 0;
        int n3 = 0;
        Insets insets = this._target.getInsets();
        Object object = container.getTreeLock();
        synchronized (object) {
            for (int i2 = 0; i2 < this._target.getComponentCount(); ++i2) {
                Component component = this._target.getComponent(i2);
                if (!component.isVisible()) continue;
                Object object2 = this._constraintMap.get(component);
                Dimension dimension = component.getMinimumSize();
                n2 = FIX.equals(object2) ? (n2 += this.getPreferredSizeOfComponent(component)) : (n2 += this.getSizeForPrimaryAxis(dimension));
                int n4 = this.getSizeForSecondaryAxis(dimension);
                if (n4 <= n3) continue;
                n3 = n4;
            }
            if (insets != null) {
                n2 += this.getSizeForPrimaryAxis(insets, true) + this.getSizeForPrimaryAxis(insets, false);
                n3 += this.getSizeForSecondaryAxis(insets, true) + this.getSizeForSecondaryAxis(insets, false);
            }
        }
        object = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, (ComponentOrientation)object) == 0) {
            return new Dimension(n2 + this.getGapSize(), n3);
        }
        return new Dimension(n3, n2 + this.getGapSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container container) {
        int n2 = 0;
        int n3 = 0;
        Insets insets = this._target.getInsets();
        Object object = container.getTreeLock();
        synchronized (object) {
            for (int i2 = 0; i2 < this._target.getComponentCount(); ++i2) {
                Component component = this._target.getComponent(i2);
                if (!component.isVisible()) continue;
                Dimension dimension = this.getPreferredSizeOf(component, i2);
                n2 += this.getSizeForPrimaryAxis(dimension);
                int n4 = this.getSizeForSecondaryAxis(dimension);
                if (n4 <= n3) continue;
                n3 = n4;
            }
            if (insets != null) {
                n2 += this.getSizeForPrimaryAxis(insets, true) + this.getSizeForPrimaryAxis(insets, false);
                n3 += this.getSizeForSecondaryAxis(insets, true) + this.getSizeForSecondaryAxis(insets, false);
            }
        }
        object = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, (ComponentOrientation)object) == 0) {
            return new Dimension(n2 + this.getGapSize(), n3);
        }
        return new Dimension(n3, n2 + this.getGapSize());
    }

    private int getGapSize() {
        if (this._gap == 0) {
            return 0;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < this._target.getComponentCount(); ++i2) {
            if (!this._target.getComponent(i2).isVisible()) continue;
            ++n2;
        }
        return Math.max(0, n2 - 1) * this._gap;
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this._constraintMap.remove(component);
        if (component instanceof JideSplitPaneDivider) {
            this.layoutReset();
        }
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (object == null) {
            this._constraintMap.put(component, FLEXIBLE);
        } else {
            this._constraintMap.put(component, object);
        }
        this.layoutReset();
    }

    private void layoutReset() {
        this.doReset = true;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(this + " layoutReset");
        }
    }

    @Override
    public synchronized float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    @Override
    public synchronized float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    @Override
    public synchronized void invalidateLayout(Container container) {
        if (this.isResetWhenInvalidate() || this.componentCountChanged(container)) {
            this.layoutReset();
        }
    }

    protected boolean componentCountChanged(Container container) {
        if (this._componentSizes == null) {
            return true;
        }
        int n2 = 0;
        int[] nArray = this._componentSizes;
        int n3 = nArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = nArray[i2];
            if (n4 <= 0) continue;
            ++n2;
        }
        int n5 = 0;
        for (n3 = 0; n3 < container.getComponentCount(); ++n3) {
            if (!container.getComponent(n3).isVisible()) continue;
            ++n5;
        }
        return n5 != n2;
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected int getPreferredSizeOfComponent(Component component) {
        return this.getSizeForPrimaryAxis(component.getPreferredSize());
    }

    int getMinimumSizeOfComponent(Component component) {
        return this.getSizeForPrimaryAxis(component.getMinimumSize());
    }

    protected int getSizeOfComponent(Component component) {
        return this.getSizeForPrimaryAxis(component.getSize());
    }

    protected int getAvailableSize(Dimension dimension, Insets insets) {
        if (insets == null) {
            return this.getSizeForPrimaryAxis(dimension);
        }
        return this.getSizeForPrimaryAxis(dimension) - (this.getSizeForPrimaryAxis(insets, true) + this.getSizeForPrimaryAxis(insets, false));
    }

    protected int getInitialLocation(Insets insets) {
        if (insets != null) {
            return this.getSizeForPrimaryAxis(insets, true);
        }
        return 0;
    }

    protected void setComponentToSize(Component component, int n2, int n3, Insets insets, Dimension dimension) {
        if (insets != null) {
            ComponentOrientation componentOrientation = this._target.getComponentOrientation();
            if (JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
                component.setBounds(n3, Math.max(insets.top, 0), Math.max(n2, 0), Math.max(dimension.height - (insets.top + insets.bottom), 0));
            } else {
                component.setBounds(Math.max(insets.left, 0), n3, Math.max(dimension.width - (insets.left + insets.right), 0), Math.max(n2, 0));
            }
        } else {
            ComponentOrientation componentOrientation = this._target.getComponentOrientation();
            if (JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
                component.setBounds(n3, 0, Math.max(n2, 0), Math.max(dimension.height, 0));
            } else {
                component.setBounds(0, n3, Math.max(dimension.width, 0), Math.max(n2, 0));
            }
        }
    }

    int getSizeForPrimaryAxis(Dimension dimension) {
        ComponentOrientation componentOrientation = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
            return dimension.width;
        }
        return dimension.height;
    }

    int getSizeForSecondaryAxis(Dimension dimension) {
        ComponentOrientation componentOrientation = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
            return dimension.height;
        }
        return dimension.width;
    }

    int getSizeForPrimaryAxis(Insets insets, boolean bl) {
        ComponentOrientation componentOrientation = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
            if (bl) {
                return insets.left;
            }
            return insets.right;
        }
        if (bl) {
            return insets.top;
        }
        return insets.bottom;
    }

    int getSizeForSecondaryAxis(Insets insets, boolean bl) {
        ComponentOrientation componentOrientation = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
            if (bl) {
                return insets.top;
            }
            return insets.bottom;
        }
        if (bl) {
            return insets.left;
        }
        return insets.right;
    }

    public Map<Component, Object> getConstraintMap() {
        return this._constraintMap;
    }

    protected static int resolveAxis(int n2, ComponentOrientation componentOrientation) {
        int n3 = n2 == 2 ? (componentOrientation.isHorizontal() ? 0 : 1) : (n2 == 3 ? (componentOrientation.isHorizontal() ? 1 : 0) : n2);
        return n3;
    }

    public int getGap() {
        return this._gap;
    }

    public void setGap(int n2) {
        this._gap = n2;
    }

    protected Dimension getPreferredSizeOf(Component component, int n2) {
        Dimension dimension = component.getPreferredSize();
        Dimension dimension2 = component.getMinimumSize();
        if (dimension.height < dimension2.height) {
            dimension.height = dimension2.height;
        }
        if (dimension.width < dimension2.width) {
            dimension.width = dimension2.width;
        }
        Dimension dimension3 = component.getMaximumSize();
        if (dimension.height > dimension3.height && dimension3.height != Short.MAX_VALUE) {
            dimension.height = dimension3.height;
        }
        if (dimension.width > dimension3.width && dimension3.height != Short.MAX_VALUE) {
            dimension.width = dimension3.width;
        }
        return dimension;
    }

    public boolean isResetWhenInvalidate() {
        return this._resetWhenInvalidate;
    }

    public void setResetWhenInvalidate(boolean bl) {
        this._resetWhenInvalidate = bl;
    }

    public int getAxis() {
        return this._axis;
    }

    public void setAxis(int n2) {
        this._axis = n2;
    }

    public boolean isAlwaysLayout() {
        return this._alwaysLayout;
    }

    public void setAlwaysLayout(boolean bl) {
        this._alwaysLayout = bl;
    }
}

