/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicArrowButton;

final class WindowsArrowButton
extends BasicArrowButton {
    public WindowsArrowButton(int direction) {
        super(direction);
    }

    @Override
    public Dimension getPreferredSize() {
        int width = Math.max(5, UIManager.getInt("ScrollBar.width"));
        return new Dimension(width, width);
    }

    @Override
    public void paintTriangle(Graphics g2, int x2, int y2, int size, int triangleDirection, boolean enabled) {
        Color oldColor = g2.getColor();
        int j2 = 0;
        size = Math.max(size, 2);
        int mid = (size - 1) / 2;
        g2.translate(x2, y2);
        g2.setColor(UIManager.getColor(enabled ? "controlText" : "controlShadow"));
        switch (triangleDirection) {
            case 1: {
                int i2;
                for (i2 = 0; i2 < size; ++i2) {
                    g2.drawLine(mid - i2, i2, mid + i2, i2);
                }
                if (enabled) break;
                g2.setColor(UIManager.getColor("controlLtHighlight"));
                g2.drawLine(mid - i2 + 2, i2, mid + i2, i2);
                break;
            }
            case 5: {
                int i3;
                if (!enabled) {
                    g2.translate(1, 1);
                    g2.setColor(UIManager.getColor("controlLtHighlight"));
                    for (i3 = size - 1; i3 >= 0; --i3) {
                        g2.drawLine(mid - i3, j2, mid + i3, j2);
                        ++j2;
                    }
                    g2.translate(-1, -1);
                    g2.setColor(UIManager.getColor("controlShadow"));
                }
                j2 = 0;
                for (i3 = size - 1; i3 >= 0; --i3) {
                    g2.drawLine(mid - i3, j2, mid + i3, j2);
                    ++j2;
                }
                break;
            }
            case 7: {
                int i3;
                for (i3 = 0; i3 < size; ++i3) {
                    g2.drawLine(i3, mid - i3, i3, mid + i3);
                }
                if (enabled) break;
                g2.setColor(UIManager.getColor("controlLtHighlight"));
                g2.drawLine(i3, mid - i3 + 2, i3, mid + i3);
                break;
            }
            case 3: {
                int i4;
                if (!enabled) {
                    g2.translate(1, 1);
                    g2.setColor(UIManager.getColor("controlLtHighlight"));
                    for (i4 = size - 1; i4 >= 0; --i4) {
                        g2.drawLine(j2, mid - i4, j2, mid + i4);
                        ++j2;
                    }
                    g2.translate(-1, -1);
                    g2.setColor(UIManager.getColor("controlShadow"));
                }
                j2 = 0;
                for (i4 = size - 1; i4 >= 0; --i4) {
                    g2.drawLine(j2, mid - i4, j2, mid + i4);
                    ++j2;
                }
                break;
            }
        }
        g2.translate(-x2, -y2);
        g2.setColor(oldColor);
    }
}

