/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.common.base.Strings;
import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public final class PlasticXPIconFactory {
    private static CheckBoxIcon checkBoxIcon;
    private static RadioButtonIcon radioButtonIcon;

    private PlasticXPIconFactory() {
    }

    static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    private static final class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int SIZE = LookUtils.IS_LOW_RESOLUTION ? 13 : 15;
        private static final Stroke FOCUS_STROKE = new BasicStroke(2.0f);

        private RadioButtonIcon() {
        }

        @Override
        public int getIconWidth() {
            return SIZE;
        }

        @Override
        public int getIconHeight() {
            return SIZE;
        }

        @Override
        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            Graphics2D g22 = (Graphics2D)g2;
            AbstractButton rb = (AbstractButton)c2;
            ButtonModel model = rb.getModel();
            boolean paintFocus = model.isArmed() && !model.isPressed() || rb.hasFocus() && Strings.isBlank(rb.getText());
            Object newAAHint = RenderingHints.VALUE_ANTIALIAS_ON;
            RenderingHints.Key key = RenderingHints.KEY_ANTIALIASING;
            Object oldAAHint = g22.getRenderingHint(key);
            if (newAAHint != oldAAHint) {
                g22.setRenderingHint(key, newAAHint);
            } else {
                oldAAHint = null;
            }
            RadioButtonIcon.drawFill(g22, model.isPressed(), x2, y2, SIZE - 1, SIZE - 1);
            if (paintFocus) {
                RadioButtonIcon.drawFocus(g22, x2 + 1, y2 + 1, SIZE - 3, SIZE - 3);
            }
            if (model.isSelected()) {
                RadioButtonIcon.drawCheck(g22, c2, model.isEnabled(), x2 + 4, y2 + 4, SIZE - 8, SIZE - 8);
            }
            RadioButtonIcon.drawBorder(g22, model.isEnabled(), x2, y2, SIZE - 1, SIZE - 1);
            if (oldAAHint != null) {
                g22.setRenderingHint(key, oldAAHint);
            }
        }

        private static void drawBorder(Graphics2D g2, boolean enabled, int x2, int y2, int w2, int h2) {
            g2.setColor(enabled ? PlasticLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getControlDisabled());
            g2.drawOval(x2, y2, w2, h2);
        }

        private static void drawCheck(Graphics2D g2, Component c2, boolean enabled, int x2, int y2, int w2, int h2) {
            g2.translate(x2, y2);
            if (enabled) {
                g2.setColor(UIManager.getColor("RadioButton.check"));
                g2.fillOval(0, 0, w2, h2);
                UIManager.getIcon("RadioButton.checkIcon").paintIcon(c2, g2, 0, 0);
            } else {
                g2.setColor(MetalLookAndFeel.getControlDisabled());
                g2.fillOval(0, 0, w2, h2);
            }
            g2.translate(-x2, -y2);
        }

        private static void drawFill(Graphics2D g2, boolean pressed, int x2, int y2, int w2, int h2) {
            Color lowerRight;
            ColorUIResource upperLeft;
            if (pressed) {
                upperLeft = MetalLookAndFeel.getControlShadow();
                lowerRight = PlasticLookAndFeel.getControlHighlight();
            } else {
                upperLeft = PlasticLookAndFeel.getControl();
                lowerRight = PlasticLookAndFeel.getControlHighlight().brighter();
            }
            g2.setPaint(new GradientPaint(x2, y2, upperLeft, x2 + w2, y2 + h2, lowerRight));
            g2.fillOval(x2, y2, w2, h2);
        }

        private static void drawFocus(Graphics2D g2, int x2, int y2, int w2, int h2) {
            g2.setPaint(new GradientPaint(x2, y2, PlasticLookAndFeel.getFocusColor().brighter(), w2, h2, PlasticLookAndFeel.getFocusColor()));
            Stroke stroke = g2.getStroke();
            g2.setStroke(FOCUS_STROKE);
            g2.drawOval(x2, y2, w2, h2);
            g2.setStroke(stroke);
        }
    }

    private static final class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int SIZE = LookUtils.IS_LOW_RESOLUTION ? 13 : 15;

        private CheckBoxIcon() {
        }

        @Override
        public int getIconWidth() {
            return SIZE;
        }

        @Override
        public int getIconHeight() {
            return SIZE;
        }

        @Override
        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            JCheckBox cb = (JCheckBox)c2;
            ButtonModel model = cb.getModel();
            Graphics2D g22 = (Graphics2D)g2;
            boolean paintFocus = model.isArmed() && !model.isPressed() || cb.hasFocus() && Strings.isBlank(cb.getText());
            Object newAAHint = RenderingHints.VALUE_ANTIALIAS_ON;
            RenderingHints.Key key = RenderingHints.KEY_ANTIALIASING;
            Object oldAAHint = g22.getRenderingHint(key);
            if (newAAHint != oldAAHint) {
                g22.setRenderingHint(key, newAAHint);
            } else {
                oldAAHint = null;
            }
            CheckBoxIcon.drawBorder(g22, model.isEnabled(), x2, y2, SIZE - 1, SIZE - 1);
            CheckBoxIcon.drawFill(g22, model.isPressed(), x2 + 1, y2 + 1, SIZE - 2, SIZE - 2);
            if (paintFocus) {
                CheckBoxIcon.drawFocus(g22, x2 + 1, y2 + 1, SIZE - 3, SIZE - 3);
            }
            if (model.isSelected()) {
                CheckBoxIcon.drawCheck(g22, model.isEnabled(), x2 + 3, y2 + 3, SIZE - 7, SIZE - 7);
            }
            if (oldAAHint != null) {
                g22.setRenderingHint(key, oldAAHint);
            }
        }

        private static void drawBorder(Graphics2D g2, boolean enabled, int x2, int y2, int width, int height) {
            g2.setColor(enabled ? PlasticLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getControlDisabled());
            g2.drawRect(x2, y2, width, height);
        }

        private static void drawCheck(Graphics2D g2, boolean enabled, int x2, int y2, int width, int height) {
            g2.setColor(enabled ? UIManager.getColor("CheckBox.check") : MetalLookAndFeel.getControlDisabled());
            int right = x2 + width;
            int bottom = y2 + height;
            int startY = y2 + height / 3;
            int turnX = x2 + width / 2 - 2;
            g2.drawLine(x2, startY, turnX, bottom - 3);
            g2.drawLine(x2, startY + 1, turnX, bottom - 2);
            g2.drawLine(x2, startY + 2, turnX, bottom - 1);
            g2.drawLine(turnX + 1, bottom - 2, right, y2);
            g2.drawLine(turnX + 1, bottom - 1, right, y2 + 1);
            g2.drawLine(turnX + 1, bottom, right, y2 + 2);
        }

        private static void drawFill(Graphics2D g2, boolean pressed, int x2, int y2, int w2, int h2) {
            Color lowerRight;
            ColorUIResource upperLeft;
            if (pressed) {
                upperLeft = MetalLookAndFeel.getControlShadow();
                lowerRight = PlasticLookAndFeel.getControlHighlight();
            } else {
                upperLeft = PlasticLookAndFeel.getControl();
                lowerRight = PlasticLookAndFeel.getControlHighlight().brighter();
            }
            g2.setPaint(new GradientPaint(x2, y2, upperLeft, x2 + w2, y2 + h2, lowerRight));
            g2.fillRect(x2, y2, w2, h2);
        }

        private static void drawFocus(Graphics2D g2, int x2, int y2, int width, int height) {
            g2.setPaint(new GradientPaint(x2, y2, PlasticLookAndFeel.getFocusColor().brighter(), width, height, PlasticLookAndFeel.getFocusColor()));
            g2.drawRect(x2, y2, width, height);
            g2.drawRect(x2 + 1, y2 + 1, width - 2, height - 2);
        }
    }
}

