/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticArrowButton;
import com.jgoodies.looks.plastic.PlasticBumps;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollBarUI;

public final class PlasticScrollBarUI
extends MetalScrollBarUI {
    private static final String PROPERTY_PREFIX = "ScrollBar.";
    public static final String MAX_BUMPS_WIDTH_KEY = "ScrollBar.maxBumpsWidth";
    private Color shadowColor;
    private Color highlightColor;
    private Color darkShadowColor;
    private Color thumbColor;
    private Color thumbShadow;
    private Color thumbHighlightColor;
    private PlasticBumps bumps;

    public static ComponentUI createUI(JComponent b2) {
        return new PlasticScrollBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.bumps = new PlasticBumps(10, 10, this.thumbHighlightColor, this.thumbShadow, this.thumbColor);
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        this.decreaseButton = new PlasticArrowButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.decreaseButton;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        this.increaseButton = new PlasticArrowButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.increaseButton;
    }

    @Override
    protected void configureScrollBarColors() {
        super.configureScrollBarColors();
        this.shadowColor = UIManager.getColor("ScrollBar.shadow");
        this.highlightColor = UIManager.getColor("ScrollBar.highlight");
        this.darkShadowColor = UIManager.getColor("ScrollBar.darkShadow");
        this.thumbColor = UIManager.getColor("ScrollBar.thumb");
        this.thumbShadow = UIManager.getColor("ScrollBar.thumbShadow");
        this.thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
    }

    @Override
    protected void paintTrack(Graphics g2, JComponent c2, Rectangle trackBounds) {
        g2.translate(trackBounds.x, trackBounds.y);
        boolean leftToRight = PlasticUtils.isLeftToRight(c2);
        if (this.scrollbar.getOrientation() == 1) {
            if (!this.isFreeStanding) {
                if (!leftToRight) {
                    ++trackBounds.width;
                    g2.translate(-1, 0);
                } else {
                    trackBounds.width += 2;
                }
            }
            if (c2.isEnabled()) {
                g2.setColor(this.darkShadowColor);
                g2.drawLine(0, 0, 0, trackBounds.height - 1);
                g2.drawLine(trackBounds.width - 2, 0, trackBounds.width - 2, trackBounds.height - 1);
                g2.drawLine(1, trackBounds.height - 1, trackBounds.width - 1, trackBounds.height - 1);
                g2.drawLine(1, 0, trackBounds.width - 2, 0);
                g2.setColor(this.shadowColor);
                g2.drawLine(1, 1, 1, trackBounds.height - 2);
                g2.drawLine(1, 1, trackBounds.width - 3, 1);
                if (this.scrollbar.getValue() != this.scrollbar.getMaximum()) {
                    int y2 = this.thumbRect.y + this.thumbRect.height - trackBounds.y;
                    g2.drawLine(1, y2, trackBounds.width - 1, y2);
                }
                g2.setColor(this.highlightColor);
                g2.drawLine(trackBounds.width - 1, 0, trackBounds.width - 1, trackBounds.height - 1);
            } else {
                PlasticUtils.drawDisabledBorder(g2, 0, 0, trackBounds.width, trackBounds.height);
            }
            if (!this.isFreeStanding) {
                if (!leftToRight) {
                    --trackBounds.width;
                    g2.translate(1, 0);
                } else {
                    trackBounds.width -= 2;
                }
            }
        } else {
            if (!this.isFreeStanding) {
                trackBounds.height += 2;
            }
            if (c2.isEnabled()) {
                g2.setColor(this.darkShadowColor);
                g2.drawLine(0, 0, trackBounds.width - 1, 0);
                g2.drawLine(0, 1, 0, trackBounds.height - 2);
                g2.drawLine(0, trackBounds.height - 2, trackBounds.width - 1, trackBounds.height - 2);
                g2.drawLine(trackBounds.width - 1, 1, trackBounds.width - 1, trackBounds.height - 1);
                g2.setColor(this.shadowColor);
                g2.drawLine(1, 1, trackBounds.width - 2, 1);
                g2.drawLine(1, 1, 1, trackBounds.height - 3);
                g2.drawLine(0, trackBounds.height - 1, trackBounds.width - 1, trackBounds.height - 1);
                if (this.scrollbar.getValue() != this.scrollbar.getMaximum()) {
                    int x2 = this.thumbRect.x + this.thumbRect.width - trackBounds.x;
                    g2.drawLine(x2, 1, x2, trackBounds.height - 1);
                }
            } else {
                PlasticUtils.drawDisabledBorder(g2, 0, 0, trackBounds.width, trackBounds.height);
            }
            if (!this.isFreeStanding) {
                trackBounds.height -= 2;
            }
        }
        g2.translate(-trackBounds.x, -trackBounds.y);
    }

    @Override
    protected void paintThumb(Graphics g2, JComponent c2, Rectangle thumbBounds) {
        if (!c2.isEnabled()) {
            return;
        }
        boolean leftToRight = PlasticUtils.isLeftToRight(c2);
        g2.translate(thumbBounds.x, thumbBounds.y);
        if (this.scrollbar.getOrientation() == 1) {
            if (!this.isFreeStanding) {
                if (!leftToRight) {
                    ++thumbBounds.width;
                    g2.translate(-1, 0);
                } else {
                    thumbBounds.width += 2;
                }
            }
            g2.setColor(this.thumbColor);
            g2.fillRect(0, 0, thumbBounds.width - 2, thumbBounds.height - 1);
            g2.setColor(this.thumbShadow);
            g2.drawRect(0, 0, thumbBounds.width - 2, thumbBounds.height - 1);
            g2.setColor(this.thumbHighlightColor);
            g2.drawLine(1, 1, thumbBounds.width - 3, 1);
            g2.drawLine(1, 1, 1, thumbBounds.height - 2);
            this.paintBumps(g2, c2, 3, 4, thumbBounds.width - 6, thumbBounds.height - 7);
            if (!this.isFreeStanding) {
                if (!leftToRight) {
                    --thumbBounds.width;
                    g2.translate(1, 0);
                } else {
                    thumbBounds.width -= 2;
                }
            }
        } else {
            if (!this.isFreeStanding) {
                thumbBounds.height += 2;
            }
            g2.setColor(this.thumbColor);
            g2.fillRect(0, 0, thumbBounds.width - 1, thumbBounds.height - 2);
            g2.setColor(this.thumbShadow);
            g2.drawRect(0, 0, thumbBounds.width - 1, thumbBounds.height - 2);
            g2.setColor(this.thumbHighlightColor);
            g2.drawLine(1, 1, thumbBounds.width - 2, 1);
            g2.drawLine(1, 1, 1, thumbBounds.height - 3);
            this.paintBumps(g2, c2, 4, 3, thumbBounds.width - 7, thumbBounds.height - 6);
            if (!this.isFreeStanding) {
                thumbBounds.height -= 2;
            }
        }
        g2.translate(-thumbBounds.x, -thumbBounds.y);
        if (PlasticUtils.is3D(PROPERTY_PREFIX)) {
            this.paintThumb3D(g2, thumbBounds);
        }
    }

    private void paintBumps(Graphics g2, JComponent c2, int x2, int y2, int width, int height) {
        if (!PlasticScrollBarUI.useNarrowBumps()) {
            this.bumps.setBumpArea(width, height);
            this.bumps.paintIcon(c2, g2, x2, y2);
        } else {
            int maxWidth = UIManager.getInt(MAX_BUMPS_WIDTH_KEY);
            int myWidth = Math.min(maxWidth, width);
            int myHeight = Math.min(maxWidth, height);
            int myX = x2 + (width - myWidth) / 2;
            int myY = y2 + (height - myHeight) / 2;
            this.bumps.setBumpArea(myWidth, myHeight);
            this.bumps.paintIcon(c2, g2, myX, myY);
        }
    }

    private void paintThumb3D(Graphics g2, Rectangle thumbBounds) {
        boolean isHorizontal = this.scrollbar.getOrientation() == 0;
        int width = thumbBounds.width - (isHorizontal ? 3 : 1);
        int height = thumbBounds.height - (isHorizontal ? 1 : 3);
        Rectangle r2 = new Rectangle(thumbBounds.x + 2, thumbBounds.y + 2, width, height);
        PlasticUtils.addLight3DEffekt(g2, r2, isHorizontal);
    }

    private static boolean useNarrowBumps() {
        Object value = UIManager.get(MAX_BUMPS_WIDTH_KEY);
        return value != null && value instanceof Integer;
    }
}

